/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PsiClassUtil {
    private PsiClassUtil() {
    }

    public static boolean isRunnableClass(PsiClass aClass2, boolean mustBePublic) {
        return PsiClassUtil.isRunnableClass(aClass2, mustBePublic, true);
    }

    public static boolean isRunnableClass(PsiClass aClass2, boolean mustBePublic, boolean mustNotBeAbstract) {
        if (aClass2 instanceof PsiAnonymousClass) {
            return false;
        }
        if (mustBePublic && !aClass2.hasModifierProperty("public") && (mustNotBeAbstract || !aClass2.hasModifierProperty("abstract"))) {
            return false;
        }
        if (aClass2.hasModifierProperty("private")) {
            return false;
        }
        if (mustNotBeAbstract && aClass2.hasModifierProperty("abstract")) {
            return false;
        }
        return aClass2.getContainingClass() == null || aClass2.hasModifierProperty("static");
    }

    @NotNull
    public static Comparator<PsiClass> createScopeComparator(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/util/PsiClassUtil", "createScopeComparator"));
        }
        Comparator comparator = (c1, c2) -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/util/PsiClassUtil", "lambda$createScopeComparator$0"));
            }
            VirtualFile file1 = PsiUtilCore.getVirtualFile(c1);
            VirtualFile file2 = PsiUtilCore.getVirtualFile(c2);
            if (file1 == null) {
                return file2 == null ? 0 : -1;
            }
            if (file2 == null) {
                return 1;
            }
            return scope.compare(file2, file1);
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiClassUtil", "createScopeComparator"));
        }
        return comparator;
    }
}

