/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.extensions.DeclarationAttributeAltererExtension;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.OperatorModifierChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.PublishedApiUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;

public class ModifiersChecker {
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final Iterable<DeclarationChecker> declarationCheckers;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    private static boolean isIllegalNestedClass(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ModifiersChecker.$$$reportNull$$$0(0);
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
        return containingClass.isInner() || DescriptorUtils.isLocal(containingClass);
    }

    @NotNull
    public static Modality resolveMemberModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(1);
        }
        if (bindingContext == null) {
            ModifiersChecker.$$$reportNull$$$0(2);
        }
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierListOwner, defaultModality, bindingContext, containingDescriptor, false);
        if (modality == null) {
            ModifiersChecker.$$$reportNull$$$0(3);
        }
        return modality;
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor, boolean allowSealed) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(4);
        }
        if (bindingContext == null) {
            ModifiersChecker.$$$reportNull$$$0(5);
        }
        KtModifierList modifierList = modifierListOwner != null ? modifierListOwner.getModifierList() : null;
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality, allowSealed);
        if (modifierListOwner != null) {
            List extensions = DeclarationAttributeAltererExtension.Companion.getInstances(modifierListOwner.getProject());
            DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, modifierListOwner);
            for (DeclarationAttributeAltererExtension extension : extensions) {
                Modality newModality = extension.refineDeclarationModality(modifierListOwner, descriptor2, containingDescriptor, modality, bindingContext, false);
                if (newModality == null) continue;
                modality = newModality;
                break;
            }
        }
        Modality modality2 = modality;
        if (modality2 == null) {
            ModifiersChecker.$$$reportNull$$$0(6);
        }
        return modality2;
    }

    @NotNull
    private static Modality resolveModalityFromModifiers(@Nullable KtModifierList modifierList, @NotNull Modality defaultModality, boolean allowSealed) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(7);
        }
        if (modifierList == null) {
            Modality modality = defaultModality;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(8);
            }
            return modality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (allowSealed && modifierList.hasModifier(KtTokens.SEALED_KEYWORD)) {
            Modality modality = Modality.SEALED;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(9);
            }
            return modality;
        }
        if (modifierList.hasModifier(KtTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                Modality modality = Modality.ABSTRACT;
                if (modality == null) {
                    ModifiersChecker.$$$reportNull$$$0(10);
                }
                return modality;
            }
            Modality modality = Modality.OPEN;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(11);
            }
            return modality;
        }
        if (hasAbstractModifier) {
            Modality modality = Modality.ABSTRACT;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(12);
            }
            return modality;
        }
        boolean hasFinalModifier = modifierList.hasModifier(KtTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            Modality modality = Modality.OPEN;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(13);
            }
            return modality;
        }
        if (hasFinalModifier) {
            Modality modality = Modality.FINAL;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(14);
            }
            return modality;
        }
        Modality modality = defaultModality;
        if (modality == null) {
            ModifiersChecker.$$$reportNull$$$0(15);
        }
        return modality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull KtModifierListOwner modifierListOwner, @NotNull Visibility defaultVisibility) {
        if (modifierListOwner == null) {
            ModifiersChecker.$$$reportNull$$$0(16);
        }
        if (defaultVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(17);
        }
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
        if (visibility == null) {
            ModifiersChecker.$$$reportNull$$$0(18);
        }
        return visibility;
    }

    public static Visibility resolveVisibilityFromModifiers(@Nullable KtModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (defaultVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(19);
        }
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(KtTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(KtTokens.PROTECTED_KEYWORD)) {
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public ModifiersChecker(@NotNull AnnotationChecker annotationChecker, @NotNull Iterable<DeclarationChecker> declarationCheckers, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (annotationChecker == null) {
            ModifiersChecker.$$$reportNull$$$0(20);
        }
        if (declarationCheckers == null) {
            ModifiersChecker.$$$reportNull$$$0(21);
        }
        if (languageVersionSettings == null) {
            ModifiersChecker.$$$reportNull$$$0(22);
        }
        this.annotationChecker = annotationChecker;
        this.declarationCheckers = declarationCheckers;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public ModifiersCheckingProcedure withTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            ModifiersChecker.$$$reportNull$$$0(23);
        }
        ModifiersCheckingProcedure modifiersCheckingProcedure = new ModifiersCheckingProcedure(trace);
        if (modifiersCheckingProcedure == null) {
            ModifiersChecker.$$$reportNull$$$0(24);
        }
        return modifiersCheckingProcedure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultModality";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/ModifiersChecker";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationCheckers";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/ModifiersChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberModalityFromModifiers";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModalityFromModifiers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVisibilityFromModifiers";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "withTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIllegalNestedClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberModalityFromModifiers";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 24: {
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveModalityFromModifiers";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveVisibilityFromModifiers";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withTrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ModifiersCheckingProcedure {
        private final BindingTrace trace;

        private ModifiersCheckingProcedure(@NotNull BindingTrace trace) {
            if (trace == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(0);
            }
            this.trace = trace;
        }

        public void checkParameterHasNoValOrVar(@NotNull KtValVarKeywordOwner parameter, @NotNull DiagnosticFactory1<PsiElement, KtKeywordToken> diagnosticFactory) {
            PsiElement valOrVar;
            if (parameter == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(1);
            }
            if (diagnosticFactory == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(2);
            }
            if ((valOrVar = parameter.getValOrVarKeyword()) != null) {
                this.trace.report(diagnosticFactory.on(valOrVar, (KtKeywordToken)valOrVar.getNode().getElementType()));
            }
        }

        public void checkModifiersForDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor2) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(4);
            }
            this.checkNestedClassAllowed(modifierListOwner, descriptor2);
            this.checkObjectInsideInnerClass(modifierListOwner, descriptor2);
            this.checkTypeParametersModifiers(modifierListOwner);
            this.checkModifierListCommon(modifierListOwner, descriptor2);
            this.checkIllegalHeader(modifierListOwner, descriptor2);
        }

        private void checkObjectInsideInnerClass(@NotNull KtDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor2) {
            KtObjectDeclaration ktObject;
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(5);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(6);
            }
            if (modifierListOwner instanceof KtObjectDeclaration && !(ktObject = (KtObjectDeclaration)modifierListOwner).isLocal() && ModifiersChecker.isIllegalNestedClass(descriptor2)) {
                this.trace.report(Errors.NESTED_OBJECT_NOT_ALLOWED.on(ktObject));
            }
        }

        private void checkModifierListCommon(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(7);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(8);
            }
            AnnotationUseSiteTargetChecker.INSTANCE.check(modifierListOwner, descriptor2, this.trace);
            this.runDeclarationCheckers(modifierListOwner, descriptor2);
            ModifiersChecker.this.annotationChecker.check(modifierListOwner, this.trace, descriptor2);
            ModifierCheckerCore.INSTANCE.check(modifierListOwner, this.trace, descriptor2, ModifiersChecker.this.languageVersionSettings);
        }

        public void checkModifiersForLocalDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(9);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(10);
            }
            this.checkModifierListCommon(modifierListOwner, descriptor2);
        }

        public void checkModifiersForDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration) {
            if (multiDeclaration == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(11);
            }
            ModifiersChecker.this.annotationChecker.check(multiDeclaration, this.trace, null);
            ModifierCheckerCore.INSTANCE.check(multiDeclaration, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            for (KtDestructuringDeclarationEntry multiEntry : multiDeclaration.getEntries()) {
                ModifiersChecker.this.annotationChecker.check(multiEntry, this.trace, null);
                ModifierCheckerCore.INSTANCE.check(multiEntry, this.trace, null, ModifiersChecker.this.languageVersionSettings);
                UnderscoreChecker.INSTANCE.checkNamed(multiEntry, this.trace, ModifiersChecker.this.languageVersionSettings, true);
            }
        }

        private void checkIllegalHeader(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            KtModifierList modifierList;
            PsiElement keyword;
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(12);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(13);
            }
            PsiElement psiElement = keyword = (modifierList = modifierListOwner.getModifierList()) != null ? modifierList.getModifier(KtTokens.HEADER_KEYWORD) : null;
            if (keyword != null && descriptor2 instanceof ClassDescriptor && descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                this.trace.report(Errors.WRONG_MODIFIER_TARGET.on(keyword, KtTokens.HEADER_KEYWORD, "nested class"));
            }
        }

        private void checkNestedClassAllowed(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(14);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(15);
            }
            if (modifierListOwner.hasModifier(KtTokens.INNER_KEYWORD)) {
                return;
            }
            if (modifierListOwner instanceof KtClass && !(modifierListOwner instanceof KtEnumEntry)) {
                boolean localEnumError;
                KtClass aClass2 = (KtClass)modifierListOwner;
                boolean bl = localEnumError = aClass2.isLocal() && aClass2.isEnum();
                if (!localEnumError && ModifiersChecker.isIllegalNestedClass(descriptor2)) {
                    this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(aClass2));
                }
            }
        }

        @NotNull
        public Map<KtModifierKeywordToken, PsiElement> getTokensCorrespondingToModifiers(@NotNull KtModifierList modifierList, @NotNull Collection<KtModifierKeywordToken> possibleModifiers) {
            if (modifierList == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(16);
            }
            if (possibleModifiers == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(17);
            }
            HashMap<KtModifierKeywordToken, PsiElement> tokens = Maps.newHashMap();
            for (KtModifierKeywordToken modifier : possibleModifiers) {
                if (!modifierList.hasModifier(modifier)) continue;
                tokens.put(modifier, modifierList.getModifier(modifier));
            }
            HashMap<KtModifierKeywordToken, PsiElement> hashMap = tokens;
            if (hashMap == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(18);
            }
            return hashMap;
        }

        public void runDeclarationCheckers(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
            if (declaration == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(19);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(20);
            }
            for (DeclarationChecker checker : ModifiersChecker.this.declarationCheckers) {
                checker.check(declaration, descriptor2, this.trace, this.trace.getBindingContext(), ModifiersChecker.this.languageVersionSettings);
            }
            OperatorModifierChecker.INSTANCE.check(declaration, descriptor2, this.trace, ModifiersChecker.this.languageVersionSettings);
            PublishedApiUsageChecker.INSTANCE.check(declaration, descriptor2, this.trace);
        }

        public void checkTypeParametersModifiers(@NotNull KtModifierListOwner modifierListOwner) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(21);
            }
            if (!(modifierListOwner instanceof KtTypeParameterListOwner)) {
                return;
            }
            List<KtTypeParameter> typeParameters2 = ((KtTypeParameterListOwner)modifierListOwner).getTypeParameters();
            for (KtTypeParameter typeParameter : typeParameters2) {
                ModifierCheckerCore.INSTANCE.check(typeParameter, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnosticFactory";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 14: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierListOwner";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 15: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "multiDeclaration";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierList";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "possibleModifiers";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokensCorrespondingToModifiers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkParameterHasNoValOrVar";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForDeclaration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "checkObjectInsideInnerClass";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifierListCommon";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForLocalDeclaration";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForDestructuringDeclaration";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "checkIllegalHeader";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "checkNestedClassAllowed";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getTokensCorrespondingToModifiers";
                    break;
                }
                case 18: {
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "runDeclarationCheckers";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "checkTypeParametersModifiers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

