// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Expr_BinaryExpression_HeaderFile
#define _Expr_BinaryExpression_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Expr_BinaryExpression.hxx>

#include <Handle_Expr_GeneralExpression.hxx>
#include <Expr_GeneralExpression.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Expr_NamedUnknown.hxx>
class Expr_GeneralExpression;
class Standard_OutOfRange;
class Standard_NumericError;
class Expr_InvalidOperand;
class Expr_NamedUnknown;


//! Defines all binary expressions. The order of the two
//! operands is significant.
class Expr_BinaryExpression : public Expr_GeneralExpression
{

public:

  
     const  Handle(Expr_GeneralExpression)& FirstOperand()  const;
  
     const  Handle(Expr_GeneralExpression)& SecondOperand()  const;
  
  //! Sets first operand of <me>
  //! Raises InvalidOperand if exp = me
  Standard_EXPORT   void SetFirstOperand (const Handle(Expr_GeneralExpression)& exp) ;
  
  //! Sets second operand of <me>
  //! Raises InvalidOperand if <exp> contains <me>.
  Standard_EXPORT   void SetSecondOperand (const Handle(Expr_GeneralExpression)& exp) ;
  
  //! returns the number of sub-expressions contained
  //! in <me> ( >= 0)
  Standard_EXPORT   Standard_Integer NbSubExpressions()  const;
  
  //! returns the <I>-th sub-expression of <me>
  //! raises OutOfRange if <I> > NbSubExpressions(me)
  Standard_EXPORT  const  Handle(Expr_GeneralExpression)& SubExpression (const Standard_Integer I)  const;
  
  //! Does <me> contain NamedUnknown ?
  Standard_EXPORT   Standard_Boolean ContainsUnknowns()  const;
  
  //! Tests if <me> contains <exp>.
  Standard_EXPORT   Standard_Boolean Contains (const Handle(Expr_GeneralExpression)& exp)  const;
  
  //! Replaces all occurences of <var> with <with> in <me>.
  //! Raises InvalidOperand if <with> contains <me>.
  Standard_EXPORT   void Replace (const Handle(Expr_NamedUnknown)& var, const Handle(Expr_GeneralExpression)& with) ;
  
  //! Returns a GeneralExpression after replacement of
  //! NamedUnknowns by an associated expression and after
  //! values computation.
  Standard_EXPORT   Handle(Expr_GeneralExpression) Simplified()  const;




  DEFINE_STANDARD_RTTI(Expr_BinaryExpression)

protected:

  
  //! Sets first operand of <me>
  Standard_EXPORT   void CreateFirstOperand (const Handle(Expr_GeneralExpression)& exp) ;
  
  //! Sets second operand of <me>
  //! Raises InvalidOperand if <exp> contains <me>.
  Standard_EXPORT   void CreateSecondOperand (const Handle(Expr_GeneralExpression)& exp) ;



private: 


  Handle(Expr_GeneralExpression) myFirstOperand;
  Handle(Expr_GeneralExpression) mySecondOperand;


};


#include <Expr_BinaryExpression.lxx>





#endif // _Expr_BinaryExpression_HeaderFile
