// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESDimen_NewDimensionedGeometry_HeaderFile
#define _IGESDimen_NewDimensionedGeometry_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESDimen_NewDimensionedGeometry.hxx>

#include <Standard_Integer.hxx>
#include <Handle_IGESData_IGESEntity.hxx>
#include <Standard_Real.hxx>
#include <Handle_IGESData_HArray1OfIGESEntity.hxx>
#include <Handle_TColStd_HArray1OfInteger.hxx>
#include <Handle_TColgp_HArray1OfXYZ.hxx>
#include <IGESData_IGESEntity.hxx>
class IGESData_IGESEntity;
class IGESData_HArray1OfIGESEntity;
class TColStd_HArray1OfInteger;
class TColgp_HArray1OfXYZ;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class gp_Pnt;


//! defines New Dimensioned Geometry, Type <402>, Form <21>
//! in package IGESDimen
//! Links a dimension entity with the geometry entities it
//! is dimensioning, so that later, in the receiving
//! database, the dimension can be automatically recalculated
//! and redrawn should the geometry be changed.
class IGESDimen_NewDimensionedGeometry : public IGESData_IGESEntity
{

public:

  
  Standard_EXPORT IGESDimen_NewDimensionedGeometry();
  
  //! This method is used to set the fields of the class
  //! NewDimensionedGeometry
  //! - nbDimen       : Number of Dimensions, default = 1
  //! - aDimen        : Dimension Entity
  //! - anOrientation : Dimension Orientation Flag
  //! - anAngle       : Angle Value
  //! - allEntities   : Geometric Entities
  //! - allLocations  : Dimension Location Flags
  //! - allPoints     : Points on the Geometry Entities
  //! exception raised if lengths of entities, locations, points
  //! are not the same
  Standard_EXPORT   void Init (const Standard_Integer nbDimens, const Handle(IGESData_IGESEntity)& aDimen, const Standard_Integer anOrientation, const Standard_Real anAngle, const Handle(IGESData_HArray1OfIGESEntity)& allEntities, const Handle(TColStd_HArray1OfInteger)& allLocations, const Handle(TColgp_HArray1OfXYZ)& allPoints) ;
  
  //! returns the number of dimensions
  Standard_EXPORT   Standard_Integer NbDimensions()  const;
  
  //! returns the number of associated geometry entities
  Standard_EXPORT   Standard_Integer NbGeometries()  const;
  
  //! returns the dimension entity
  Standard_EXPORT   Handle(IGESData_IGESEntity) DimensionEntity()  const;
  
  //! returns the dimension orientation flag
  Standard_EXPORT   Standard_Integer DimensionOrientationFlag()  const;
  
  //! returns the angle value
  Standard_EXPORT   Standard_Real AngleValue()  const;
  
  //! returns the Index'th geometry entity
  //! raises exception if Index <= 0 or Index > NbGeometries()
  Standard_EXPORT   Handle(IGESData_IGESEntity) GeometryEntity (const Standard_Integer Index)  const;
  
  //! returns the Index'th geometry entity's dimension location flag
  //! raises exception if Index <= 0 or Index > NbGeometries()
  Standard_EXPORT   Standard_Integer DimensionLocationFlag (const Standard_Integer Index)  const;
  
  //! coordinate of point on Index'th geometry entity
  //! raises exception if Index <= 0 or Index > NbGeometries()
  Standard_EXPORT   gp_Pnt Point (const Standard_Integer Index)  const;
  
  //! coordinate of point on Index'th geometry entity after Transformation
  //! raises exception if Index <= 0 or Index > NbGeometries()
  Standard_EXPORT   gp_Pnt TransformedPoint (const Standard_Integer Index)  const;




  DEFINE_STANDARD_RTTI(IGESDimen_NewDimensionedGeometry)

protected:




private: 


  Standard_Integer theNbDimensions;
  Handle(IGESData_IGESEntity) theDimensionEntity;
  Standard_Integer theDimensionOrientationFlag;
  Standard_Real theAngleValue;
  Handle(IGESData_HArray1OfIGESEntity) theGeometryEntities;
  Handle(TColStd_HArray1OfInteger) theDimensionLocationFlags;
  Handle(TColgp_HArray1OfXYZ) thePoints;


};







#endif // _IGESDimen_NewDimensionedGeometry_HeaderFile
