type token =
  | TComment of (Parse_info.info)
  | TCommentNewline of (Parse_info.info)
  | TCommentSpace of (Parse_info.info)
  | TInt of (string * Parse_info.info)
  | TFloat of (string * Parse_info.info)
  | TChar of (string * Parse_info.info)
  | TString of (string * Parse_info.info)
  | LITERAL of ((string * Parse_info.info))
  | IDENTIFIER of ((string * Parse_info.info))
  | PRIMITIVE_TYPE of ((string * Parse_info.info))
  | LP of (Parse_info.info)
  | RP of (Parse_info.info)
  | LC of (Parse_info.info)
  | RC of (Parse_info.info)
  | LB of (Parse_info.info)
  | RB of (Parse_info.info)
  | SM of (Parse_info.info)
  | CM of (Parse_info.info)
  | DOT of (Parse_info.info)
  | EQ of (Parse_info.info)
  | GT of (Parse_info.info)
  | LT of (Parse_info.info)
  | NOT of (Parse_info.info)
  | COMPL of (Parse_info.info)
  | COND of (Parse_info.info)
  | COLON of (Parse_info.info)
  | EQ_EQ of (Parse_info.info)
  | LE of (Parse_info.info)
  | GE of (Parse_info.info)
  | NOT_EQ of (Parse_info.info)
  | AND_AND of (Parse_info.info)
  | OR_OR of (Parse_info.info)
  | INCR of (Parse_info.info)
  | DECR of (Parse_info.info)
  | PLUS of (Parse_info.info)
  | MINUS of (Parse_info.info)
  | TIMES of (Parse_info.info)
  | DIV of (Parse_info.info)
  | AND of (Parse_info.info)
  | OR of (Parse_info.info)
  | XOR of (Parse_info.info)
  | MOD of (Parse_info.info)
  | LS of (Parse_info.info)
  | SRS of (Parse_info.info)
  | URS of (Parse_info.info)
  | AT of (Parse_info.info)
  | DOTS of (Parse_info.info)
  | LB_RB of (Parse_info.info)
  | LT2 of (Parse_info.info)
  | OPERATOR_EQ of ((string * Parse_info.info))
  | ABSTRACT of (Parse_info.info)
  | BOOLEAN of (Parse_info.info)
  | BREAK of (Parse_info.info)
  | BYTE of (Parse_info.info)
  | CASE of (Parse_info.info)
  | CATCH of (Parse_info.info)
  | CHAR of (Parse_info.info)
  | CLASS of (Parse_info.info)
  | CONST of (Parse_info.info)
  | CONTINUE of (Parse_info.info)
  | DEFAULT of (Parse_info.info)
  | DO of (Parse_info.info)
  | DOUBLE of (Parse_info.info)
  | ELSE of (Parse_info.info)
  | EXTENDS of (Parse_info.info)
  | FINAL of (Parse_info.info)
  | FINALLY of (Parse_info.info)
  | FLOAT of (Parse_info.info)
  | FOR of (Parse_info.info)
  | GOTO of (Parse_info.info)
  | IF of (Parse_info.info)
  | IMPLEMENTS of (Parse_info.info)
  | IMPORT of (Parse_info.info)
  | INSTANCEOF of (Parse_info.info)
  | INT of (Parse_info.info)
  | INTERFACE of (Parse_info.info)
  | LONG of (Parse_info.info)
  | NATIVE of (Parse_info.info)
  | NEW of (Parse_info.info)
  | PACKAGE of (Parse_info.info)
  | PRIVATE of (Parse_info.info)
  | PROTECTED of (Parse_info.info)
  | PUBLIC of (Parse_info.info)
  | RETURN of (Parse_info.info)
  | SHORT of (Parse_info.info)
  | STATIC of (Parse_info.info)
  | STRICTFP of (Parse_info.info)
  | SUPER of (Parse_info.info)
  | SWITCH of (Parse_info.info)
  | SYNCHRONIZED of (Parse_info.info)
  | THIS of (Parse_info.info)
  | THROW of (Parse_info.info)
  | THROWS of (Parse_info.info)
  | TRANSIENT of (Parse_info.info)
  | TRY of (Parse_info.info)
  | VOID of (Parse_info.info)
  | VOLATILE of (Parse_info.info)
  | WHILE of (Parse_info.info)
  | ASSERT of (Parse_info.info)
  | ENUM of (Parse_info.info)
  | TUnknown of (Parse_info.info)
  | EOF of (Parse_info.info)

val goal :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_java.program
