// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `FileParser.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * <tt>icegridadmin</tt> provides a {@link FileParser}
 * object to transform XML files into {@link ApplicationDescriptor}
 * objects.
 *
 **/
public interface FileParserPrx extends Ice.ObjectPrx
{
    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @return The application descriptor.
     *
     * @throws ParseException Raised if an error occurred during parsing.
     *
     **/
    public ApplicationDescriptor parse(String xmlFile, AdminPrx adminProxy)
        throws ParseException;

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     *
     * @throws ParseException Raised if an error occurred during parsing.
     *
     **/
    public ApplicationDescriptor parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> context)
        throws ParseException;

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> context);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, Ice.Callback cb);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, Callback_FileParser_parse cb);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> context, Callback_FileParser_parse cb);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile,
                                       AdminPrx adminProxy,
                                       IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile,
                                       AdminPrx adminProxy,
                                       IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile,
                                       AdminPrx adminProxy,
                                       java.util.Map<String, String> context,
                                       IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Parse a file.
     *
     * @param xmlFile Full pathname to the file.
     *
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile,
                                       AdminPrx adminProxy,
                                       java.util.Map<String, String> context,
                                       IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Parse a file.
     *
     * @param result The asynchronous result object.
     * @return The application descriptor.
     *
     * @throws ParseException Raised if an error occurred during parsing.
     *
     **/
    public ApplicationDescriptor end_parse(Ice.AsyncResult result)
        throws ParseException;
}
