/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKStageListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PopupStage;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class GlassStage
implements TKStage {
    protected static List<GlassStage> windows = new ArrayList<GlassStage>();
    private static List<TKStage> topLevelWindows = new ArrayList<TKStage>();
    private List<PopupStage> popups = new LinkedList<PopupStage>();
    private static List<GlassStage> activeWindows = new LinkedList<GlassStage>();
    private static boolean firstWindowVisible = false;
    protected boolean verbose;
    protected GlassScene scene;
    protected TKStageListener stageListener;
    private boolean visible;
    private boolean important = true;
    private AccessControlContext accessCtrlCtx = null;

    protected GlassStage(boolean bl) {
        this.verbose = bl;
        windows.add(this);
    }

    @Override
    public void setTKStageListener(TKStageListener tKStageListener) {
        this.stageListener = tKStageListener;
    }

    @Override
    public void setScene(TKScene tKScene) {
        if (this.scene != null) {
            this.scene.setGlassStage(null);
        }
        this.scene = (GlassScene)tKScene;
        if (this.scene != null) {
            this.scene.setGlassStage(this);
        }
    }

    protected void setPlatformWindowClosed() {
    }

    final AccessControlContext getAccessControlContext() {
        if (this.accessCtrlCtx == null) {
            throw new RuntimeException("Stage security context has not been set!");
        }
        return this.accessCtrlCtx;
    }

    @Override
    public final void setSecurityContext(AccessControlContext accessControlContext) {
        if (this.accessCtrlCtx != null) {
            throw new RuntimeException("Stage security context has been already set!");
        }
        this.accessCtrlCtx = QuantumToolkit.intersectWithCurrentContext(accessControlContext);
        if (this.accessCtrlCtx == null) {
            throw new RuntimeException("Cannot initialize Stage security context (old JDK?)");
        }
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void requestFocus(FocusCause focusCause) {
    }

    static void addActiveWindow(GlassStage glassStage) {
        activeWindows.remove(glassStage);
        activeWindows.add(glassStage);
    }

    static void removeActiveWindow(GlassStage glassStage) {
        activeWindows.remove(glassStage);
    }

    final void handleFocusDisabled() {
        if (activeWindows.isEmpty()) {
            return;
        }
        GlassStage glassStage = activeWindows.get(activeWindows.size() - 1);
        glassStage.setIconified(false);
        glassStage.requestToFront();
        glassStage.requestFocus();
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isImportant() && this.isTopLevel();
        boolean bl3 = this.visible != bl;
        this.visible = bl;
        if (bl) {
            firstWindowVisible = true;
            if (bl3 && bl2) {
                topLevelWindows.add(this);
                GlassStage.notifyWindowListeners();
            }
        }
        if (!bl) {
            GlassStage.removeActiveWindow(this);
            if (bl3 && bl2) {
                topLevelWindows.remove(this);
                GlassStage.notifyWindowListeners();
            }
        }
        if (this.scene != null) {
            this.scene.stageVisible(bl);
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    protected abstract void setPlatformEnabled(boolean var1);

    protected abstract void requestToFront();

    @Override
    public void close() {
        windows.remove(this);
        topLevelWindows.remove(this);
        GlassStage.notifyWindowListeners();
    }

    static boolean windowsAreOpen() {
        for (GlassStage glassStage : windows) {
            if (!glassStage.isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isTopLevel() {
        return true;
    }

    @Override
    public void setImportant(boolean bl) {
        this.important = bl;
    }

    public boolean isImportant() {
        return this.important;
    }

    private static void notifyWindowListeners() {
        Toolkit.getToolkit().notifyWindowListeners(topLevelWindows);
    }

    protected void addPopup(PopupStage popupStage) {
        this.popups.add(popupStage);
    }

    protected void removePopup(PopupStage popupStage) {
        this.popups.remove(popupStage);
    }

    static void requestClosingAllWindows() {
        for (final GlassStage glassStage : windows.toArray(new GlassStage[windows.size()])) {
            if (!glassStage.isVisible() || glassStage.stageListener == null) continue;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    glassStage.stageListener.closing();
                    return null;
                }
            }, glassStage.getAccessControlContext());
        }
    }
}

