/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.parosproxy.paros.core.scanner.Alert;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class AlertTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon LEAF_ICON = DisplayUtils.getScaledIcon(new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/document.png")));
    private static final ImageIcon FOLDER_OPEN_ICON = DisplayUtils.getScaledIcon(new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-open.png")));
    private static final ImageIcon FOLDER_CLOSED_ICON = DisplayUtils.getScaledIcon(new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal.png")));

    public AlertTreeCellRenderer() {
        this.putClientProperty("html.disable", Boolean.TRUE);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (object instanceof AlertNode) {
            AlertNode alertNode = (AlertNode)object;
            if (alertNode.isRoot()) {
                if (bl2) {
                    this.setIcon(FOLDER_OPEN_ICON);
                } else {
                    this.setIcon(FOLDER_CLOSED_ICON);
                }
            } else if (alertNode.getParent().isRoot()) {
                Alert alert = alertNode.getUserObject();
                this.setIcon(alert.getIcon());
            } else {
                this.setIcon(LEAF_ICON);
            }
        }
        return this;
    }
}

