/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ApiResponseSet<T>
extends ApiResponse {
    private Map<String, T> values = null;

    public ApiResponseSet(String string, Map<String, T> map) {
        super(string);
        this.values = map;
    }

    @Override
    public JSON toJSON() {
        if (this.values == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, T> entry : this.values.entrySet()) {
            jSONObject.put((Object)entry.getKey(), entry.getValue());
        }
        return jSONObject;
    }

    @Override
    public void toXML(Document document, Element element) {
        element.setAttribute("type", "set");
        for (Map.Entry<String, T> entry : this.values.entrySet()) {
            Element element2 = document.createElement(entry.getKey());
            String string = entry.getValue() == null ? "" : entry.getValue().toString();
            Text text = document.createTextNode(XMLStringUtil.escapeControlChrs(string));
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }

    @Override
    public void toHTML(StringBuilder stringBuilder) {
        stringBuilder.append("<h2>" + StringEscapeUtils.escapeHtml((String)this.getName()) + "</h2>\n");
        stringBuilder.append("<table border=\"1\">\n");
        for (Map.Entry<String, T> entry : this.values.entrySet()) {
            stringBuilder.append("<tr><td>\n");
            stringBuilder.append(StringEscapeUtils.escapeHtml((String)entry.getKey()));
            stringBuilder.append("</td><td>\n");
            T t = entry.getValue();
            if (t != null) {
                stringBuilder.append(StringEscapeUtils.escapeHtml((String)t.toString()));
            }
            stringBuilder.append("</td></tr>\n");
        }
        stringBuilder.append("</table>\n");
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("ApiResponseSet ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" : [\n");
        for (Map.Entry<String, T> entry : this.values.entrySet()) {
            for (int i = 0; i < n + 1; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" = ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\n");
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    Map<String, T> getValues() {
        return this.values;
    }
}

