/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class JavaAPIGenerator
extends AbstractAPIGenerator {
    private static final String TARGET_PACKAGE = "org/zaproxy/clientapi/gen";
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-java/subprojects/zap-clientapi/src/main/java/org/zaproxy/clientapi/gen";
    private static final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private static final Map<String, String> nameMap;

    public JavaAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public JavaAPIGenerator(String string, boolean bl) {
        super(string, bl);
    }

    @Deprecated
    public void generateJavaFiles(List<ApiImplementor> list) throws IOException {
        this.generateAPIFiles((List)list);
    }

    private void generateJavaElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        boolean bl;
        block37: {
            bl = false;
            String string3 = apiElement.getDescriptionTag();
            if (string3 == null) {
                string3 = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                Iterator<String> iterator = this.getMessages().getString(string3);
                writer.write("\t/**\n");
                writer.write("\t * " + (String)((Object)iterator) + "\n");
                if (this.isOptional()) {
                    writer.write("\t * <p>\n");
                    writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                }
                if (apiElement.isDeprecated()) {
                    writer.write("\t * @deprecated");
                    String string4 = apiElement.getDeprecatedDescription();
                    if (string4 != null && !string4.isEmpty()) {
                        writer.write(" " + string4);
                    }
                    writer.write("\n");
                }
                writer.write("\t */\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string3);
                if (!this.isOptional()) break block37;
                writer.write("\t/**\n");
                writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                writer.write("\t */\n");
            }
        }
        if (apiElement.isDeprecated()) {
            writer.write("\t@Deprecated\n");
        }
        if (string2.equals("other")) {
            writer.write("\tpublic byte[] " + JavaAPIGenerator.createMethodName(apiElement.getName()) + "(");
        } else {
            writer.write("\tpublic ApiResponse " + JavaAPIGenerator.createMethodName(apiElement.getName()) + "(");
        }
        if (apiElement.getMandatoryParamNames() != null) {
            for (String string4 : apiElement.getMandatoryParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                if (string4.toLowerCase().equals("boolean")) {
                    writer.write("boolean bool");
                    continue;
                }
                if (string4.toLowerCase().equals("integer")) {
                    writer.write("int i");
                    continue;
                }
                writer.write("String ");
                writer.write(string4.toLowerCase());
            }
        }
        if (apiElement.getOptionalParamNames() != null) {
            for (String string4 : apiElement.getOptionalParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                if (string4.toLowerCase().equals("boolean")) {
                    writer.write("boolean bool");
                    continue;
                }
                if (string4.toLowerCase().equals("integer")) {
                    writer.write("int i");
                    continue;
                }
                writer.write("String ");
                writer.write(string4.toLowerCase());
            }
        }
        writer.write(") throws ClientApiException {\n");
        if (bl) {
            writer.write("\t\tMap<String, String> map = new HashMap<>();\n");
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string4 : apiElement.getMandatoryParamNames()) {
                    writer.write("\t\tmap.put(\"" + string4 + "\", ");
                    if (string4.toLowerCase().equals("boolean")) {
                        writer.write("Boolean.toString(bool)");
                    } else if (string4.toLowerCase().equals("integer")) {
                        writer.write("Integer.toString(i)");
                    } else {
                        writer.write(string4.toLowerCase());
                    }
                    writer.write(");\n");
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string4 : apiElement.getOptionalParamNames()) {
                    writer.write("\t\tif (");
                    writer.write(string4.toLowerCase());
                    writer.write(" != null) {\n");
                    writer.write("\t\t\tmap.put(\"" + string4 + "\", ");
                    if (string4.toLowerCase().equals("boolean")) {
                        writer.write("Boolean.toString(bool)");
                    } else if (string4.toLowerCase().equals("integer")) {
                        writer.write("Integer.toString(i)");
                    } else {
                        writer.write(string4.toLowerCase());
                    }
                    writer.write(");\n");
                    writer.write("\t\t}\n");
                }
            }
        }
        writer.write("\t\treturn api.callApi");
        if (string2.equals("other")) {
            writer.write("Other");
        }
        writer.write("(\"" + string + "\", \"" + string2 + "\", \"" + apiElement.getName() + "\"");
        if (bl) {
            writer.write(", map);\n");
        } else {
            writer.write(", null);\n");
        }
        writer.write("\t}\n\n");
    }

    private static String createMethodName(String string) {
        if (nameMap.containsKey(string)) {
            string = nameMap.get(string);
        }
        return JavaAPIGenerator.removeAllFullStopCharacters(string);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    @Override
    protected void generateAPIFiles(ApiImplementor apiImplementor) throws IOException {
        String string = apiImplementor.getPrefix().substring(0, 1).toUpperCase() + apiImplementor.getPrefix().substring(1);
        Path path = this.getDirectory().resolve(string + ".java");
        System.out.println("Generating " + path.toAbsolutePath());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write(HEADER);
            bufferedWriter.write("package org.zaproxy.clientapi.gen;\n\n");
            bufferedWriter.write("import java.util.HashMap;\n");
            bufferedWriter.write("import java.util.Map;\n");
            bufferedWriter.write("import org.zaproxy.clientapi.core.ApiResponse;\n");
            bufferedWriter.write("import org.zaproxy.clientapi.core.ClientApi;\n");
            bufferedWriter.write("import org.zaproxy.clientapi.core.ClientApiException;\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("/**\n");
            bufferedWriter.write(" * This file was automatically generated.\n");
            bufferedWriter.write(" */\n");
            bufferedWriter.write("@SuppressWarnings(\"javadoc\")\n");
            bufferedWriter.write("public class " + string);
            boolean bl = false;
            if (Files.exists(path.resolveSibling(Paths.get("deprecated", string + "Deprecated.java")), new LinkOption[0])) {
                bufferedWriter.write(" extends org.zaproxy.clientapi.gen.deprecated." + string + "Deprecated");
                bl = true;
            }
            bufferedWriter.write(" {\n\n");
            bufferedWriter.write("\tprivate final ClientApi api;\n\n");
            bufferedWriter.write("\tpublic " + string + "(ClientApi api) {\n");
            if (bl) {
                bufferedWriter.write("\t\tsuper(api);\n");
            }
            bufferedWriter.write("\t\tthis.api = api;\n");
            bufferedWriter.write("\t}\n\n");
            for (ApiElement apiElement : apiImplementor.getApiViews()) {
                this.generateJavaElement(apiElement, apiImplementor.getPrefix(), "view", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiActions()) {
                this.generateJavaElement(apiElement, apiImplementor.getPrefix(), "action", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                this.generateJavaElement(apiElement, apiImplementor.getPrefix(), "other", bufferedWriter);
            }
            bufferedWriter.write("}\n");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (!Files.exists(Paths.get(DEFAULT_OUTPUT_DIR, new String[0]), new LinkOption[0])) {
            System.err.println("The directory does not exist: " + Paths.get(DEFAULT_OUTPUT_DIR, new String[0]).toAbsolutePath());
            System.exit(1);
        }
        JavaAPIGenerator javaAPIGenerator = new JavaAPIGenerator();
        javaAPIGenerator.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        hashMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

