/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class ExtensionParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(ExtensionParam.class);
    private static final String EXTENSION_BASE_KEY = "extensions";
    private static final String ALL_EXTENSIONS_KEY = "extensions.extension";
    private static final String EXTENSION_NAME_KEY = "name";
    private static final String EXTENSION_ENABLED_KEY = "enabled";
    private Map<String, Boolean> extensionsState = Collections.emptyMap();

    @Override
    protected void parse() {
        try {
            List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_EXTENSIONS_KEY);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                if (hierarchicalConfiguration.getBoolean(EXTENSION_ENABLED_KEY, true)) continue;
                hashMap.put(hierarchicalConfiguration.getString(EXTENSION_NAME_KEY, ""), Boolean.FALSE);
            }
            this.extensionsState = Collections.unmodifiableMap(hashMap);
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)("Error while loading extensions' state: " + conversionException.getMessage()), (Throwable)conversionException);
            this.extensionsState = Collections.emptyMap();
        }
    }

    public boolean isExtensionEnabled(String string) {
        Boolean bl = this.extensionsState.get(string);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    void setExtensionsState(Map<String, Boolean> map) {
        if (map == null) {
            throw new IllegalArgumentException("Parameter extensionsState must not be null.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_EXTENSIONS_KEY);
        int n = 0;
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().booleanValue()) continue;
            String string = "extensions.extension(" + n + ").";
            this.getConfig().setProperty(string + EXTENSION_NAME_KEY, (Object)entry.getKey());
            this.getConfig().setProperty(string + EXTENSION_ENABLED_KEY, (Object)Boolean.FALSE);
            ++n;
        }
        this.extensionsState = Collections.unmodifiableMap(map);
    }

    @Override
    public ExtensionParam clone() {
        return (ExtensionParam)super.clone();
    }
}

