/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderPanelTableModel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ScanListenner;
import org.zaproxy.zap.model.ScanThread;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class SpiderThread
extends ScanThread
implements SpiderListener {
    private boolean stopScan = false;
    private boolean isPaused = false;
    private boolean isAlive = false;
    private ExtensionSpider extension;
    private Spider spider = null;
    private List<SpiderListener> pendingSpiderListeners;
    private int spiderDone = 0;
    private int spiderTodo = 1;
    private static final Logger log = Logger.getLogger(SpiderThread.class);
    private boolean justScanInScope = false;
    private boolean scanChildren = false;
    private Context scanContext = null;
    private User scanUser = null;
    private SpiderPanelTableModel resultsModel;
    private URI startURI = null;
    private SpiderParam spiderParams;
    private List<SpiderParser> customSpiderParsers = null;
    private List<FetchFilter> customFetchFilters = null;
    private List<ParseFilter> customParseFilters = null;
    private final String id;

    @Deprecated
    public SpiderThread(ExtensionSpider extensionSpider, SpiderParam spiderParam, String string, ScanListenner scanListenner) {
        this("?", extensionSpider, spiderParam, string, scanListenner);
    }

    public SpiderThread(String string, ExtensionSpider extensionSpider, SpiderParam spiderParam, String string2, ScanListenner scanListenner) {
        super(string2, scanListenner);
        log.debug((Object)("Initializing spider thread for site: " + string2));
        this.id = string;
        this.extension = extensionSpider;
        this.site = string2;
        this.pendingSpiderListeners = new LinkedList<SpiderListener>();
        this.resultsModel = extensionSpider.getView() != null ? new SpiderPanelTableModel() : null;
        this.spiderParams = spiderParam;
        this.setName("ZAP-SpiderInitThread-" + string);
    }

    @Override
    public void run() {
        try {
            this.runScan();
        }
        catch (Exception exception) {
            log.error((Object)"An error occurred while starting the spider:", (Throwable)exception);
            this.stopScan();
        }
    }

    private void runScan() {
        this.spiderDone = 0;
        Date date = new Date();
        log.info((Object)("Starting spidering scan on " + this.site + " at " + date));
        this.startSpider();
        this.isAlive = true;
    }

    @Override
    public void stopScan() {
        if (this.spider != null) {
            this.spider.stop();
        }
        this.stopScan = true;
        this.isAlive = false;
        this.listenner.scanFinshed(this.site);
    }

    @Override
    public boolean isStopped() {
        return this.stopScan;
    }

    @Override
    public boolean isRunning() {
        return this.isAlive;
    }

    public DefaultListModel<?> getList() {
        return null;
    }

    @Override
    public void pauseScan() {
        if (this.spider != null) {
            this.spider.pause();
        }
        this.isPaused = true;
    }

    @Override
    public void resumeScan() {
        if (this.spider != null) {
            this.spider.resume();
        }
        this.isPaused = false;
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public int getMaximum() {
        return this.spiderDone + this.spiderTodo;
    }

    private void startSpider() {
        this.spider = new Spider(this.id, this.extension, this.spiderParams, this.extension.getModel().getOptionsParam().getConnectionParam(), this.extension.getModel(), this.scanContext);
        this.spider.addSpiderListener(this);
        for (SpiderListener iterator : this.pendingSpiderListeners) {
            this.spider.addSpiderListener(iterator);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.extension.getExcludeList());
        arrayList.addAll(this.extension.getModel().getSession().getExcludeFromSpiderRegexs());
        arrayList.addAll(this.extension.getModel().getSession().getGlobalExcludeURLRegexs());
        this.spider.setExcludeList(arrayList);
        this.addSeeds();
        this.spider.setScanAsUser(this.scanUser);
        if (this.customSpiderParsers != null) {
            for (SpiderParser spiderParser : this.customSpiderParsers) {
                this.spider.addCustomParser(spiderParser);
            }
        }
        if (this.customFetchFilters != null) {
            for (FetchFilter fetchFilter : this.customFetchFilters) {
                this.spider.addFetchFilter(fetchFilter);
            }
        }
        if (this.customParseFilters != null) {
            for (ParseFilter parseFilter : this.customParseFilters) {
                this.spider.addParseFilter(parseFilter);
            }
        }
        this.spider.start();
    }

    private void addSeeds() {
        this.addStartSeeds();
        List<Object> list = Collections.emptyList();
        if (this.scanContext != null) {
            log.debug((Object)("Adding seed for Scan of all in context " + this.scanContext.getName()));
            list = this.scanContext.getNodesInContextFromSiteTree();
        } else if (this.justScanInScope) {
            log.debug((Object)"Adding seed for Scan of all in scope.");
            list = Model.getSingleton().getSession().getNodesInScopeFromSiteTree();
        }
        if (!list.isEmpty()) {
            for (SiteNode siteNode : list) {
                this.addSeed(siteNode);
            }
        }
    }

    private void addStartSeeds() {
        if (this.scanContext != null) {
            if (this.startNode != null && this.scanContext.isInContext(this.startNode)) {
                this.addSeed(this.startNode);
            }
            if (this.startURI != null && this.scanContext.isInContext(this.startURI.toString())) {
                this.spider.addSeed(this.startURI);
            }
            return;
        }
        if (this.justScanInScope) {
            if (this.startNode != null && Model.getSingleton().getSession().isInScope(this.startNode)) {
                this.addSeed(this.startNode);
            }
            if (this.startURI != null && Model.getSingleton().getSession().isInScope(this.startURI.toString())) {
                this.spider.addSeed(this.startURI);
            }
            return;
        }
        if (this.startNode != null) {
            this.addSeeds(this.startNode);
        }
        if (this.startURI != null) {
            this.spider.addSeed(this.startURI);
        }
    }

    private void addSeed(SiteNode siteNode) {
        try {
            HttpMessage httpMessage;
            if (!siteNode.isRoot() && siteNode.getHistoryReference() != null && !(httpMessage = siteNode.getHistoryReference().getHttpMessage()).getResponseHeader().isImage()) {
                this.spider.addSeed(httpMessage);
            }
        }
        catch (Exception exception) {
            log.error((Object)("Error while adding seed for Spider scan: " + exception.getMessage()), (Throwable)exception);
        }
    }

    private void addSeeds(SiteNode siteNode) {
        this.addSeed(siteNode);
        if (this.scanChildren) {
            Enumeration<TreeNode> enumeration = siteNode.children();
            while (enumeration.hasMoreElements()) {
                SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
                this.addSeeds(siteNode2);
            }
        }
    }

    @Override
    public void spiderComplete(boolean bl) {
        log.info((Object)("Spider scanning complete: " + bl));
        this.stopScan = true;
        this.isAlive = false;
        this.listenner.scanFinshed(this.site);
    }

    @Override
    public void foundURI(String string, String string2, FetchFilter.FetchStatus fetchStatus) {
        if (this.resultsModel != null) {
            this.addUriToResultsModel(string, string2, fetchStatus);
        }
    }

    private void addUriToResultsModel(final String string, final String string2, final FetchFilter.FetchStatus fetchStatus) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpiderThread.this.addUriToResultsModel(string, string2, fetchStatus);
                }
            });
            return;
        }
        if (fetchStatus == FetchFilter.FetchStatus.VALID) {
            this.resultsModel.addScanResult(string, string2, null, false);
        } else {
            this.resultsModel.addScanResult(string, string2, this.getStatusLabel(fetchStatus), fetchStatus != FetchFilter.FetchStatus.SEED);
        }
        this.extension.getSpiderPanel().updateFoundCount();
    }

    private String getStatusLabel(FetchFilter.FetchStatus fetchStatus) {
        switch (fetchStatus) {
            case SEED: {
                return Constant.messages.getString("spider.table.flags.seed");
            }
            case OUT_OF_CONTEXT: {
                return Constant.messages.getString("spider.table.flags.outofcontext");
            }
            case OUT_OF_SCOPE: {
                return Constant.messages.getString("spider.table.flags.outofscope");
            }
            case ILLEGAL_PROTOCOL: {
                return Constant.messages.getString("spider.table.flags.illegalprotocol");
            }
            case USER_RULES: {
                return Constant.messages.getString("spider.table.flags.userrules");
            }
        }
        return fetchStatus.toString();
    }

    @Override
    public void readURI(HttpMessage httpMessage) {
        try {
            int n = httpMessage.isResponseFromTargetHost() ? 2 : 19;
            HistoryReference historyReference = new HistoryReference(this.extension.getModel().getSession(), n, httpMessage);
            if (httpMessage.isResponseFromTargetHost()) {
                SpiderThread.addMessageToSitesTree(historyReference, httpMessage);
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private static void addMessageToSitesTree(final HistoryReference historyReference, final HttpMessage httpMessage) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpiderThread.addMessageToSitesTree(historyReference, httpMessage);
                }
            });
            return;
        }
        SessionStructure.addPath(Model.getSingleton().getSession(), historyReference, httpMessage);
    }

    @Override
    public void spiderProgress(int n, int n2, int n3) {
        this.spiderDone = n2;
        this.spiderTodo = n3;
        this.scanProgress(this.site, n2, n2 + n3);
    }

    @Override
    public SiteNode getStartNode() {
        return this.startNode;
    }

    @Override
    public void setStartNode(SiteNode siteNode) {
        this.startNode = siteNode;
    }

    public void setStartURI(URI uRI) {
        this.startURI = uRI;
    }

    @Override
    public void reset() {
        if (this.resultsModel != null) {
            this.resultsModel.removeAllElements();
        }
    }

    public void addSpiderListener(SpiderListener spiderListener) {
        if (this.spider != null) {
            this.spider.addSpiderListener(spiderListener);
        } else {
            this.pendingSpiderListeners.add(spiderListener);
        }
    }

    @Override
    public void setJustScanInScope(boolean bl) {
        this.justScanInScope = bl;
    }

    @Override
    public boolean getJustScanInScope() {
        return this.justScanInScope;
    }

    @Override
    public void setScanChildren(boolean bl) {
        this.scanChildren = bl;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public SpiderPanelTableModel getResultsTableModel() {
        return this.resultsModel;
    }

    @Override
    public void setScanContext(Context context) {
        this.scanContext = context;
    }

    @Override
    public void setScanAsUser(User user) {
        this.scanUser = user;
    }

    @Override
    public void setTechSet(TechSet techSet) {
    }

    public void setCustomSpiderParsers(List<SpiderParser> list) {
        this.customSpiderParsers = list;
    }

    public void setCustomFetchFilters(List<FetchFilter> list) {
        this.customFetchFilters = list;
    }

    public void setCustomParseFilters(List<ParseFilter> list) {
        this.customParseFilters = list;
    }
}

