// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceBox;

/**
 * Administers a set of {@link Service} instances.
 *
 * @see Service
 *
 **/
public interface ServiceManagerPrx extends Ice.ObjectPrx
{
    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums();

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> context);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums();

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback cb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_ServiceManager_getSliceChecksums cb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context, Callback_ServiceManager_getSliceChecksums cb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param result The asynchronous result object.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult result);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStartedException If the service is already running.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    public void startService(String service)
        throws AlreadyStartedException,
               NoSuchServiceException;

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStartedException If the service is already running.
     * @throws NoSuchServiceException If no service could be found with the given name.
     * @param context The Context map to send with the invocation.
     **/
    public void startService(String service, java.util.Map<String, String> context)
        throws AlreadyStartedException,
               NoSuchServiceException;

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service, java.util.Map<String, String> context);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service, Ice.Callback cb);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service, Callback_ServiceManager_startService cb);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service, java.util.Map<String, String> context, Callback_ServiceManager_startService cb);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startService(String service,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Start an individual service.
     *
     * @param result The asynchronous result object.
     * @throws AlreadyStartedException If the service is already running.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    public void end_startService(Ice.AsyncResult result)
        throws AlreadyStartedException,
               NoSuchServiceException;

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStoppedException If the service is already stopped.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    public void stopService(String service)
        throws AlreadyStoppedException,
               NoSuchServiceException;

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStoppedException If the service is already stopped.
     * @throws NoSuchServiceException If no service could be found with the given name.
     * @param context The Context map to send with the invocation.
     **/
    public void stopService(String service, java.util.Map<String, String> context)
        throws AlreadyStoppedException,
               NoSuchServiceException;

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service, java.util.Map<String, String> context);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service, Ice.Callback cb);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service, Callback_ServiceManager_stopService cb);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service, java.util.Map<String, String> context, Callback_ServiceManager_stopService cb);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopService(String service,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Stop an individual service.
     *
     * @param result The asynchronous result object.
     * @throws AlreadyStoppedException If the service is already stopped.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    public void end_stopService(Ice.AsyncResult result)
        throws AlreadyStoppedException,
               NoSuchServiceException;

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     **/
    public void addObserver(ServiceObserverPrx observer);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param context The Context map to send with the invocation.
     **/
    public void addObserver(ServiceObserverPrx observer, java.util.Map<String, String> context);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, java.util.Map<String, String> context);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, Ice.Callback cb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, Callback_ServiceManager_addObserver cb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, java.util.Map<String, String> context, Callback_ServiceManager_addObserver cb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param result The asynchronous result object.
     **/
    public void end_addObserver(Ice.AsyncResult result);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     **/
    public void shutdown();

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void shutdown(java.util.Map<String, String> context);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown();

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(Ice.Callback cb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(Callback_ServiceManager_shutdown cb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context, Callback_ServiceManager_shutdown cb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context,
                                          IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context,
                                          IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param result The asynchronous result object.
     **/
    public void end_shutdown(Ice.AsyncResult result);
}
