/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.gephi.graph.impl.Serialization;

public final class DataInputOutput
implements DataInput,
DataOutput,
ObjectInput,
ObjectOutput {
    private int pos = 0;
    private int count = 0;
    private byte[] buf;

    public DataInputOutput() {
        this.buf = new byte[8];
    }

    public DataInputOutput(byte[] data) {
        this.buf = data;
        this.count = data.length;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public int getPos() {
        return this.pos;
    }

    public DataInputOutput reset() {
        this.pos = 0;
        this.count = 0;
        return this;
    }

    public void resetForReading() {
        this.count = this.pos;
        this.pos = 0;
    }

    public DataInputOutput reset(byte[] b) {
        this.pos = 0;
        this.buf = b;
        this.count = b.length;
        return this;
    }

    public byte[] toByteArray() {
        byte[] d = new byte[this.pos];
        System.arraycopy(this.buf, 0, d, 0, this.pos);
        return d;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.pos += n;
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buf[this.pos++] == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buf[this.pos++];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return (short)((short)(this.buf[this.pos++] & 0xFF) << 8 | (short)(this.buf[this.pos++] & 0xFF) << 0);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (this.buf[this.pos++] & 0xFF) << 8 | (this.buf[this.pos++] & 0xFF) << 0;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readInt();
    }

    @Override
    public int readInt() throws IOException {
        return (this.buf[this.pos++] & 0xFF) << 24 | (this.buf[this.pos++] & 0xFF) << 16 | (this.buf[this.pos++] & 0xFF) << 8 | (this.buf[this.pos++] & 0xFF) << 0;
    }

    @Override
    public long readLong() throws IOException {
        return (long)(this.buf[this.pos++] & 0xFF) << 56 | (long)(this.buf[this.pos++] & 0xFF) << 48 | (long)(this.buf[this.pos++] & 0xFF) << 40 | (long)(this.buf[this.pos++] & 0xFF) << 32 | (long)(this.buf[this.pos++] & 0xFF) << 24 | (long)(this.buf[this.pos++] & 0xFF) << 16 | (long)(this.buf[this.pos++] & 0xFF) << 8 | (long)(this.buf[this.pos++] & 0xFF) << 0;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        return this.readUTF();
    }

    @Override
    public String readUTF() throws IOException {
        return Serialization.deserializeString(this);
    }

    private void ensureAvail(int n) {
        if (this.pos + n >= this.buf.length) {
            int newSize = Math.max(this.pos + n, this.buf.length * 2);
            this.buf = Arrays.copyOf(this.buf, newSize);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureAvail(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)v;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureAvail(2);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v >> 0);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeInt(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureAvail(4);
        this.buf[this.pos++] = (byte)(0xFF & v >> 24);
        this.buf[this.pos++] = (byte)(0xFF & v >> 16);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v >> 0);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureAvail(8);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 56);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 48);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 40);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 32);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 24);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 16);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 8);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 0);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.ensureAvail(4);
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.ensureAvail(8);
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        Serialization.serializeString(this, s);
    }

    public void writeFromByteBuffer(ByteBuffer b, int offset, int length) {
        this.ensureAvail(length);
        b.position(offset);
        b.get(this.buf, this.pos, length);
        this.pos += length;
    }

    @Override
    public int read() throws IOException {
        return this.readUnsignedByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.readFully(b);
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readFully(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void writeObject(Object o) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }
}

