/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;

public class FontDataAsciiReader {
    private byte[] buffer;
    private int cursor;
    private FontDataInputSource inputSource;
    private long readPosition;
    private boolean eol;

    public FontDataAsciiReader(FontDataInputSource inputSource) {
        this(inputSource, 4096);
    }

    public FontDataAsciiReader(FontDataInputSource inputSource, int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException();
        }
        if (inputSource == null) {
            throw new NullPointerException();
        }
        this.buffer = new byte[bufferSize];
        this.cursor = bufferSize;
        this.inputSource = inputSource;
        this.readPosition = 0L;
    }

    private int read() throws IOException {
        if ((long)this.cursor >= this.inputSource.getLength()) {
            return -1;
        }
        if (this.cursor >= this.buffer.length) {
            int readableLength = Math.min(this.buffer.length, (int)Math.min(Integer.MAX_VALUE, this.inputSource.getLength() - this.readPosition));
            if (readableLength == 0) {
                return -1;
            }
            this.inputSource.readFullyAt(this.readPosition, this.buffer, readableLength);
            if (readableLength == 0) {
                return -1;
            }
            this.readPosition += (long)readableLength;
            this.cursor = 0;
        }
        int retval = 0xFF & this.buffer[this.cursor];
        ++this.cursor;
        return retval;
    }

    public String readLine() throws IOException {
        int data = this.read();
        if (data == -1) {
            return null;
        }
        StringBuffer retval = new StringBuffer(150);
        while (data != -1) {
            if (data == 10) {
                this.eol = true;
                return retval.toString();
            }
            if (data == 13) {
                if (!this.eol) {
                    return retval.toString();
                }
                this.eol = false;
            } else {
                this.eol = false;
                if (data > 127) {
                    retval.append('?');
                } else {
                    retval.append((char)data);
                }
            }
            data = this.read();
        }
        return retval.toString();
    }
}

