/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.pfm;

import org.pentaho.reporting.libraries.fonts.pfm.PfmFont;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontHeader;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class PfmFontRecord
implements FontSource,
FontIdentifier {
    private DefaultFontFamily fontFamily;
    private boolean bold;
    private boolean italic;
    private String fontFile;
    private boolean embeddable;

    public PfmFontRecord(PfmFont font, DefaultFontFamily fontFamily) {
        this.embeddable = font.isEmbeddable();
        this.fontFile = font.getFilename();
        this.fontFamily = fontFamily;
        PfmFontHeader header = font.getHeader();
        this.bold = header.getWeight() > 400;
        this.italic = header.isItalic();
    }

    public FontFamily getFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isOblique() {
        return false;
    }

    public FontIdentifier getIdentifier() {
        return this;
    }

    public String getFontSource() {
        return this.fontFile;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public boolean isScalable() {
        return true;
    }

    public FontType getFontType() {
        return FontType.PFM;
    }
}

