/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolToJSmolInterface;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.Viewer;

class FileLoadThread
extends JmolThread {
    String fileName;
    private String cacheName;
    private String key;

    public FileLoadThread(JmolScriptEvaluator eval, Viewer vwr, String fileName, String key, String cacheName) {
        this.setViewer(vwr, "FileLoadThread");
        this.fileName = fileName;
        this.key = key;
        this.cacheName = cacheName;
        this.setEval(eval);
        --this.sc.pc;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    mode = 0;
                    break;
                }
                case 0: {
                    if (this.stopped || !this.vwr.testAsync && this.eval.isStopped()) {
                        mode = -2;
                        break;
                    }
                    JmolToJSmolInterface jmol = null;
                    if (jmol != null) {
                        jmol._loadFileAsynchronously(this, this.vwr.html5Applet, this.fileName, null);
                    }
                    if (this.vwr.testAsync) {
                        if (!this.runSleep(this.sleepTime, 1)) {
                            return;
                        }
                        mode = 1;
                        break;
                    }
                    return;
                }
                case 1: {
                    Object data = this.vwr.fm.getFileAsBytes(this.fileName, null);
                    this.setData(this.fileName, this.fileName, data, null);
                    return;
                }
                case -2: {
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    void setData(String fileName, String fileName0, Object data, Object myData) throws InterruptedException {
        boolean isCanceled = fileName.equals("#CANCELED#");
        this.sc.parentContext.htFileCache.put(this.key, isCanceled ? fileName : (this.cacheName = this.cacheName.substring(0, this.cacheName.lastIndexOf("_") + 1) + fileName));
        this.vwr.cachePut(this.cacheName, data);
        if (fileName0 != null) {
            this.vwr.cachePut(this.vwr.fm.getFilePath(fileName, true, false), data);
        }
        this.run1(-2);
    }
}

