/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class DeleteResponse
extends DocWriteResponse {
    private static final String FOUND = "found";

    public DeleteResponse() {
    }

    public DeleteResponse(ShardId shardId, String type, String id, long version, boolean found) {
        super(shardId, type, id, version, found ? DocWriteResponse.Result.DELETED : DocWriteResponse.Result.NOT_FOUND);
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.DELETED ? super.status() : RestStatus.NOT_FOUND;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FOUND, this.result == DocWriteResponse.Result.DELETED);
        super.innerToXContent(builder, params);
        return builder;
    }

    public static DeleteResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        Builder context = new Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            DeleteResponse.parseXContentFields(parser, context);
        }
        return context.build();
    }

    public static void parseXContentFields(XContentParser parser, Builder context) throws IOException {
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = parser.currentName();
        if (FOUND.equals(currentFieldName)) {
            if (token.isValue()) {
                context.setFound(parser.booleanValue());
            }
        } else {
            DocWriteResponse.parseInnerToXContent(parser, context);
        }
    }

    public static class Builder
    extends DocWriteResponse.Builder {
        private boolean found = false;

        public void setFound(boolean found) {
            this.found = found;
        }

        @Override
        public DeleteResponse build() {
            DeleteResponse deleteResponse = new DeleteResponse(this.shardId, this.type, this.id, (long)this.version, this.found);
            deleteResponse.setForcedRefresh(this.forcedRefresh);
            if (this.shardInfo != null) {
                deleteResponse.setShardInfo(this.shardInfo);
            }
            return deleteResponse;
        }
    }
}

