

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Save and restore waypoint lists (stack){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Save and restore waypoint lists (stack)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_reverse.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_simplify.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_stack"></a>Save and restore waypoint lists (stack)</h2></div></div></div><p> 
This filter is designed to solve advanced problems that involve shuffling 
multiple lists of waypoints, tracks, or routes.  
</p><p>
The stack filter can be used to save the current state of the entire
collection of data.  That state is placed on top of a stack of collections,
so you can simultaneously have as many stored collections of data as you
can fit in your computer's memory.
</p><p> 
 The stack filter can be used in conjunction with other
 filters to implement a "union" or "logical or" functionality.
 The basic idea is to use the stack to store copies of the
 original list of waypoints, then use the 'swap' function to
 replace each copy with a filtered list.  Finally, append all
 of the filtered lists to create one big list, which is then
 output.  The following example finds a list of all points
 that are either inside county A or inside county B.  Any
 points that are inside both counties are duplicated (but the
 duplicates can be removed with the DUPLICATE filter; see
 above.)
</p><p><strong class="userinput"><code>           
gpsbabel -i gpx -f in.gpx 
         -x stack,push,copy 
         -x polygon,file=county_a.txt 
         -x stack,swap 
         -x polygon,file=county_b.txt 
         -x stack,pop,append 
         -o gpx -F out.gpx
</code></strong></p><p> This example reads a large list of waypoints and
         extracts the points within 20 miles of each of two cities,
         writing the waypoint descriptions into two different PalmDoc
         files and exporting all of the points to the GPS receiver:
</p><p><strong class="userinput"><code>           
gpsbabel -i gpx -f indiana.gpx 
         -x stack,push,copy 
         -x radius,lat=41.0765,lon=-85.1365,distance=20m 
         -o palmdoc,dbname=Fort\ Wayne -F fortwayne.pdb 
         -x stack,swap 
         -x radius,lat=39.7733,lon=-86.1433,distance=20m 
         -o palmdoc,dbname=Indianapolis -F indianapolis.pdb 
         -x stack,pop,append 
         -o magellan -F fwaind.wpt
</code></strong></p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_push"></a>push option</h3></div></div></div><p>
      Push waypoint list onto stack.
    </p><p>
This is one of three "primary" options to the stack filter.
</p><p>
When this option is specified, the current state is pushed onto the top of
the stack.  By default, the current state is then cleared, but the 
<code class="option">copy</code> option can be used to cause it to be saved.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_pop"></a>pop option</h3></div></div></div><p>
      Pop waypoint list from stack.
    </p><p>
This is one of three "primary" options to the stack filter.
</p><p>
This option "pops" the collection of data from the top of the stack.  
By default, the saved state replaces the current state, but see the 
<code class="option">discard</code> and <code class="option">append</code> options for 
alternatives.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_swap"></a>swap option</h3></div></div></div><p>
      Swap waypoint list with &lt;depth&gt; item on stack.
    </p><p>
This is one of three "primary" options to the stack filter.
</p><p>
When this option is specified, the current state is swapped with a saved
state from the stack.  By default, it is swapped with the top of the stack,
but the <code class="option">depth</code> can be used to specify a different saved
state.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_copy"></a>copy option</h3></div></div></div><p>
      (push) Copy waypoint list.
    </p><p>
This option is only valid when used with the <code class="option">push</code> option.
When this option is specified, a copy of the current state is pushed onto 
the stack but the current state is left unchanged.  Otherwise, the push 
operation clears the current data collection.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_append"></a>append option</h3></div></div></div><p>
      (pop) Append list.
    </p><p>
This option is only valid in conjunction with the <code class="option">pop</code>.  
When it is specified, the topmost collection of data from the stack is
appended to the current collection of data.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_discard"></a>discard option</h3></div></div></div><p>
      (pop) Discard top of stack.
    </p><p>
This option is only valid when used with the <code class="option">pop</code> option.
When this option is specified, the popped state is discarded and the current
state remains unchanged.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_replace"></a>replace option</h3></div></div></div><p>
      (pop) Replace list (default).
    </p><p>
This option is only valid when used with the <code class="option">pop</code> option.
This is the default behavior of the <code class="option">pop</code> option, so you 
should never need to specify it, but it is included for the sake of 
readability.  When this option is specified, the popped state replaces 
the current state.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_stack_o_depth"></a>depth option</h3></div></div></div><p>
      (swap) Item to use (default=1).
    </p><p>
This option is only valid when used along with the <code class="option">swap</code>
option.  If specified, it indicates which item on the stack should be
swapped with the current state.  The default value is 1, which corresponds
to the top of the stack.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_reverse.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_simplify.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Reverse stops within routes (reverse) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Simplify routes (simplify)</td></tr></table></div>
  
      {/literal}{/block}
  