/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.reflect;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.proxy.EntityProxy;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.springframework.cglib.reflect.FastClass;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.ReflectionUtils;

public class FieldEntityAccess
implements EntityAccess {
    private static Map<String, EntityReflector> REFLECTORS = new ConcurrentHashMap<String, EntityReflector>();
    private final PersistentEntity persistentEntity;
    private final Object entity;
    private final ConversionService conversionService;
    private final EntityReflector reflector;

    public FieldEntityAccess(PersistentEntity persistentEntity, Object entity, ConversionService conversionService) {
        this.persistentEntity = persistentEntity;
        this.entity = entity;
        this.conversionService = conversionService;
        this.reflector = FieldEntityAccess.getOrIntializeReflector(persistentEntity);
    }

    public static void clearReflectors() {
        REFLECTORS.clear();
    }

    public static EntityReflector getOrIntializeReflector(PersistentEntity persistentEntity) {
        String entityName = persistentEntity.getName();
        EntityReflector entityReflector = REFLECTORS.get(entityName);
        if (entityReflector == null) {
            entityReflector = new FieldEntityReflector(persistentEntity);
            REFLECTORS.put(entityName, entityReflector);
        }
        return entityReflector;
    }

    public static EntityReflector getReflector(String name) {
        return REFLECTORS.get(name);
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public Object getProperty(String name) {
        Object object = FieldEntityAccess.unwrapIfProxy(this.entity);
        return this.reflector.getProperty(object, name);
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getProperty(name);
    }

    @Override
    public Class getPropertyType(String name) {
        PersistentProperty property = this.persistentEntity.getPropertyByName(name);
        if (property != null) {
            return property.getType();
        }
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
        Object converted;
        EntityReflector.PropertyWriter writer = this.reflector.getPropertyWriter(name);
        try {
            converted = this.conversionService.convert(value, writer.propertyType());
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Cannot assign value [" + value + "] to property [" + name + "] of type [" + writer.propertyType().getName() + "] of class [" + this.persistentEntity.getName() + "]. The value could not be converted to the appropriate type: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot assign value [" + value + "] to property [" + name + "] of type [" + writer.propertyType().getName() + "] of class [" + this.persistentEntity.getName() + "]. The value is not an acceptable type: " + e.getMessage(), e);
        }
        writer.write(this.entity, converted);
    }

    @Override
    public Object getIdentifier() {
        return this.reflector.getIdentifier(this.entity);
    }

    @Override
    public void setIdentifier(Object id) {
        Object converted;
        try {
            converted = this.conversionService.convert(id, this.reflector.identifierType());
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Cannot assign identifier [" + id + "] to property [" + this.reflector.getIdentifierName() + "] of type [" + this.reflector.identifierType().getName() + "] of class [" + this.persistentEntity.getName() + "]. The value could not be converted to the appropriate type: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot assign identifier [" + id + "] to property [" + this.reflector.getIdentifierName() + "] of type [" + this.reflector.identifierType().getName() + "] of class [" + this.persistentEntity.getName() + "]. The identifier is not an compatible type: " + e.getMessage(), e);
        }
        this.reflector.setIdentifier(this.entity, converted);
    }

    @Override
    public void setIdentifierNoConversion(Object id) {
        try {
            this.reflector.setIdentifier(this.entity, id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot assign identifier [" + id + "] to property [" + this.reflector.getIdentifierName() + "] of type [" + this.reflector.identifierType().getName() + "] of class [" + this.persistentEntity.getName() + "]. The identifier is not an compatible type: " + e.getMessage(), e);
        }
    }

    @Override
    public String getIdentifierName() {
        return this.reflector.getIdentifierName();
    }

    @Override
    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void setPropertyNoConversion(String name, Object value) {
        try {
            this.reflector.setProperty(this.entity, name, value);
        }
        catch (Exception e) {
            String valueType = value != null ? value.getClass().getName() : null;
            throw new IllegalArgumentException("Cannot assign value [" + value + "] with type [" + valueType + "] to property [" + name + "] of class [" + this.persistentEntity.getName() + "]. The value is not an acceptable type: " + e.getMessage(), e);
        }
    }

    protected static Object unwrapIfProxy(Object object) {
        Object target;
        if (object instanceof EntityProxy && (target = ((EntityProxy)object).getTarget()) != null) {
            object = target;
        }
        return object;
    }

    static class FieldEntityReflector
    implements EntityReflector {
        final PersistentEntity entity;
        final EntityReflector.PropertyReader[] readers;
        final EntityReflector.PropertyWriter[] writers;
        final EntityReflector.PropertyReader identifierReader;
        final EntityReflector.PropertyWriter identifierWriter;
        final String identifierName;
        final Class identifierType;
        final Map<String, EntityReflector.PropertyReader> readerMap = new HashMap<String, EntityReflector.PropertyReader>();
        final Map<String, EntityReflector.PropertyWriter> writerMap = new HashMap<String, EntityReflector.PropertyWriter>();
        final Field dirtyCheckingStateField;
        FastClass fastClass;

        public FieldEntityReflector(PersistentEntity entity) {
            this.entity = entity;
            PersistentProperty identity = entity.getIdentity();
            this.dirtyCheckingStateField = ReflectionUtils.findField((Class)entity.getJavaClass(), (String)this.getTraitFieldName(DirtyCheckable.class, "$changedProperties"));
            if (this.dirtyCheckingStateField != null) {
                ReflectionUtils.makeAccessible((Field)this.dirtyCheckingStateField);
            }
            ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entity.getJavaClass());
            if (identity != null) {
                String identityName;
                this.identifierName = identityName = identity.getName();
                this.identifierType = identity.getType();
                ReaderAndWriterMaker readerAndWriterMaker = new ReaderAndWriterMaker(cpf, identityName).make();
                this.identifierReader = readerAndWriterMaker.getPropertyReader();
                this.identifierWriter = readerAndWriterMaker.getPropertyWriter();
                this.readerMap.put(this.identifierName, this.identifierReader);
                if (this.identifierWriter != null) {
                    this.writerMap.put(this.identifierName, this.identifierWriter);
                }
            } else {
                this.identifierName = null;
                this.identifierReader = null;
                this.identifierWriter = null;
                this.identifierType = null;
            }
            PersistentProperty[] composite = entity.getCompositeIdentity();
            if (composite != null) {
                for (PersistentProperty property : composite) {
                    String propertyName = property.getName();
                    ReaderAndWriterMaker readerAndWriterMaker = new ReaderAndWriterMaker(cpf, propertyName).make();
                    this.readerMap.put(propertyName, readerAndWriterMaker.getPropertyReader());
                    this.writerMap.put(propertyName, readerAndWriterMaker.getPropertyWriter());
                }
            }
            List<PersistentProperty> properties = entity.getPersistentProperties();
            this.readers = new EntityReflector.PropertyReader[properties.size()];
            this.writers = new EntityReflector.PropertyWriter[properties.size()];
            for (int i = 0; i < properties.size(); ++i) {
                PersistentProperty property = properties.get(i);
                String propertyName = property.getName();
                ReaderAndWriterMaker readerAndWriterMaker = new ReaderAndWriterMaker(cpf, propertyName).make();
                EntityReflector.PropertyReader reader = readerAndWriterMaker.getPropertyReader();
                EntityReflector.PropertyWriter writer = readerAndWriterMaker.getPropertyWriter();
                this.readers[i] = reader;
                this.readerMap.put(propertyName, reader);
                this.writers[i] = writer;
                this.writerMap.put(propertyName, writer);
            }
        }

        protected String getTraitFieldName(Traits.TraitBridge traitBridge, String fieldName) {
            Class traitClass = traitBridge.traitClass();
            return this.getTraitFieldName(traitClass, fieldName);
        }

        private String getTraitFieldName(Class traitClass, String fieldName) {
            return traitClass.getName().replace('.', '_') + "__" + fieldName;
        }

        @Override
        public PersistentEntity getPersitentEntity() {
            return this.entity;
        }

        @Override
        public Map<String, Object> getDirtyCheckingState(Object entity) {
            if (this.dirtyCheckingStateField != null) {
                try {
                    return (Map)this.dirtyCheckingStateField.get(entity);
                }
                catch (Throwable e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public FastClass fastClass() {
            if (this.fastClass == null) {
                this.fastClass = FastClass.create((Class)this.entity.getJavaClass());
            }
            return this.fastClass;
        }

        @Override
        public EntityReflector.PropertyReader getPropertyReader(String name) {
            EntityReflector.PropertyReader reader = this.readerMap.get(name);
            if (reader != null) {
                return reader;
            }
            throw new IllegalArgumentException("Property [" + name + "] is not a valid property of " + this.entity.getJavaClass());
        }

        @Override
        public EntityReflector.PropertyWriter getPropertyWriter(String name) {
            EntityReflector.PropertyWriter writer = this.writerMap.get(name);
            if (writer != null) {
                return writer;
            }
            throw new IllegalArgumentException("Property [" + name + "] is not a valid property of " + this.entity.getJavaClass());
        }

        @Override
        public Object getProperty(Object object, String name) {
            object = FieldEntityAccess.unwrapIfProxy(object);
            return this.getPropertyReader(name).read(object);
        }

        @Override
        public void setProperty(Object object, String name, Object value) {
            this.getPropertyWriter(name).write(object, value);
        }

        @Override
        public Class identifierType() {
            return this.identifierType;
        }

        @Override
        public Serializable getIdentifier(Object object) {
            if (this.identifierReader != null && object != null) {
                return (Serializable)this.identifierReader.read(object);
            }
            return null;
        }

        @Override
        public void setIdentifier(Object object, Object value) {
            if (this.identifierWriter != null) {
                this.identifierWriter.write(object, value);
            }
        }

        @Override
        public String getIdentifierName() {
            return this.identifierName;
        }

        @Override
        public Iterable<String> getPropertyNames() {
            return this.readerMap.keySet();
        }

        @Override
        public Object getProperty(Object object, int index) {
            return this.readers[index].read(object);
        }

        @Override
        public void setProperty(Object object, int index, Object value) {
            this.writers[index].write(object, value);
        }

        private class ReaderAndWriterMaker {
            private ClassPropertyFetcher cpf;
            private String propertyName;
            private EntityReflector.PropertyReader propertyReader;
            private EntityReflector.PropertyWriter propertyWriter;

            public ReaderAndWriterMaker(ClassPropertyFetcher cpf, String propertyName) {
                this.cpf = cpf;
                this.propertyName = propertyName;
            }

            public EntityReflector.PropertyReader getPropertyReader() {
                return this.propertyReader;
            }

            public EntityReflector.PropertyWriter getPropertyWriter() {
                return this.propertyWriter;
            }

            public ReaderAndWriterMaker make() {
                Class javaClass = this.cpf.getJavaClass();
                Field field = ReflectionUtils.findField((Class)javaClass, (String)this.propertyName);
                if (field != null) {
                    ReflectionUtils.makeAccessible((Field)field);
                    this.propertyReader = new FieldReader(field, ReflectionUtils.findMethod((Class)javaClass, (String)NameUtils.getGetterName(this.propertyName)));
                    this.propertyWriter = new FieldWriter(field, ReflectionUtils.findMethod((Class)javaClass, (String)NameUtils.getSetterName(this.propertyName), (Class[])new Class[]{field.getType()}));
                } else {
                    Method writeMethod;
                    Traits.Implemented traitImplemented;
                    PropertyDescriptor descriptor = this.cpf.getPropertyDescriptor(this.propertyName);
                    Method readMethod = descriptor.getReadMethod();
                    Traits.TraitBridge traitBridge = readMethod.getAnnotation(Traits.TraitBridge.class);
                    String traitFieldName = traitBridge != null ? FieldEntityReflector.this.getTraitFieldName(traitBridge, this.propertyName) : ((traitImplemented = readMethod.getAnnotation(Traits.Implemented.class)) != null ? FieldEntityReflector.this.getTraitFieldName(readMethod.getDeclaringClass(), this.propertyName) : null);
                    if (traitFieldName != null) {
                        field = ReflectionUtils.findField((Class)javaClass, (String)traitFieldName);
                        if (field != null) {
                            ReflectionUtils.makeAccessible((Field)field);
                            this.propertyReader = new FieldReader(field, readMethod);
                            this.propertyWriter = new FieldWriter(field, descriptor.getWriteMethod());
                        } else {
                            writeMethod = descriptor.getWriteMethod();
                            this.propertyReader = new ReflectMethodReader(readMethod);
                            this.propertyWriter = new ReflectionMethodWriter(writeMethod, descriptor.getPropertyType());
                        }
                    } else {
                        this.propertyReader = new ReflectMethodReader(readMethod);
                        writeMethod = descriptor.getWriteMethod();
                        if (writeMethod != null) {
                            this.propertyWriter = new ReflectionMethodWriter(writeMethod, descriptor.getPropertyType());
                        }
                    }
                }
                return this;
            }
        }

        static class FieldWriter
        implements EntityReflector.PropertyWriter {
            final Field field;
            final Method setter;

            public FieldWriter(Field field, Method setter) {
                this.field = field;
                this.setter = setter;
                ReflectionUtils.makeAccessible((Field)field);
            }

            @Override
            public Field field() {
                return this.field;
            }

            @Override
            public Method setter() {
                return this.setter;
            }

            @Override
            public Class propertyType() {
                return this.field.getType();
            }

            @Override
            public void write(Object object, Object value) {
                try {
                    this.field.set(object, value);
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("Cannot set field [" + this.field.getName() + "] of object [" + object + "] for value [" + value + "] of type [" + value.getClass().getName() + "]", e);
                }
            }
        }

        static class FieldReader
        implements EntityReflector.PropertyReader {
            final Field field;
            final Method getter;

            public FieldReader(Field field, Method getter) {
                this.field = field;
                this.getter = getter;
                ReflectionUtils.makeAccessible((Field)field);
            }

            @Override
            public Field field() {
                return this.field;
            }

            @Override
            public Method getter() {
                return this.getter;
            }

            @Override
            public Class propertyType() {
                return this.field.getType();
            }

            @Override
            public Object read(Object object) {
                try {
                    object = FieldEntityAccess.unwrapIfProxy(object);
                    return this.field.get(object);
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("Cannot read field [" + this.field + "] from object [" + object + "] of type [" + object.getClass() + "]", e);
                }
            }
        }

        static class ReflectionMethodWriter
        implements EntityReflector.PropertyWriter {
            final Method method;
            final Class propertyType;

            public ReflectionMethodWriter(Method method, Class propertyType) {
                this.method = method;
                ReflectionUtils.makeAccessible((Method)method);
                this.propertyType = propertyType;
            }

            @Override
            public Field field() {
                return null;
            }

            @Override
            public Method setter() {
                return this.method;
            }

            @Override
            public Class propertyType() {
                return this.propertyType;
            }

            @Override
            public void write(Object object, Object value) {
                ReflectionUtils.invokeMethod((Method)this.method, (Object)object, (Object[])new Object[]{value});
            }
        }

        static class ReflectMethodReader
        implements EntityReflector.PropertyReader {
            final Method method;

            public ReflectMethodReader(Method method) {
                this.method = method;
                ReflectionUtils.makeAccessible((Method)method);
            }

            @Override
            public Field field() {
                return null;
            }

            @Override
            public Method getter() {
                return this.method;
            }

            @Override
            public Class propertyType() {
                return this.method.getReturnType();
            }

            @Override
            public Object read(Object object) {
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)object);
            }
        }
    }
}

