/* granite.vapi generated by valac 0.36.3, do not modify. */

namespace Granite {
	namespace DateTime {
		[CCode (cheader_filename = "granite.h")]
		public static string get_default_date_format (bool with_weekday = false, bool with_day = true, bool with_year = false);
		[CCode (cheader_filename = "granite.h")]
		public static string get_default_time_format (bool is_12h = false, bool with_second = false);
	}
	namespace Drawing {
		[CCode (cheader_filename = "granite.h")]
		public class BufferSurface : GLib.Object {
			public BufferSurface (int width, int height);
			public Granite.Drawing.Color average_color ();
			public void clear ();
			public void exponential_blur (int radius);
			public void fast_blur (int radius, int process_count = 1);
			public void gaussian_blur (int radius);
			public Gdk.Pixbuf load_to_pixbuf ();
			public BufferSurface.with_buffer_surface (int width, int height, Granite.Drawing.BufferSurface model);
			public BufferSurface.with_surface (int width, int height, Cairo.Surface model);
			public Cairo.Context context { get; }
			public int height { get; private set; }
			public Cairo.Surface surface { get; private set; }
			public int width { get; private set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class Color : GLib.Object, Granite.Services.SettingsSerializable {
			public double A;
			public double B;
			public double G;
			public double R;
			public Color (double R, double G, double B, double A);
			public Granite.Drawing.Color add_hue (double val);
			public Granite.Drawing.Color brighten_val (double amount);
			public Granite.Drawing.Color darken_by_sat (double amount);
			public Granite.Drawing.Color darken_val (double amount);
			public Color.from_gdk (Gdk.Color color);
			public double get_hue ();
			public double get_sat ();
			public double get_val ();
			public Granite.Drawing.Color multiply_sat (double amount);
			public Granite.Drawing.Color set_alpha (double alpha);
			public Granite.Drawing.Color set_hue (double hue);
			public Granite.Drawing.Color set_max_sat (double sat);
			public Granite.Drawing.Color set_max_val (double val);
			public Granite.Drawing.Color set_min_sat (double sat);
			public Granite.Drawing.Color set_min_value (double val);
			public Granite.Drawing.Color set_sat (double sat);
			public Granite.Drawing.Color set_val (double val);
		}
		[CCode (cheader_filename = "granite.h")]
		public class Utilities : GLib.Object {
			public Utilities ();
			public static Granite.Drawing.Color average_color (Gdk.Pixbuf source);
			public static void cairo_rounded_rectangle (Cairo.Context cr, double x, double y, double width, double height, double radius);
		}
	}
	namespace GtkPatch {
		[CCode (cheader_filename = "granite.h")]
		public class AboutDialog : Gtk.Dialog {
			public AboutDialog ();
			public string[] artists { get; set; }
			public string[] authors { get; set; }
			public string comments { get; set; }
			public string copyright { get; set; }
			public string[] documenters { get; set; }
			public string license { get; set; }
			public Gtk.License license_type { get; set; }
			public Gdk.Pixbuf logo { get; set; }
			public string logo_icon_name { get; set; }
			public string program_name { get; set; }
			public string translator_credits { get; set; }
			public string version { get; set; }
			public string website { get; set; }
			public string website_label { get; set; }
			public virtual signal bool activate_link (string uri);
		}
	}
	namespace Services {
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "Granite.Services.ContractorProxy")]
		public class Contractor : GLib.Object {
			public Contractor ();
			public static GLib.HashTable<string,string>[] get_contract (string uri, string mime);
			public static GLib.HashTable<string,string>[] get_selection_contracts (GLib.HashTable<string,string>[] locations);
		}
		[CCode (cheader_filename = "granite.h")]
		public class ContractorProxy : GLib.Object {
			public static Gee.List<Granite.Services.Contract> get_all_contracts () throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_by_mime (string mime_type) throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_by_mimelist (string[] mime_types) throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_for_file (GLib.File file) throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_for_files (GLib.File[] files) throws GLib.Error;
			public static Granite.Services.ContractorProxy get_instance () throws GLib.Error;
			public signal void contracts_changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class IconFactory : GLib.Object {
			public IconFactory ();
			public static Granite.Services.IconFactory get_default ();
			public Gdk.Pixbuf? load_symbolic_icon (Gtk.StyleContext style, string iconname, int size);
			public Gdk.Pixbuf? load_symbolic_icon_from_gicon (Gtk.StyleContext style, GLib.Icon gicon, int size);
		}
		[CCode (cheader_filename = "granite.h")]
		public class Logger : GLib.Object {
			public Logger ();
			public static void initialize (string app_name);
			public static void notification (string msg);
			public static Granite.Services.LogLevel DisplayLevel { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class Paths : GLib.Object {
			public Paths ();
			public static bool ensure_directory_exists (GLib.File dir);
			public static void initialize (string app_name, string data_folder_path);
			public static GLib.File data_folder { get; protected set; }
			public static GLib.File home_folder { get; protected set; }
			public static GLib.File user_cache_folder { get; protected set; }
			public static GLib.File user_config_folder { get; protected set; }
			public static GLib.File user_data_folder { get; protected set; }
			public static GLib.File xdg_cache_home_folder { get; protected set; }
			public static GLib.File xdg_config_home_folder { get; protected set; }
			public static GLib.List<GLib.File> xdg_data_dir_folders { get; protected owned set; }
			public static GLib.File xdg_data_home_folder { get; protected set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public abstract class Settings : GLib.Object {
			public Settings (string schema);
			protected virtual void verify (string key);
			public Settings.with_backend (string schema, GLib.SettingsBackend backend);
			public Settings.with_backend_and_path (string schema, GLib.SettingsBackend backend, string path);
			public Settings.with_path (string schema, string path);
			public GLib.Settings schema { get; construct; }
			[Signal (action = true, detailed = true, no_hooks = true, no_recurse = true, run = "first")]
			public signal void changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class SimpleCommand : GLib.Object {
			public string error_output_str;
			public string output_str;
			public string standard_output_str;
			public SimpleCommand (string dir, string command);
			public void run ();
			public signal void done (int exit);
			public signal void error_changed (string text);
			public signal void output_changed (string text);
			public signal void standard_changed (string text);
		}
		[CCode (cheader_filename = "granite.h")]
		public class System : GLib.Object {
			public System ();
			public static bool execute_command (string command);
			public static void launch (GLib.File app);
			public static void launch_with_files (GLib.File? app, GLib.File[] files);
			public static void open (GLib.File file);
			public static void open_files (GLib.File[] files);
			public static void open_uri (string uri);
		}
		[CCode (cheader_filename = "granite.h")]
		public interface Contract : GLib.Object {
			public abstract void execute_with_file (GLib.File file) throws GLib.Error;
			public abstract void execute_with_files (GLib.File[] files) throws GLib.Error;
			public abstract string get_description ();
			public abstract string get_display_name ();
			public abstract GLib.Icon get_icon ();
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SettingsSerializable : GLib.Object {
			public abstract void settings_deserialize (string s);
			public abstract string settings_serialize ();
		}
		[CCode (cheader_filename = "granite.h")]
		public enum LogLevel {
			DEBUG,
			INFO,
			NOTIFY,
			WARN,
			ERROR,
			FATAL
		}
		[CCode (cheader_filename = "granite.h")]
		public errordomain ContractorError {
			SERVICE_NOT_AVAILABLE
		}
		[CCode (cheader_filename = "granite.h")]
		public static Granite.Services.IconFactory? icon_factory;
	}
	namespace StyleClass {
		[CCode (cheader_filename = "granite.h")]
		public const string BADGE;
		[CCode (cheader_filename = "granite.h")]
		public const string CATEGORY_EXPANDER;
		[CCode (cheader_filename = "granite.h")]
		public const string COMPOSITED;
		[CCode (cheader_filename = "granite.h")]
		public const string CONTENT_VIEW;
		[CCode (cheader_filename = "granite.h")]
		public const string CONTENT_VIEW_WINDOW;
		[CCode (cheader_filename = "granite.h")]
		public const string DECORATED_WINDOW;
		[CCode (cheader_filename = "granite.h")]
		public const string H1_TEXT;
		[CCode (cheader_filename = "granite.h")]
		public const string H2_TEXT;
		[CCode (cheader_filename = "granite.h")]
		public const string H3_TEXT;
		[CCode (cheader_filename = "granite.h")]
		public const string HELP_BUTTON;
		[CCode (cheader_filename = "granite.h")]
		public const string OVERLAY_BAR;
		[CCode (cheader_filename = "granite.h")]
		public const string POPOVER;
		[CCode (cheader_filename = "granite.h")]
		public const string POPOVER_BG;
		[CCode (cheader_filename = "granite.h")]
		public const string SOURCE_LIST;
		[CCode (cheader_filename = "granite.h")]
		public const string THIN_PANE_SEPARATOR;
		[CCode (cheader_filename = "granite.h")]
		public const string TITLE_TEXT;
	}
	namespace Widgets {
		namespace Utils {
			[CCode (cheader_filename = "granite.h")]
			public static void apply_text_style_to_label (Granite.TextStyle text_style, Gtk.Label label);
			[CCode (cheader_filename = "granite.h")]
			public static string? get_button_layout_schema ();
			[CCode (cheader_filename = "granite.h", cname = "get_close_pixbuf")]
			public static Gdk.Pixbuf get_close_pixbuf ();
			[CCode (cheader_filename = "granite.h")]
			public static Gtk.CssProvider? get_css_provider (string stylesheet);
			[CCode (cheader_filename = "granite.h")]
			public static bool get_default_close_button_position (out Granite.CloseButtonPosition position);
			[CCode (cheader_filename = "granite.h")]
			public static Gtk.CssProvider? set_color_primary (Gtk.Widget window, Gdk.RGBA color, int priority = Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION);
			[CCode (cheader_filename = "granite.h")]
			public static Gtk.CssProvider? set_theming (Gtk.Widget widget, string stylesheet, string? class_name, int priority);
			[CCode (cheader_filename = "granite.h")]
			public static Gtk.CssProvider? set_theming_for_screen (Gdk.Screen screen, string stylesheet, int priority);
		}
		[CCode (cheader_filename = "granite.h")]
		public class AboutDialog : Granite.GtkPatch.AboutDialog {
			public AboutDialog ();
			public string bug { get; set; }
			public string help { get; set; }
			public string translate { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class AlertView : Gtk.Grid {
			public AlertView (string title, string description, string icon_name);
			public void hide_action ();
			public void show_action (string? label = null);
			public string description { get; set; }
			public string icon_name { owned get; set; }
			public string title { get; set; }
			public signal void action_activated ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.1", replacement = "Gtk.MenuButton")]
		public class AppMenu : Granite.Widgets.ToolButtonWithMenu {
			public Gtk.MenuItem about_item;
			public AppMenu (Gtk.Menu menu);
			public void add_items (Gtk.Menu menu);
			public AppMenu.with_app (Granite.Application? application, Gtk.Menu menu);
			[Version (deprecated = true, deprecated_since = "0.1", replacement = "")]
			public AppMenu.with_urls (Gtk.Menu menu, string help_url, string translate_url, string bug_url);
			public signal void show_about (Gtk.Widget w);
		}
		[CCode (cheader_filename = "granite.h")]
		public class Avatar : Gtk.EventBox {
			public Avatar ();
			public override bool draw (Cairo.Context cr);
			public Avatar.from_file (string filepath, int pixel_size);
			public Avatar.from_pixbuf (Gdk.Pixbuf pixbuf);
			public void show_default (int pixel_size);
			public Avatar.with_default_icon (int pixel_size);
			public Gdk.Pixbuf? pixbuf { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class CellRendererBadge : Gtk.CellRenderer {
			public CellRendererBadge ();
			public override void get_preferred_height_for_width (Gtk.Widget widget, int width, out int minimum_height, out int natural_height);
			public override void get_preferred_width (Gtk.Widget widget, out int minimum_size, out int natural_size);
			public override Gtk.SizeRequestMode get_request_mode ();
			[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.CellRenderer.get_preferred_size")]
			public override void get_size (Gtk.Widget widget, Gdk.Rectangle? cell_area, out int x_offset, out int y_offset, out int width, out int height);
			public override void render (Cairo.Context context, Gtk.Widget widget, Gdk.Rectangle bg_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags);
			public string text { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class CellRendererExpander : Gtk.CellRenderer {
			public CellRendererExpander ();
			public virtual int get_arrow_size (Gtk.Widget widget);
			public override void get_preferred_height_for_width (Gtk.Widget widget, int width, out int minimum_height, out int natural_height);
			public override void get_preferred_width (Gtk.Widget widget, out int minimum_size, out int natural_size);
			public override Gtk.SizeRequestMode get_request_mode ();
			[Version (deprecated = true, deprecated_since = "", replacement = "Gtk.CellRenderer.get_preferred_size")]
			public override void get_size (Gtk.Widget widget, Gdk.Rectangle? cell_area, out int x_offset, out int y_offset, out int width, out int height);
			public override void render (Cairo.Context context, Gtk.Widget widget, Gdk.Rectangle bg_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags);
			public bool is_category_expander { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class CollapsiblePaned : Gtk.Paned {
			public CollapsiblePaned (Gtk.Orientation orientation);
			public Granite.CollapseMode collapse_mode { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class CompositedWindow : Gtk.Window, Gtk.Buildable {
			public CompositedWindow ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "")]
		public class ContractorMenu : Gtk.Menu {
			public delegate void ContractCallback ();
			public ContractorMenu (string filename, string mime);
			public void add_item (string name, string icon_name, int position, Granite.Widgets.ContractorMenu.ContractCallback method, bool use_stock = true);
			public void name_blacklist (string[] names);
			public void update (string? filename, string? mime);
			public signal void contract_activated (string contract_name);
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "")]
		public class ContractorView : Gtk.TreeView {
			public delegate void ContractCallback ();
			public bool contractor_available;
			public ContractorView (string filename, string mime, int icon_size = 32, bool show_contract_name = true);
			public void add_item (string name, string desc, string icon_name, int icon_size, int position, Granite.Widgets.ContractorView.ContractCallback method);
			public void name_blacklist (string[] names);
			public void run_selected ();
			public int selected { get; set; }
			public signal void executed ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class DatePicker : Gtk.Entry, Gtk.Buildable {
			protected Gtk.Calendar calendar;
			protected Gtk.EventBox dropdown;
			public DatePicker ();
			protected virtual void position_dropdown (out Gdk.Rectangle rect);
			public DatePicker.with_format (string format);
			public GLib.DateTime date { get; set; }
			public string format { get; construct; }
			public signal void date_changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.Dialog")]
		public class DecoratedWindow : Granite.Widgets.CompositedWindow {
			protected Gdk.Pixbuf close_img;
			public DecoratedWindow (string title = "", string? window_style = null, string? content_style = null);
			public new void add (Gtk.Widget w);
			public override bool button_press_event (Gdk.EventButton e);
			public override bool button_release_event (Gdk.EventButton e);
			public override bool key_press_event (Gdk.EventKey event);
			public new void remove (Gtk.Widget w);
			public static void set_default_theming (Gtk.Window ref_window);
			protected Gtk.Box box { get; private set; }
			protected Gtk.Window draw_ref { get; private set; }
			public bool show_title { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class DynamicNotebook : Gtk.EventBox {
			public enum TabBarBehavior {
				ALWAYS,
				SINGLE,
				NEVER
			}
			public DynamicNotebook ();
			public new GLib.List<Gtk.Widget> get_children ();
			public Gtk.Widget get_nth_page (int index);
			public Granite.Widgets.Tab? get_tab_by_index (int index);
			public Granite.Widgets.Tab? get_tab_by_widget (Gtk.Widget widget);
			public int get_tab_position (Granite.Widgets.Tab tab);
			public uint insert_tab (Granite.Widgets.Tab tab, int index);
			public void next_page ();
			public void previous_page ();
			public void remove_tab (Granite.Widgets.Tab tab);
			public void set_tab_position (Granite.Widgets.Tab tab, int position);
			public override void show ();
			public string add_button_tooltip { get; set; }
			public bool add_button_visible { get; set; }
			public bool allow_drag { get; set; }
			public bool allow_duplication { get; set; }
			public bool allow_new_window { get; set; }
			public bool allow_pinning { get; set; }
			public bool allow_restoring { get; set; }
			public Granite.Widgets.Tab current { get; set; }
			public bool force_left { get; set; }
			public string group_name { get; set; }
			public int max_restorable_tabs { get; set; }
			public Gtk.Menu menu { get; private set; }
			public int n_tabs { get; }
			[Version (deprecated = true, deprecated_since = "0.3.1", replacement = "")]
			public bool show_icons { get; set; }
			public bool show_tabs { get; set; }
			public Granite.Widgets.DynamicNotebook.TabBarBehavior tab_bar_behavior { get; set; }
			public GLib.List<Granite.Widgets.Tab> tabs { get; }
			public bool tabs_closable { get; set; }
			public signal bool close_tab_requested (Granite.Widgets.Tab tab);
			public signal void new_tab_requested ();
			public signal void tab_added (Granite.Widgets.Tab tab);
			public signal void tab_duplicated (Granite.Widgets.Tab duplicated_tab);
			public signal void tab_moved (Granite.Widgets.Tab tab, int x, int y);
			public signal void tab_removed (Granite.Widgets.Tab tab);
			public signal void tab_reordered (Granite.Widgets.Tab tab, int new_pos);
			public signal void tab_restored (string label, string data, GLib.Icon? icon);
			public signal void tab_switched (Granite.Widgets.Tab? old_tab, Granite.Widgets.Tab new_tab);
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "Granite.Widgets.CollapsiblePaned")]
		public class HCollapsablePaned : Granite.Widgets.CollapsiblePaned {
			public HCollapsablePaned ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.Entry.placeholder_text")]
		public class HintedEntry : Gtk.Entry {
			public HintedEntry (string hint_string);
			[Version (deprecated = true, deprecated_since = "0.2", replacement = "Gtk.Entry.get_text")]
			public new string get_text ();
			[Version (deprecated = true, deprecated_since = "0.2", replacement = "")]
			protected void hint ();
			[Version (deprecated = true, deprecated_since = "0.2", replacement = "Gtk.Entry.set_text")]
			public new void set_text (string text);
			[Version (deprecated = true, deprecated_since = "0.2", replacement = "")]
			protected void unhint ();
			public bool has_clear_icon { get; set; }
			public string hint_string { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.Dialog")]
		public class LightWindow : Granite.Widgets.DecoratedWindow {
			public LightWindow (string title = "");
		}
		[CCode (cheader_filename = "granite.h")]
		public class ModeButton : Gtk.Box {
			public ModeButton ();
			public int append (Gtk.Widget w);
			public int append_icon (string icon_name, Gtk.IconSize size);
			public int append_pixbuf (Gdk.Pixbuf pixbuf);
			public int append_text (string text);
			public void clear_children ();
			public new void remove (int index);
			public void set_active (int new_active_index);
			public void set_item_visible (int index, bool val);
			public uint n_items { get; }
			public int selected { get; set; }
			public signal void mode_added (int index, Gtk.Widget widget);
			public signal void mode_changed (Gtk.Widget widget);
			public signal void mode_removed (int index, Gtk.Widget widget);
		}
		[CCode (cheader_filename = "granite.h")]
		public class OverlayBar : Gtk.EventBox {
			public OverlayBar (Gtk.Overlay overlay);
			public override bool draw (Cairo.Context cr);
			public override void get_preferred_height_for_width (int width, out int minimum_height, out int natural_height);
			public override void get_preferred_width (out int minimum_width, out int natural_width);
			public override Gtk.SizeRequestMode get_request_mode ();
			public override void parent_set (Gtk.Widget? old_parent);
			public string status { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.Popover")]
		public class PopOver : Gtk.Dialog {
			public enum PopPosition {
				NONE,
				TOPLEFT,
				TOPRIGHT,
				BOTTOMLEFT,
				BOTTOMRIGHT
			}
			protected int ARROW_HEIGHT;
			protected int ARROW_WIDTH;
			protected int BORDER_RADIUS;
			protected int BORDER_WIDTH;
			protected Gtk.Border PADDINGS;
			protected int SHADOW_SIZE;
			protected double arrow_offset;
			protected bool arrow_up;
			protected Granite.Drawing.BufferSurface? main_buffer;
			public PopOver ();
			public override bool button_press_event (Gdk.EventButton event);
			public override bool button_release_event (Gdk.EventButton event);
			protected void cairo_popover (Cairo.Context cr, double x, double y, double width, double height, double border_radius);
			public override bool draw (Cairo.Context cr);
			public override void hide ();
			public override bool map_event (Gdk.EventAny event);
			public void move_to_coords (int x, int y, bool show = true);
			public void move_to_rect (Gdk.Rectangle rect, bool show = true);
			public void move_to_widget (Gtk.Widget w, bool show = true);
			public void move_to_window (Gdk.Window window);
			protected void reset_buffers ();
			public void set_parent_pop (Gtk.Window win);
			public override void show ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.SearchEntry")]
		public class SearchBar : Granite.Widgets.HintedEntry {
			public SearchBar (string hint_string);
			public int pause_delay { get; set; }
			public signal void search_icon_release ();
			public signal void text_changed_pause (string text);
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "Granite.Widgets.ThinPaned")]
		public class SidebarPaned : Granite.Widgets.ThinPaned {
			public SidebarPaned ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class SourceList : Gtk.ScrolledWindow {
			public class ExpandableItem : Granite.Widgets.SourceList.Item {
				public ExpandableItem (string name = "");
				public void add (Granite.Widgets.SourceList.Item item);
				public void clear ();
				public void collapse_all (bool inclusive = true, bool recursive = true);
				public void collapse_with_parents ();
				public bool contains (Granite.Widgets.SourceList.Item item);
				public void expand_all (bool inclusive = true, bool recursive = true);
				public void expand_with_parents ();
				public void remove (Granite.Widgets.SourceList.Item item);
				public Gee.Collection<Granite.Widgets.SourceList.Item> children { owned get; }
				public bool collapsible { get; set; }
				public bool expanded { get; set; }
				public uint n_children { get; }
				public signal void child_added (Granite.Widgets.SourceList.Item item);
				public signal void child_removed (Granite.Widgets.SourceList.Item item);
				public virtual signal void toggled ();
			}
			public class Item : GLib.Object {
				public Item (string name = "");
				public virtual Gtk.Menu? get_context_menu ();
				public GLib.Icon activatable { get; set; }
				public string badge { get; set; }
				public bool editable { get; set; }
				public GLib.Icon icon { get; set; }
				public string name { get; set; }
				public Granite.Widgets.SourceList.ExpandableItem parent { get; internal set; }
				public bool selectable { get; set; }
				public bool visible { get; set; }
				public virtual signal void action_activated ();
				public virtual signal void activated ();
				public virtual signal void edited (string new_name);
			}
			[Version (deprecated = true, deprecated_since = "0.2", replacement = "SourceListSortable.compare")]
			public delegate int SortFunc (Granite.Widgets.SourceList.Item a, Granite.Widgets.SourceList.Item b);
			public delegate bool VisibleFunc (Granite.Widgets.SourceList.Item item);
			public SourceList (Granite.Widgets.SourceList.ExpandableItem root = new Granite.Widgets.SourceList.ExpandableItem (""));
			public void disable_drag_dest ();
			public void disable_drag_source ();
			public void enable_drag_dest (Gtk.TargetEntry[] dest_entries, Gdk.DragAction actions);
			public void enable_drag_source (Gtk.TargetEntry[] src_entries);
			public Granite.Widgets.SourceList.Item? get_first_child (Granite.Widgets.SourceList.ExpandableItem parent);
			public Granite.Widgets.SourceList.Item? get_last_child (Granite.Widgets.SourceList.ExpandableItem parent);
			public uint get_n_visible_children (Granite.Widgets.SourceList.ExpandableItem parent);
			public Granite.Widgets.SourceList.Item? get_next_item (Granite.Widgets.SourceList.Item reference);
			public Granite.Widgets.SourceList.Item? get_previous_item (Granite.Widgets.SourceList.Item reference);
			public bool has_item (Granite.Widgets.SourceList.Item item);
			public bool is_item_expanded (Granite.Widgets.SourceList.Item item);
			public void refilter ();
			public bool scroll_to_item (Granite.Widgets.SourceList.Item item, bool expand_parents = true, bool use_align = false, float row_align = 0);
			public void set_filter_func (Granite.Widgets.SourceList.VisibleFunc? visible_func, bool refilter);
			[Version (deprecated = true, deprecated_since = "0.2", replacement = "SourceListSortable.compare")]
			public void set_sort_func (owned Granite.Widgets.SourceList.SortFunc? sort_func);
			public bool start_editing_item (Granite.Widgets.SourceList.Item item);
			public void stop_editing ();
			public bool editing { get; }
			public Pango.EllipsizeMode ellipsize_mode { get; set; }
			public Granite.Widgets.SourceList.ExpandableItem root { get; set; }
			public Granite.Widgets.SourceList.Item? selected { get; set; }
			[Version (deprecated = true, deprecated_since = "0.3", replacement = "")]
			public Gtk.SortType sort_direction { get; set; }
			public virtual signal void item_selected (Granite.Widgets.SourceList.Item? item);
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.Stack")]
		public class StaticNotebook : Gtk.Box {
			public StaticNotebook (bool show_separator = true);
			public int append_page (Gtk.Widget widget, Gtk.Label label);
			public void remove_page (int number);
			public void set_switcher_visible (bool val);
			public int page { get; set; }
			public signal void page_changed (int index);
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.ActionBar")]
		public class StatusBar : Gtk.Toolbar {
			public StatusBar ();
			public void insert_widget (Gtk.Widget widget, bool use_left_side = false);
			public void set_text (string text);
		}
		[CCode (cheader_filename = "granite.h")]
		public class StorageBar : Gtk.Box {
			public enum ItemDescription {
				OTHER,
				AUDIO,
				VIDEO,
				PHOTO,
				APP,
				FILES;
				public static string? get_class (Granite.Widgets.StorageBar.ItemDescription description);
				public static string get_name (Granite.Widgets.StorageBar.ItemDescription description);
			}
			public StorageBar (uint64 storage);
			public void update_block_size (Granite.Widgets.StorageBar.ItemDescription description, uint64 size);
			public StorageBar.with_total_usage (uint64 storage, uint64 total_usage);
			public int inner_margin_sides { get; set; }
			public uint64 storage { get; set; }
			public uint64 total_usage { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class Tab : Gtk.EventBox {
			public Granite.Widgets.DroppedDelegate dropped_callback;
			public Tab (string label = "", GLib.Icon? icon = null, Gtk.Widget? page = null);
			public void close ();
			public Pango.EllipsizeMode ellipsize_mode { get; set; }
			[Version (deprecated = true, deprecated_since = "0.3", replacement = "")]
			public bool fixed { get; set; }
			public GLib.Icon? icon { owned get; set; }
			public string label { get; set; }
			public Gtk.Menu menu { get; set; }
			public Gtk.Widget page { get; set; }
			public bool pinnable { get; set; }
			public bool pinned { get; set; }
			public string restore_data { get; set; }
			public bool working { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.Paned")]
		public class ThinPaned : Gtk.Paned {
			public ThinPaned (Gtk.Orientation orientation = Gtk.Orientation.HORIZONTAL);
			public override bool button_press_event (Gdk.EventButton event);
			public override bool button_release_event (Gdk.EventButton event);
			public override bool draw (Cairo.Context ctx);
			public unowned Gdk.Window get_overlay_handle_window ();
			public override bool grab_broken_event (Gdk.EventGrabBroken event);
			public override void map ();
			public override bool motion_notify_event (Gdk.EventMotion event);
			public override void realize ();
			public override void size_allocate (Gtk.Allocation allocation);
			public override void state_flags_changed (Gtk.StateFlags previous_state);
			public override void unmap ();
			public override void unrealize ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class TimePicker : Gtk.Entry {
			public TimePicker ();
			protected virtual void position_dropdown (out int x, out int y);
			public TimePicker.with_format (string format_12, string format_24);
			public string format_12 { get; construct; }
			public string format_24 { get; construct; }
			public GLib.DateTime time { get; set; }
			public signal void time_changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class Toast : Gtk.Revealer {
			public Toast (string title);
			public void send_notification ();
			public void set_default_action (string? label);
			public string title { get; set construct; }
			public signal void closed ();
			public signal void default_action ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.MenuButton")]
		public class ToolButtonWithMenu : Gtk.ToggleToolButton {
			public enum HMenuPosition {
				LEFT,
				CENTER,
				RIGHT,
				INSIDE_WINDOW
			}
			public enum VMenuPosition {
				TOP,
				BOTTOM
			}
			public delegate Gtk.Menu MenuFetcher ();
			public Gtk.Action? myaction;
			public ulong toggled_sig_id;
			public ToolButtonWithMenu (Gtk.Image image, string label, Gtk.Menu menu);
			public ToolButtonWithMenu.from_action (Gtk.Action action);
			public ToolButtonWithMenu.from_stock (string stock_image, Gtk.IconSize size, string label, Gtk.Menu menu);
			protected void popdown_menu ();
			protected new void popup_menu (Gdk.EventButton? ev = null);
			public override void show_all ();
			public Granite.Widgets.ToolButtonWithMenu.MenuFetcher fetcher { get; set; }
			public Granite.Widgets.ToolButtonWithMenu.HMenuPosition horizontal_menu_position { get; set; }
			public Gtk.Menu menu { get; set; }
			public Granite.Widgets.ToolButtonWithMenu.VMenuPosition vertical_menu_position { get; set; }
			public signal void right_click (Gdk.EventButton ev);
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "Granite.Widgets.CollapsiblePaned")]
		public class VCollapsablePaned : Granite.Widgets.CollapsiblePaned {
			public VCollapsablePaned ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class Welcome : Gtk.EventBox {
			protected GLib.List<Gtk.Button> children;
			protected Gtk.Box options;
			public Welcome (string title_text, string subtitle_text);
			public int append (string icon_name, string option_text, string description_text);
			public int append_with_image (Gtk.Image? image, string option_text, string description_text);
			public int append_with_pixbuf (Gdk.Pixbuf? pixbuf, string option_text, string description_text);
			public Granite.Widgets.WelcomeButton? get_button_from_index (int index);
			public void remove_item (uint index);
			public void set_item_sensitivity (uint index, bool val);
			public void set_item_visible (uint index, bool val);
			public string subtitle { get; set; }
			public string title { get; set; }
			public signal void activated (int index);
		}
		[CCode (cheader_filename = "granite.h")]
		public class WelcomeButton : Gtk.Button {
			public WelcomeButton (Gtk.Image? image, string option_text, string description_text);
			public string description { get; set; }
			public Gtk.Image? icon { get; set; }
			public string title { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.3", replacement = "Gtk.Label")]
		public class WrapLabel : Gtk.Label {
			public int m_wrap_height;
			public int m_wrap_width;
			public WrapLabel (string? str = null);
			public override void get_preferred_width (out int minimum_width, out int natural_width);
			public override void size_allocate (Gtk.Allocation alloc);
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SourceListDragDest : Granite.Widgets.SourceList.Item {
			public abstract bool data_drop_possible (Gdk.DragContext context, Gtk.SelectionData data);
			public abstract Gdk.DragAction data_received (Gdk.DragContext context, Gtk.SelectionData data);
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SourceListDragSource : Granite.Widgets.SourceList.Item {
			public abstract bool draggable ();
			public abstract void prepare_selection_data (Gtk.SelectionData selection_data);
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SourceListSortable : Granite.Widgets.SourceList.ExpandableItem {
			public abstract bool allow_dnd_sorting ();
			public abstract int compare (Granite.Widgets.SourceList.Item a, Granite.Widgets.SourceList.Item b);
			public signal void user_moved_item (Granite.Widgets.SourceList.Item moved);
		}
		[CCode (cheader_filename = "granite.h")]
		public delegate void DroppedDelegate ();
		[CCode (cheader_filename = "granite.h")]
		public static void show_about_dialog (Gtk.Window* parent, string first, ...);
	}
	[CCode (cheader_filename = "granite.h")]
	public abstract class Application : Gtk.Application {
		protected static bool ABOUT;
		protected static bool DEBUG;
		public string[] about_artists;
		public string[] about_authors;
		public string about_comments;
		protected Granite.Widgets.AboutDialog about_dlg;
		public string[] about_documenters;
		public string about_license;
		public Gtk.License about_license_type;
		public string about_translators;
		public string app_copyright;
		public string app_icon;
		public string app_launcher;
		public string app_years;
		public string bug_url;
		public string build_data_dir;
		public string build_pkg_data_dir;
		public string build_release_name;
		public string build_version;
		public string build_version_info;
		public string exec_name;
		public string help_url;
		public string main_url;
		public string program_name;
		public string translate_url;
		protected const GLib.OptionEntry[] options;
		public Application ();
		public Granite.Widgets.AppMenu create_appmenu (Gtk.Menu menu);
		[CCode (cheader_filename = "sys/prctl.h", cname = "prctl")]
		protected static int prctl (int option, string arg2, ulong arg3, ulong arg4, ulong arg5);
		public new int run (string[] args);
		protected virtual void set_options ();
		public virtual void show_about (Gtk.Widget parent);
	}
	[CCode (cheader_filename = "granite.h")]
	public enum CloseButtonPosition {
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "granite.h")]
	public enum CollapseMode {
		NONE,
		LEFT,
		TOP,
		FIRST,
		RIGHT,
		BOTTOM,
		LAST
	}
	[CCode (cheader_filename = "granite.h")]
	public enum TextStyle {
		TITLE,
		H1,
		H2,
		H3;
		public string get_stylesheet (out string style_class = null);
	}
	[CCode (cheader_filename = "granite.h")]
	[Version (deprecated = true, deprecated_since = "0.1", replacement = "")]
	public static Granite.Application app;
}
