/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions;

import com.google.common.collect.Lists;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.AsDynamicFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ExceptionPropertyIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.LongOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.NumberAndCharConversionFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.PrimitiveBinaryOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.PrimitiveUnaryOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ThrowableConstructorIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.StringPlusCharFIF;

public final class FunctionIntrinsics {
    @NotNull
    private final Map<FunctionDescriptor, FunctionIntrinsic> intrinsicCache = new THashMap<FunctionDescriptor, FunctionIntrinsic>();
    @NotNull
    private final List<FunctionIntrinsicFactory> factories = Lists.newArrayList();

    public FunctionIntrinsics() {
        this.registerFactories();
    }

    private void registerFactories() {
        this.register(LongOperationFIF.INSTANCE);
        this.register(PrimitiveUnaryOperationFIF.INSTANCE);
        this.register(StringPlusCharFIF.INSTANCE);
        this.register(PrimitiveBinaryOperationFIF.INSTANCE);
        this.register(ArrayFIF.INSTANCE);
        this.register(TopLevelFIF.INSTANCE);
        this.register(NumberAndCharConversionFIF.INSTANCE);
        this.register(ThrowableConstructorIntrinsicFactory.INSTANCE);
        this.register(ExceptionPropertyIntrinsicFactory.INSTANCE);
        this.register(AsDynamicFIF.INSTANCE);
    }

    private void register(@NotNull FunctionIntrinsicFactory instance) {
        if (instance == null) {
            FunctionIntrinsics.$$$reportNull$$$0(0);
        }
        this.factories.add(instance);
    }

    @NotNull
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        FunctionIntrinsic intrinsic;
        if (descriptor2 == null) {
            FunctionIntrinsics.$$$reportNull$$$0(1);
        }
        if ((intrinsic = this.lookUpCache(descriptor2)) != null) {
            FunctionIntrinsic functionIntrinsic = intrinsic;
            if (functionIntrinsic == null) {
                FunctionIntrinsics.$$$reportNull$$$0(2);
            }
            return functionIntrinsic;
        }
        FunctionIntrinsic functionIntrinsic = intrinsic = this.computeAndCacheIntrinsic(descriptor2);
        if (functionIntrinsic == null) {
            FunctionIntrinsics.$$$reportNull$$$0(3);
        }
        return functionIntrinsic;
    }

    @Nullable
    private FunctionIntrinsic lookUpCache(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            FunctionIntrinsics.$$$reportNull$$$0(4);
        }
        return this.intrinsicCache.get(descriptor2);
    }

    @NotNull
    private FunctionIntrinsic computeAndCacheIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            FunctionIntrinsics.$$$reportNull$$$0(5);
        }
        FunctionIntrinsic result2 = this.computeIntrinsic(descriptor2);
        this.intrinsicCache.put(descriptor2, result2);
        FunctionIntrinsic functionIntrinsic = result2;
        if (functionIntrinsic == null) {
            FunctionIntrinsics.$$$reportNull$$$0(6);
        }
        return functionIntrinsic;
    }

    @NotNull
    private FunctionIntrinsic computeIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            FunctionIntrinsics.$$$reportNull$$$0(7);
        }
        for (FunctionIntrinsicFactory factory2 : this.factories) {
            FunctionIntrinsic intrinsic = factory2.getIntrinsic(descriptor2);
            if (intrinsic == null) continue;
            FunctionIntrinsic functionIntrinsic = intrinsic;
            if (functionIntrinsic == null) {
                FunctionIntrinsics.$$$reportNull$$$0(8);
            }
            return functionIntrinsic;
        }
        FunctionIntrinsic functionIntrinsic = FunctionIntrinsic.NO_INTRINSIC;
        if (functionIntrinsic == null) {
            FunctionIntrinsics.$$$reportNull$$$0(9);
        }
        return functionIntrinsic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrinsic";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAndCacheIntrinsic";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIntrinsic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIntrinsic";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lookUpCache";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeAndCacheIntrinsic";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeIntrinsic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

