/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.TestWithWorkingDir;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;
import org.jetbrains.kotlin.incremental.BuildStep;
import org.jetbrains.kotlin.incremental.TestLogsParsingUtilKt;
import org.jetbrains.kotlin.incremental.testingUtils.BuildLogFinder;
import org.jetbrains.kotlin.incremental.testingUtils.ClassFilesComparisonKt;
import org.jetbrains.kotlin.incremental.testingUtils.IncrementalModificationUtilsKt;
import org.jetbrains.kotlin.incremental.testingUtils.Modification;
import org.jetbrains.kotlin.incremental.testingUtils.TouchPolicy;
import org.jetbrains.kotlin.incremental.utils.TestCompilationResult;
import org.junit.Assert;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 %*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J+\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0017\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0018J6\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\u000f*\u00060\"j\u0002`#2\b\b\u0002\u0010$\u001a\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCompilerRunnerTestBase;", "Args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "Lorg/jetbrains/kotlin/TestWithWorkingDir;", "()V", "buildLogFinder", "Lorg/jetbrains/kotlin/incremental/testingUtils/BuildLogFinder;", "getBuildLogFinder", "()Lorg/jetbrains/kotlin/incremental/testingUtils/BuildLogFinder;", "createCompilerArguments", "destinationDir", "Ljava/io/File;", "testDir", "(Ljava/io/File;Ljava/io/File;)Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "doTest", "", "path", "", "make", "Lorg/jetbrains/kotlin/incremental/utils/TestCompilationResult;", "cacheDir", "sourceRoots", "", "args", "(Ljava/io/File;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Lorg/jetbrains/kotlin/incremental/utils/TestCompilationResult;", "stepLogAsString", "step", "", "ktSources", "errors", "", "includeErrors", "", "appendLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "line", "Companion", "kotlin-build-common"})
public abstract class AbstractIncrementalCompilerRunnerTestBase<Args extends CommonCompilerArguments>
extends TestWithWorkingDir {
    @NotNull
    private static final File bootstrapKotlincLib;
    public static final Companion Companion;

    @NotNull
    protected abstract Args createCompilerArguments(@NotNull File var1, @NotNull File var2);

    /*
     * WARNING - void declaration
     */
    public final void doTest(@NotNull String path) {
        Object modificationStep;
        Object object32;
        boolean bl;
        File file;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File testDir = new File(path);
        Function1<Iterable<? extends File>, List<? extends String>> relativePaths$ = new Function1<Iterable<? extends File>, List<? extends String>>(this){
            final /* synthetic */ AbstractIncrementalCompilerRunnerTestBase this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<String> invoke(@NotNull Iterable<? extends File> $receiver) {
                void $receiver$iv$iv;
                Iterable<? extends File> $receiver$iv;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Iterable<? extends File> iterable = $receiver$iv = $receiver;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string = StringsKt.replace$default((String)FilesKt.relativeTo((File)it, (File)AbstractIncrementalCompilerRunnerTestBase.access$getWorkingDir$p(this.this$0)).getPath(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
                    collection.add(string);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = abstractIncrementalCompilerRunnerTestBase;
                super(1);
            }
        };
        File $receiver = file = new File(this.getWorkingDir(), "src");
        $receiver.mkdirs();
        File srcDir = file;
        File $receiver2 = $receiver = new File(this.getWorkingDir(), "incremental-data");
        $receiver2.mkdirs();
        File cacheDir = $receiver;
        File $receiver3 = $receiver2 = new File(this.getWorkingDir(), "out");
        $receiver3.mkdirs();
        File outDir = $receiver2;
        HashMap mapWorkingToOriginalFile = new HashMap(IncrementalModificationUtilsKt.copyTestSources(testDir, srcDir, ""));
        List sourceRoots = CollectionsKt.listOf((Object)srcDir);
        Args args = this.createCompilerArguments(outDir, testDir);
        Object object2 = this.make(cacheDir, sourceRoots, args);
        Collection<String> errors = ((TestCompilationResult)object2).component3();
        object2 = errors;
        if (!object2.isEmpty()) {
            throw (Throwable)new IllegalStateException("Initial build failed: \n" + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        File file2 = this.getBuildLogFinder().findBuildLog(testDir);
        if (file2 == null) {
            throw (Throwable)new IllegalStateException("build log file not found in " + this.getWorkingDir());
        }
        File buildLogFile = file2;
        List<BuildStep> buildLogSteps = TestLogsParsingUtilKt.parseTestBuildLog(buildLogFile);
        List<List<Modification>> modifications = IncrementalModificationUtilsKt.getModificationsToPerform(testDir, null, false, TouchPolicy.CHECKSUM);
        boolean bl2 = bl = modifications.size() == buildLogSteps.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Modifications count (" + modifications.size() + ") != expected build log steps count (" + buildLogSteps.size() + ')';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        StringBuilder expectedSB = new StringBuilder();
        StringBuilder actualSB = new StringBuilder();
        StringBuilder expectedSBWithoutErrors = new StringBuilder();
        StringBuilder actualSBWithoutErrors = new StringBuilder();
        int step = 1;
        for (Object object32 : CollectionsKt.zip((Iterable)modifications, (Iterable)buildLogSteps)) {
            void compiledSources;
            modificationStep = (List)object32.component1();
            BuildStep buildLogStep = (BuildStep)object32.component2();
            Iterable<File> $receiver$iv = (Iterable<File>)modificationStep;
            for (Object t : $receiver$iv) {
                Modification it = (Modification)t;
                it.perform(this.getWorkingDir(), (Map)mapWorkingToOriginalFile);
            }
            TestCompilationResult testCompilationResult = this.make(cacheDir, sourceRoots, args);
            $receiver$iv = testCompilationResult.component2();
            Collection<String> compileErrors = testCompilationResult.component3();
            this.appendLine(expectedSB, AbstractIncrementalCompilerRunnerTestBase.stepLogAsString$default(this, step, buildLogStep.getCompiledKotlinFiles(), buildLogStep.getCompileErrors(), false, 8, null));
            this.appendLine(expectedSBWithoutErrors, this.stepLogAsString(step, (Iterable<String>)buildLogStep.getCompiledKotlinFiles(), (Collection<String>)buildLogStep.getCompileErrors(), false));
            this.appendLine(actualSB, AbstractIncrementalCompilerRunnerTestBase.stepLogAsString$default(this, step, relativePaths$.invoke((Iterable<? extends File>)compiledSources), compileErrors, false, 8, null));
            this.appendLine(actualSBWithoutErrors, this.stepLogAsString(step, (Iterable<String>)relativePaths$.invoke((Iterable<? extends File>)compiledSources), compileErrors, false));
            ++step;
        }
        if (Intrinsics.areEqual((Object)expectedSBWithoutErrors.toString(), (Object)actualSBWithoutErrors.toString()) ^ true) {
            Assert.assertEquals((Object)expectedSB.toString(), (Object)actualSB.toString());
        }
        object32 = this;
        AbstractIncrementalCompilerRunnerTestBase $receiver4 = (AbstractIncrementalCompilerRunnerTestBase)((Object)object32);
        Object $receiver5 = modificationStep = new File($receiver4.getWorkingDir(), "rebuild-out");
        ((File)$receiver5).mkdirs();
        Object rebuildOutDir = modificationStep;
        Object $receiver6 = $receiver5 = new File($receiver4.getWorkingDir(), "rebuild-cache");
        ((File)$receiver6).mkdirs();
        Object rebuildCacheDir = $receiver5;
        TestCompilationResult rebuildResult = $receiver4.make((File)rebuildCacheDir, sourceRoots, $receiver4.createCompilerArguments((File)rebuildOutDir, testDir));
        boolean rebuildExpectedToSucceed = ((BuildStep)CollectionsKt.last(buildLogSteps)).getCompileSucceeded();
        boolean bl3 = Intrinsics.areEqual((Object)rebuildResult.getExitCode(), (Object)ExitCode.OK);
        Assert.assertEquals((String)"Rebuild exit code differs from incremental exit code", (Object)rebuildExpectedToSucceed, (Object)bl3);
        if (bl3) {
            ClassFilesComparisonKt.assertEqualDirectories(outDir, (File)rebuildOutDir, bl3);
        }
    }

    @NotNull
    protected BuildLogFinder getBuildLogFinder() {
        return new BuildLogFinder(false, true, false, 5, null);
    }

    @NotNull
    protected abstract TestCompilationResult make(@NotNull File var1, @NotNull Iterable<? extends File> var2, @NotNull Args var3);

    /*
     * WARNING - void declaration
     */
    private final String stepLogAsString(int step, Iterable<String> ktSources, Collection<String> errors, boolean includeErrors) {
        Object it;
        Object element$iv;
        StringBuilder sb = new StringBuilder();
        this.appendLine(sb, "<======= STEP " + step + " =======>");
        AbstractIncrementalCompilerRunnerTestBase.appendLine$default(this, sb, null, 1, null);
        this.appendLine(sb, "Compiled kotlin sources:");
        Object $receiver$iv = (Object[])CollectionsKt.toSet(ktSources);
        if ($receiver$iv == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Object[] thisCollection$iv2 = $receiver$iv;
        String[] stringArray = thisCollection$iv2.toArray(new String[thisCollection$iv2.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $receiver$iv = ArraysKt.sortedArray((Comparable[])((Comparable[])stringArray));
        for (int thisCollection$iv2 = 0; thisCollection$iv2 < ((Object[])$receiver$iv).length; ++thisCollection$iv2) {
            element$iv = $receiver$iv[thisCollection$iv2];
            it = (String)element$iv;
            this.appendLine(sb, (String)it);
        }
        AbstractIncrementalCompilerRunnerTestBase.appendLine$default(this, sb, null, 1, null);
        if (errors.isEmpty()) {
            this.appendLine(sb, "SUCCESS");
        } else {
            this.appendLine(sb, "FAILURE");
            if (includeErrors) {
                void $receiver$iv$iv;
                $receiver$iv = errors;
                Object thisCollection$iv2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    String p1 = (String)element$iv$iv;
                    CharSequence charSequence = p1;
                    if (!(charSequence.length() > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it = (String)element$iv;
                    this.appendLine(sb, (String)it);
                }
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    static /* bridge */ /* synthetic */ String stepLogAsString$default(AbstractIncrementalCompilerRunnerTestBase abstractIncrementalCompilerRunnerTestBase, int n, Iterable iterable, Collection collection, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stepLogAsString");
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return abstractIncrementalCompilerRunnerTestBase.stepLogAsString(n, iterable, collection, bl);
    }

    private final void appendLine(@NotNull StringBuilder $receiver, String line) {
        $receiver.append(line);
        $receiver.append('\n');
    }

    static /* bridge */ /* synthetic */ void appendLine$default(AbstractIncrementalCompilerRunnerTestBase abstractIncrementalCompilerRunnerTestBase, StringBuilder stringBuilder, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendLine");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        abstractIncrementalCompilerRunnerTestBase.appendLine(stringBuilder, string);
    }

    static {
        Companion = new Companion(null);
        bootstrapKotlincLib = new File("dependencies/bootstrap-compiler/Kotlin/kotlinc/lib");
    }

    @NotNull
    public static final /* synthetic */ File access$getWorkingDir$p(AbstractIncrementalCompilerRunnerTestBase $this) {
        return $this.getWorkingDir();
    }

    public static final /* synthetic */ void access$setWorkingDir$p(AbstractIncrementalCompilerRunnerTestBase $this, @NotNull File file) {
        $this.setWorkingDir(file);
    }

    @NotNull
    protected static final File getBootstrapKotlincLib() {
        return Companion.getBootstrapKotlincLib();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCompilerRunnerTestBase$Companion;", "", "()V", "bootstrapKotlincLib", "Ljava/io/File;", "bootstrapKotlincLib$annotations", "getBootstrapKotlincLib", "()Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        @JvmStatic
        protected static /* synthetic */ void bootstrapKotlincLib$annotations() {
        }

        @NotNull
        protected final File getBootstrapKotlincLib() {
            return bootstrapKotlincLib;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

