/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.DTDWriter;
import com.ibm.xmi.framework.DeclarationWriterWrapper;
import com.ibm.xmi.framework.MIME2Java;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.WriterFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class XMIDTD {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String encoding = "UTF-8";
    protected int indent = 2;
    private Vector declarations;
    private File file;
    private String model;
    private String version = "1.0";
    private boolean date = true;

    public XMIDTD(String string) {
        this.file = new File(string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getModel() {
        return this.model;
    }

    public Collection getDeclarations() {
        return this.declarations;
    }

    public String getXMIVersion() {
        return this.version;
    }

    public void setPrintDate(boolean bl) {
        this.date = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setModel(String string) {
        this.model = string;
    }

    public void setXMIVersion(String string) {
        this.version = string;
    }

    public void write(Iterator iterator) throws Exception {
        Object object;
        String string;
        this.declarations = new Vector();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.declarations.addElement(iterator.next());
            }
        }
        if ((string = this.file.getParent()) != null) {
            object = new File(string);
            ((File)object).mkdirs();
        }
        object = null;
        if (!this.file.getPath().equals("")) {
            object = new FileOutputStream(this.file);
        }
        String string2 = MIME2Java.convert(this.encoding);
        PrintWriter printWriter = null;
        if (object != null) {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)object, string2));
        }
        PrintXML.setPrintWriter(printWriter);
        DTDWriter dTDWriter = WriterFactory.makeDTDWriter(this, this.version);
        DeclarationWriterWrapper declarationWriterWrapper = new DeclarationWriterWrapper(AdapterFactoryRegister.getAdapterFactory().createDeclarationWriterAdapter());
        dTDWriter.setWrapper(declarationWriterWrapper);
        dTDWriter.setDate(this.date);
        dTDWriter.write(0, this.indent);
        ((OutputStream)object).close();
    }
}

