/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.Type;

public class ExpressionAccessor
extends Expression {
    ExpressionAccessor(Expression expression, Expression expression2) {
        super(95);
        this.nodes = new Expression[]{expression, expression2};
    }

    @Override
    public ColumnSchema getColumn() {
        return this.nodes[0].getColumn();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            hsqlList = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
        }
        return hsqlList;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType == null) {
            throw Error.error(5567);
        }
        if (!this.nodes[0].dataType.isArrayType()) {
            throw Error.error(5563);
        }
        this.dataType = this.nodes[0].dataType.collectionBaseType();
        if (this.nodes[1].opType == 8) {
            this.nodes[1].dataType = Type.SQL_INTEGER;
        }
    }

    @Override
    public Object getValue(Session session) {
        Object[] objectArray = (Object[])this.nodes[0].getValue(session);
        if (objectArray == null) {
            return null;
        }
        Number number = (Number)this.nodes[1].getValue(session);
        if (number == null) {
            return null;
        }
        if (number.intValue() < 1 || number.intValue() > objectArray.length) {
            throw Error.error(3490);
        }
        return objectArray[number.intValue() - 1];
    }

    public Object[] getUpdatedArray(Session session, Object[] objectArray, Object object, boolean bl) {
        if (objectArray == null) {
            throw Error.error(3413);
        }
        Number number = (Number)this.nodes[1].getValue(session);
        if (number == null) {
            throw Error.error(3490);
        }
        int n = number.intValue() - 1;
        if (n < 0) {
            throw Error.error(3490);
        }
        if (n >= this.nodes[0].dataType.arrayLimitCardinality()) {
            throw Error.error(3490);
        }
        Object[] objectArray2 = objectArray;
        if (n >= objectArray.length) {
            objectArray2 = new Object[n + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        } else if (bl) {
            objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        objectArray2[n] = object;
        return objectArray2;
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = ExpressionAccessor.getContextSQL(this.nodes[0]);
        stringBuffer.append(string).append('[');
        stringBuffer.append(this.nodes[1].getSQL()).append(']');
        return stringBuffer.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("ARRAY ACCESS");
        if (this.getLeftNode() != null) {
            stringBuffer.append(" array=[");
            stringBuffer.append(this.nodes[0].describe(session, n + 1));
            stringBuffer.append(']');
        }
        if (this.getRightNode() != null) {
            stringBuffer.append(" array_index=[");
            stringBuffer.append(this.nodes[1].describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }
}

