define(["loading","dom","globalize","humanedate","paper-icon-button-light","cardStyle","emby-linkbutton","indicators","flexStyles"],function(loading,dom,globalize){"use strict";function deleteUser(page,id){var msg=globalize.translate("DeleteUserConfirmation");require(["confirm"],function(confirm){confirm({title:globalize.translate("DeleteUser"),text:msg,confirmText:globalize.translate("ButtonDelete"),primary:"cancel"}).then(function(){loading.show(),ApiClient.deleteUser(id).then(function(){loadData(page)})})})}function showUserMenu(elem){var card=dom.parentWithClass(elem,"card"),page=dom.parentWithClass(card,"page"),userId=card.getAttribute("data-userid"),menuItems=[];menuItems.push({name:globalize.translate("ButtonOpen"),id:"open",ironIcon:"mode-edit"}),menuItems.push({name:globalize.translate("ButtonLibraryAccess"),id:"access",ironIcon:"lock"}),menuItems.push({name:globalize.translate("ButtonParentalControl"),id:"parentalcontrol",ironIcon:"person"}),menuItems.push({name:globalize.translate("ButtonDelete"),id:"delete",ironIcon:"delete"}),require(["actionsheet"],function(actionsheet){actionsheet.show({items:menuItems,positionTo:card,callback:function(id){switch(id){case"open":Dashboard.navigate("useredit.html?userId="+userId);break;case"access":Dashboard.navigate("userlibraryaccess.html?userId="+userId);break;case"parentalcontrol":Dashboard.navigate("userparentalcontrol.html?userId="+userId);break;case"delete":deleteUser(page,userId)}}})})}function getUserHtml(user,addConnectIndicator){var html="",cssClass="card squareCard scalableCard squareCard-scalable";user.Policy.IsDisabled&&(cssClass+=" grayscale"),html+="<div data-userid='"+user.Id+"' class='"+cssClass+"'>",html+='<div class="cardBox visualCardBox">',html+='<div class="cardScalable visualCardBox-cardScalable">',html+='<div class="cardPadder cardPadder-square"></div>';var href="useredit.html?userId="+user.Id;html+='<a is="emby-linkbutton" class="cardContent" href="'+href+'">';var imgUrl;user.PrimaryImageTag&&(imgUrl=ApiClient.getUserImageUrl(user.Id,{width:300,tag:user.PrimaryImageTag,type:"Primary"}));var imageClass="cardImage";user.Policy.IsDisabled&&(imageClass+=" disabledUser"),imgUrl?html+='<div class="'+imageClass+'" style="background-image:url(\''+imgUrl+"');\">":(html+='<div class="'+imageClass+' flex align-items-center justify-content-center">',html+='<i class="md-icon cardImageIcon">person</i>'),user.ConnectUserId&&addConnectIndicator&&(html+='<div class="cardIndicators squareCardIndicators"><div title="'+globalize.translate("TooltipLinkedToEmbyConnect")+'" class="playedIndicator indicator"><i class="md-icon indicatorIcon">cloud</i></div></div>'),html+="</div>",html+="</a>",html+="</div>",html+='<div class="cardFooter visualCardBox-cardFooter">',html+='<div style="text-align:right; float:right;padding:0;">',html+='<button type="button" is="paper-icon-button-light" class="btnUserMenu autoSize"><i class="md-icon">more_vert</i></button>',html+="</div>",html+='<div class="cardText" style="padding-top:10px;padding-bottom:10px;">',html+=user.Name,html+="</div>",html+='<div class="cardText cardText-secondary">';var lastSeen=getLastSeenText(user.LastActivityDate);return html+=""!=lastSeen?lastSeen:"&nbsp;",html+="</div>",html+="</div>",html+="</div>",html+="</div>"}function getLastSeenText(lastActivityDate){return lastActivityDate?"Last seen "+humane_date(lastActivityDate):""}function getUserSectionHtml(users,addConnectIndicator){var html="";return html+=users.map(function(u){return getUserHtml(u,addConnectIndicator)}).join("")}function renderUsersIntoElement(elem,users,addConnectIndicator){elem.innerHTML=getUserSectionHtml(users,addConnectIndicator)}function renderUsers(page,users){renderUsersIntoElement(page.querySelector(".localUsers"),users.filter(function(u){return"Guest"!==u.ConnectLinkType}),!0),renderUsersIntoElement(page.querySelector(".connectUsers"),users.filter(function(u){return"Guest"===u.ConnectLinkType}))}function showPendingUserMenu(elem){var menuItems=[];menuItems.push({name:globalize.translate("ButtonCancel"),id:"delete",ironIcon:"delete"}),require(["actionsheet"],function(actionsheet){var card=dom.parentWithClass(elem,"card"),page=dom.parentWithClass(card,"page"),id=card.getAttribute("data-id");actionsheet.show({items:menuItems,positionTo:card,callback:function(menuItemId){switch(menuItemId){case"delete":cancelAuthorization(page,id)}}})})}function getPendingUserHtml(user){var html="",cssClass="card squareCard scalableCard squareCard-scalable";html+="<div data-id='"+user.Id+"' class='"+cssClass+"'>",html+='<div class="cardBox cardBox-bottompadded visualCardBox">',html+='<div class="cardScalable visualCardBox-cardScalable">',html+='<div class="cardPadder cardPadder-square"></div>';var href="#";html+='<a class="cardContent" is="emby-linkbutton" href="'+href+'">';var imgUrl=user.ImageUrl||"css/images/userflyoutdefault.png";return html+='<div class="cardImage" style="background-image:url(\''+imgUrl+"');\">",html+="</div>",html+="</a>",html+="</div>",html+='<div class="cardFooter visualCardBox-cardFooter">',html+='<div class="cardText" style="text-align:right; float:right;padding:0;">',html+='<button type="button" is="paper-icon-button-light" class="btnUserMenu"><i class="md-icon">more_vert</i></button>',html+="</div>",html+='<div class="cardText" style="padding-top:10px;padding-bottom:10px;">',html+=user.UserName,html+="</div>",html+="</div>",html+="</div>",html+="</div>"}function renderPendingGuests(page,users){users.length?page.querySelector(".sectionPendingGuests").classList.remove("hide"):page.querySelector(".sectionPendingGuests").classList.add("hide");var html=users.map(getPendingUserHtml).join("");page.querySelector(".pending").innerHTML=html}function cancelAuthorization(page,id){loading.show(),ApiClient.ajax({type:"DELETE",url:ApiClient.getUrl("Connect/Pending",{Id:id})}).then(function(){loadData(page)})}function loadData(page){loading.show(),ApiClient.getUsers().then(function(users){renderUsers(page,users),loading.hide()}),ApiClient.getJSON(ApiClient.getUrl("Connect/Pending")).then(function(pending){renderPendingGuests(page,pending)})}function showLinkUser(page,userId){require(["components/guestinviter/connectlink"],function(connectlink){connectlink.show().then(function(){loadData(page)})})}function showInvitePopup(page){Dashboard.getCurrentUser().then(function(user){return user.ConnectUserId?void require(["components/guestinviter/guestinviter"],function(guestinviter){guestinviter.show().then(function(){loadData(page)})}):void showLinkUser(page,user.Id)})}pageIdOn("pageinit","userProfilesPage",function(){var page=this;page.querySelector(".btnInvite").addEventListener("click",function(){showInvitePopup(page)}),page.querySelector(".btnAddUser").addEventListener("click",function(){Dashboard.navigate("usernew.html")}),page.querySelector(".btnAddUser").addEventListener("click",function(){Dashboard.navigate("usernew.html")}),page.querySelector(".localUsers").addEventListener("click",function(e){var btnUserMenu=dom.parentWithClass(e.target,"btnUserMenu");btnUserMenu&&showUserMenu(btnUserMenu)}),page.querySelector(".connectUsers").addEventListener("click",function(e){var btnUserMenu=dom.parentWithClass(e.target,"btnUserMenu");btnUserMenu&&showUserMenu(btnUserMenu)}),page.querySelector(".pending").addEventListener("click",function(e){var btnUserMenu=dom.parentWithClass(e.target,"btnUserMenu");btnUserMenu&&showPendingUserMenu(btnUserMenu)})}),pageIdOn("pagebeforeshow","userProfilesPage",function(){var page=this;loadData(page)})});