/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web.extension;

import com.google.inject.Injector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import net.arnx.jsonic.web.Container;

public class GuiceContainer
extends Container {
    Logger log;
    Injector injector;

    public void init(HttpServlet httpServlet) throws ServletException {
        super.init(httpServlet);
        this.log = Logger.getLogger(httpServlet.getClass().getName());
        this.injector = (Injector)this.context.getAttribute(Injector.class.getName());
    }

    public Object getComponent(String string) throws Exception {
        return this.injector.getInstance(this.findClass(string));
    }

    public boolean isDebugMode() {
        return this.debug != null ? this.debug.booleanValue() : this.log.isLoggable(Level.FINE);
    }

    public void debug(String string, Throwable throwable) {
        if (throwable != null) {
            this.log.log(Level.FINE, string, throwable);
        } else {
            this.log.log(Level.FINE, string);
        }
    }

    public void warn(String string, Throwable throwable) {
        if (throwable != null) {
            this.log.log(Level.WARNING, string, throwable);
        } else {
            this.log.log(Level.WARNING, string);
        }
    }

    public void error(String string, Throwable throwable) {
        if (throwable != null) {
            this.log.log(Level.SEVERE, string, throwable);
        } else {
            this.log.log(Level.SEVERE, string);
        }
    }
}

