/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.Field;
import tim.prune.data.PointCreateOptions;
import tim.prune.data.SourceInfo;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.WizardLayout;
import tim.prune.load.ComponentHider;
import tim.prune.load.DelimiterInfo;
import tim.prune.load.FieldGuesser;
import tim.prune.load.FieldSelectionTableModel;
import tim.prune.load.FileCacher;
import tim.prune.load.FileExtractTableModel;
import tim.prune.load.FileSplitter;
import tim.prune.load.OneCharDocument;

public class TextFileLoader {
    private File _file = null;
    private App _app = null;
    private JFrame _parentFrame = null;
    private JDialog _dialog = null;
    private WizardLayout _wizard = null;
    private JButton _backButton = null;
    private JButton _nextButton = null;
    private JButton _finishButton = null;
    private JButton _moveUpButton = null;
    private JButton _moveDownButton = null;
    private JRadioButton[] _delimiterRadios = null;
    private JTextField _otherDelimiterText = null;
    private JLabel _statusLabel = null;
    private DelimiterInfo[] _delimiterInfos = null;
    private FileCacher _fileCacher = null;
    private JList<String> _snippetBox = null;
    private FileExtractTableModel _fileExtractTableModel = null;
    private JTable _fieldTable;
    private FieldSelectionTableModel _fieldTableModel = null;
    private JComboBox<String> _altitudeUnitsDropdown = null;
    private JComboBox<String> _hSpeedUnitsDropdown = null;
    private JComboBox<String> _vSpeedUnitsDropdown = null;
    private JRadioButton _vSpeedUpwardsRadio = null;
    private ComponentHider _componentHider = null;
    private int _selectedField = -1;
    private char _currentDelimiter = (char)44;
    private char _lastUsedDelimiter = (char)44;
    private Field[] _lastSelectedFields = null;
    private Unit _lastAltitudeUnit = null;
    private static final int SNIPPET_SIZE = 6;
    private static final int MAX_SNIPPET_WIDTH = 80;
    private static final char[] DELIMITERS = new char[]{',', '\t', ';', ' '};

    public TextFileLoader(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
    }

    public void openFile(File file) {
        this._file = file;
        if (this.preCheckFile(this._file)) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.openoptions.title"), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(0);
            this._dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TextFileLoader.this._dialog.dispose();
                    TextFileLoader.this._app.informNoDataLoaded();
                }
            });
            this._dialog.getContentPane().add(this.makeDialogComponents());
            int n = TextFileLoader.getBestOption(this._delimiterInfos[0].getNumWinningRecords(), this._delimiterInfos[1].getNumWinningRecords(), this._delimiterInfos[2].getNumWinningRecords(), this._delimiterInfos[3].getNumWinningRecords());
            if (n >= 0) {
                this._delimiterRadios[n].setSelected(true);
            } else {
                this._delimiterRadios[this._delimiterRadios.length - 1].setSelected(true);
            }
            this.informDelimiterSelected();
            this._dialog.pack();
            this._dialog.setVisible(true);
        } else {
            this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.noread")) + ": " + file.getName());
            this._app.informNoDataLoaded();
        }
    }

    private boolean preCheckFile(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return false;
        }
        this._fileCacher = new FileCacher(file);
        String[] stringArray = this._fileCacher.getContents();
        if (stringArray == null) {
            return false;
        }
        boolean bl = true;
        this._delimiterInfos = new DelimiterInfo[5];
        int n = 0;
        while (n < 4) {
            this._delimiterInfos[n] = new DelimiterInfo(DELIMITERS[n]);
            ++n;
        }
        String string = null;
        String[] stringArray2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < stringArray.length && bl) {
            string = stringArray[n6];
            if (string.indexOf(0) >= 0) {
                bl = false;
            }
            if ((n2 = (stringArray2 = string.split(",")).length) > 1) {
                this._delimiterInfos[0].incrementNumRecords();
            }
            this._delimiterInfos[0].updateMaxFields(n2);
            stringArray2 = string.split("\t");
            n4 = stringArray2.length;
            if (n4 > 1) {
                this._delimiterInfos[1].incrementNumRecords();
            }
            this._delimiterInfos[1].updateMaxFields(n4);
            stringArray2 = string.split(";");
            n3 = stringArray2.length;
            if (n3 > 1) {
                this._delimiterInfos[2].incrementNumRecords();
            }
            this._delimiterInfos[2].updateMaxFields(n3);
            stringArray2 = string.split(" ");
            n5 = stringArray2.length;
            if (n5 > 1) {
                this._delimiterInfos[3].incrementNumRecords();
            }
            this._delimiterInfos[3].updateMaxFields(n5);
            int n7 = TextFileLoader.getBestOption(n2, n4, n3, n5);
            if (n7 >= 0) {
                this._delimiterInfos[n7].incrementNumWinningRecords();
            }
            ++n6;
        }
        return bl;
    }

    private static int getBestOption(int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = 1;
        if (n > n6) {
            n5 = 0;
            n6 = n;
        }
        if (n2 > n6) {
            n5 = 1;
            n6 = n2;
        }
        if (n3 > n6) {
            n5 = 2;
            n6 = n3;
        }
        if (n4 > n6) {
            n5 = 3;
            n6 = n4;
        }
        return n5;
    }

    private Component makeDialogComponents() {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        this._backButton = new JButton(I18nManager.getText("button.back"));
        this._backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFileLoader.this._wizard.showPreviousCard();
                TextFileLoader.this._nextButton.setEnabled(!TextFileLoader.this._wizard.isLastCard());
                TextFileLoader.this._backButton.setEnabled(!TextFileLoader.this._wizard.isFirstCard());
                TextFileLoader.this._finishButton.setEnabled(false);
            }
        });
        this._backButton.setEnabled(false);
        jPanel2.add(this._backButton);
        this._nextButton = new JButton(I18nManager.getText("button.next"));
        this._nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFileLoader.this.prepareNextPanel();
                TextFileLoader.this._wizard.showNextCard();
                TextFileLoader.this._nextButton.setEnabled(!TextFileLoader.this._wizard.isLastCard() && TextFileLoader.this.isCurrentCardValid());
                TextFileLoader.this._backButton.setEnabled(!TextFileLoader.this._wizard.isFirstCard());
                TextFileLoader.this._finishButton.setEnabled(TextFileLoader.this._wizard.isLastCard() && TextFileLoader.this.isCurrentCardValid());
            }
        });
        jPanel2.add(this._nextButton);
        this._finishButton = new JButton(I18nManager.getText("button.finish"));
        this._finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFileLoader.this.finished();
            }
        });
        this._finishButton.setEnabled(false);
        jPanel2.add(this._finishButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFileLoader.this._dialog.dispose();
                TextFileLoader.this._app.informNoDataLoaded();
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        this._wizard = new WizardLayout(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 2));
        jPanel5.add(new JLabel(I18nManager.getText("dialog.delimiter.label")));
        jPanel5.add(new JLabel(""));
        this._delimiterRadios = new JRadioButton[5];
        this._delimiterRadios[0] = new JRadioButton(I18nManager.getText("dialog.delimiter.comma"));
        jPanel5.add(this._delimiterRadios[0]);
        this._delimiterRadios[1] = new JRadioButton(I18nManager.getText("dialog.delimiter.tab"));
        jPanel5.add(this._delimiterRadios[1]);
        this._delimiterRadios[2] = new JRadioButton(I18nManager.getText("dialog.delimiter.semicolon"));
        jPanel5.add(this._delimiterRadios[2]);
        this._delimiterRadios[3] = new JRadioButton(I18nManager.getText("dialog.delimiter.space"));
        jPanel5.add(this._delimiterRadios[3]);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 0, 0));
        this._delimiterRadios[4] = new JRadioButton(I18nManager.getText("dialog.delimiter.other"));
        jPanel6.add(this._delimiterRadios[4]);
        this._otherDelimiterText = new JTextField(new OneCharDocument(), null, 2);
        jPanel6.add(this._otherDelimiterText);
        ButtonGroup buttonGroup = new ButtonGroup();
        DelimListener delimListener = new DelimListener();
        int n = 0;
        while (n < this._delimiterRadios.length) {
            buttonGroup.add(this._delimiterRadios[n]);
            this._delimiterRadios[n].addActionListener(delimListener);
            ++n;
        }
        this._otherDelimiterText.getDocument().addDocumentListener(delimListener);
        jPanel5.add(new JLabel(""));
        jPanel5.add(jPanel6);
        this._statusLabel = new JLabel("");
        jPanel5.add(this._statusLabel);
        jPanel4.add((Component)jPanel5, "South");
        this._snippetBox = new JList<String>(this._fileCacher.getSnippet(6, 80));
        this._snippetBox.setEnabled(false);
        jPanel4.add((Component)TextFileLoader.makeLabelledPanel("dialog.openoptions.filesnippet", this._snippetBox), "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        this._fileExtractTableModel = new FileExtractTableModel();
        JTable jTable = new JTable(this._fileExtractTableModel);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(350, 80));
        jTable.getTableHeader().setReorderingAllowed(false);
        jPanel7.add((Component)TextFileLoader.makeLabelledPanel("dialog.openoptions.filesnippet", jScrollPane), "North");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._fieldTable = new JTable(new FieldSelectionTableModel());
        this._fieldTable.setSelectionMode(0);
        this._fieldTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    TextFileLoader.this.selectField(-1);
                } else {
                    TextFileLoader.this.selectField(listSelectionModel.getMinSelectionIndex());
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this._fieldTable);
        jScrollPane2.setPreferredSize(new Dimension(300, 100));
        jPanel8.add((Component)jScrollPane2, "Center");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        this._moveUpButton = new JButton(I18nManager.getText("button.moveup"));
        this._moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TextFileLoader.this._fieldTable.getSelectedRow();
                TextFileLoader.this.closeTableComboBox(n);
                TextFileLoader.this._fieldTableModel.moveUp(n);
                TextFileLoader.this._fieldTable.setRowSelectionInterval(n - 1, n - 1);
            }
        });
        jPanel9.add(this._moveUpButton);
        this._moveDownButton = new JButton(I18nManager.getText("button.movedown"));
        this._moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TextFileLoader.this._fieldTable.getSelectedRow();
                TextFileLoader.this.closeTableComboBox(n);
                TextFileLoader.this._fieldTableModel.moveDown(n);
                TextFileLoader.this._fieldTable.setRowSelectionInterval(n + 1, n + 1);
            }
        });
        jPanel9.add(this._moveDownButton);
        jPanel9.add(Box.createVerticalStrut(60));
        JButton jButton2 = new JButton(I18nManager.getText("button.guessfields"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFileLoader.this._lastSelectedFields = null;
                TextFileLoader.this.prepareSecondPanel();
            }
        });
        jPanel9.add(jButton2);
        jPanel8.add((Component)jPanel9, "East");
        jPanel7.add((Component)jPanel8, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(10, 10));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        JPanel jPanel12 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel12);
        jPanel12.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("fieldname.altitude")));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.openoptions.altitudeunits")) + ": ");
        guiGridLayout.add(jLabel);
        String[] stringArray = new String[]{I18nManager.getText("units.metres"), I18nManager.getText("units.feet")};
        this._altitudeUnitsDropdown = new JComboBox<String>(stringArray);
        guiGridLayout.add(this._altitudeUnitsDropdown);
        jPanel11.add(jPanel12);
        JPanel jPanel13 = new JPanel();
        GuiGridLayout guiGridLayout2 = new GuiGridLayout(jPanel13);
        jPanel13.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("fieldname.speed")));
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("dialog.openoptions.speedunits")) + ": ");
        guiGridLayout2.add(jLabel2);
        this._hSpeedUnitsDropdown = new JComboBox();
        Object object2 = UnitSetLibrary.ALL_SPEED_UNITS;
        int n2 = UnitSetLibrary.ALL_SPEED_UNITS.length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            this._hSpeedUnitsDropdown.addItem(I18nManager.getText(((Unit)object).getNameKey()));
            ++n3;
        }
        guiGridLayout2.add(this._hSpeedUnitsDropdown);
        jPanel11.add(jPanel13);
        object = new JPanel();
        GuiGridLayout guiGridLayout3 = new GuiGridLayout((JPanel)object);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(I18nManager.getText("fieldname.verticalspeed")));
        JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("dialog.openoptions.vertspeedunits")) + ": ");
        guiGridLayout3.add(jLabel3);
        this._vSpeedUnitsDropdown = new JComboBox();
        Unit[] unitArray = UnitSetLibrary.ALL_SPEED_UNITS;
        int n4 = UnitSetLibrary.ALL_SPEED_UNITS.length;
        int n5 = 0;
        while (n5 < n4) {
            object2 = unitArray[n5];
            this._vSpeedUnitsDropdown.addItem(I18nManager.getText(((Unit)object2).getNameKey()));
            ++n5;
        }
        guiGridLayout3.add(this._vSpeedUnitsDropdown);
        this._vSpeedUpwardsRadio = new JRadioButton(I18nManager.getText("dialog.openoptions.vspeed.positiveup"));
        object2 = new JRadioButton(I18nManager.getText("dialog.openoptions.vspeed.positivedown"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this._vSpeedUpwardsRadio);
        buttonGroup2.add((AbstractButton)object2);
        guiGridLayout3.add(this._vSpeedUpwardsRadio);
        guiGridLayout3.add((JComponent)object2);
        this._vSpeedUpwardsRadio.setSelected(true);
        jPanel11.add((Component)object);
        jPanel10.add((Component)jPanel11, "North");
        this._componentHider = new ComponentHider();
        this._componentHider.addComponent(jLabel, Field.ALTITUDE);
        this._componentHider.addComponent(this._altitudeUnitsDropdown, Field.ALTITUDE);
        this._componentHider.addComponent(jLabel2, Field.SPEED);
        this._componentHider.addComponent(this._hSpeedUnitsDropdown, Field.SPEED);
        this._componentHider.addComponent(jLabel3, Field.VERTICAL_SPEED);
        this._componentHider.addComponent(this._vSpeedUnitsDropdown, Field.VERTICAL_SPEED);
        this._componentHider.addComponent(this._vSpeedUpwardsRadio, Field.VERTICAL_SPEED);
        this._componentHider.addComponent((Component)object2, Field.VERTICAL_SPEED);
        this._wizard.addCard(jPanel4);
        this._wizard.addCard(jPanel7);
        this._wizard.addCard(jPanel10);
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private void closeTableComboBox(int n) {
        TableCellEditor tableCellEditor = this._fieldTable.getCellEditor(n, 1);
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    protected void informDelimiterSelected() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._delimiterRadios.length - 1) {
            if (this._delimiterRadios[n2].isSelected()) {
                int n3 = this._delimiterInfos[n2].getNumRecords();
                if (n3 == 0) {
                    this._statusLabel.setText(I18nManager.getText("dialog.openoptions.deliminfo.norecords"));
                } else {
                    n = this._delimiterInfos[n2].getMaxFields();
                    this._statusLabel.setText(n3 + " " + I18nManager.getText("dialog.openoptions.deliminfo.records") + " " + n + " " + I18nManager.getText("dialog.openoptions.deliminfo.fields"));
                }
            }
            ++n2;
        }
        if (this._delimiterRadios[this._delimiterRadios.length - 1].isSelected()) {
            this._statusLabel.setText("");
        }
        this._nextButton.setEnabled(!this._delimiterRadios[4].isSelected() && n > 1 || this._otherDelimiterText.getText().length() == 1);
    }

    public DelimiterInfo getSelectedDelimiterInfo() {
        int n = 0;
        while (n < 4) {
            if (this._delimiterRadios[n].isSelected()) {
                return this._delimiterInfos[n];
            }
            ++n;
        }
        if (this._delimiterInfos[4] == null) {
            this._delimiterInfos[4] = new DelimiterInfo(this._otherDelimiterText.getText().charAt(0));
        }
        return this._delimiterInfos[4];
    }

    private void prepareNextPanel() {
        int n = this._wizard.getCurrentCardIndex();
        if (n == 0) {
            this.prepareSecondPanel();
        } else if (n == 1) {
            Field[] fieldArray = this._fieldTableModel.getFieldArray();
            this._componentHider.enableComponents(Field.ALTITUDE, this.doesFieldArrayContain(fieldArray, Field.ALTITUDE));
            this._componentHider.enableComponents(Field.SPEED, this.doesFieldArrayContain(fieldArray, Field.SPEED));
            this._componentHider.enableComponents(Field.VERTICAL_SPEED, this.doesFieldArrayContain(fieldArray, Field.VERTICAL_SPEED));
        }
    }

    private void prepareSecondPanel() {
        DelimiterInfo delimiterInfo = this.getSelectedDelimiterInfo();
        FileSplitter fileSplitter = new FileSplitter(this._fileCacher);
        Object[][] objectArray = fileSplitter.splitFieldData(delimiterInfo.getDelimiter());
        this._currentDelimiter = delimiterInfo.getDelimiter();
        this._fileExtractTableModel.updateData(objectArray);
        this._fieldTableModel = new FieldSelectionTableModel();
        Field[] fieldArray = null;
        fieldArray = this._lastSelectedFields != null && fileSplitter.getNumColumns() == this._lastSelectedFields.length ? this._lastSelectedFields : FieldGuesser.guessFields(fileSplitter.getFirstFullRow());
        this._fieldTableModel.updateData(fieldArray);
        this._fieldTable.setModel(this._fieldTableModel);
        JComboBox<String> jComboBox = new JComboBox<String>();
        String[] stringArray = Field.getFieldNames();
        int n = 0;
        while (n < stringArray.length) {
            jComboBox.addItem(stringArray[n]);
            ++n;
        }
        this._fieldTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        if (this._lastAltitudeUnit == UnitSetLibrary.UNITS_METRES) {
            this._altitudeUnitsDropdown.setSelectedIndex(0);
        } else if (this._lastAltitudeUnit == UnitSetLibrary.UNITS_FEET) {
            this._altitudeUnitsDropdown.setSelectedIndex(1);
        }
        this.selectField(-1);
    }

    private boolean doesFieldArrayContain(Field[] fieldArray, Field field) {
        if (fieldArray != null) {
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n] == field) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void finished() {
        this._lastUsedDelimiter = this._currentDelimiter;
        this._lastSelectedFields = this._fieldTableModel.getFieldArray();
        SourceInfo sourceInfo = new SourceInfo(this._file, SourceInfo.FILE_TYPE.TEXT);
        PointCreateOptions pointCreateOptions = new PointCreateOptions();
        pointCreateOptions.setAltitudeUnits(this._altitudeUnitsDropdown.getSelectedIndex() == 0 ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET);
        Unit unit = UnitSetLibrary.ALL_SPEED_UNITS[this._hSpeedUnitsDropdown.getSelectedIndex()];
        pointCreateOptions.setSpeedUnits(unit);
        Unit unit2 = UnitSetLibrary.ALL_SPEED_UNITS[this._vSpeedUnitsDropdown.getSelectedIndex()];
        pointCreateOptions.setVerticalSpeedUnits(unit2, this._vSpeedUpwardsRadio.isSelected());
        this._app.informDataLoaded(this._fieldTableModel.getFieldArray(), this._fileExtractTableModel.getData(), pointCreateOptions, sourceInfo, null);
        this._fileCacher.clear();
        this._dialog.dispose();
    }

    private boolean isCurrentCardValid() {
        int n = this._wizard.getCurrentCardIndex();
        if (n == 1) {
            return this._fieldTableModel.getRowCount() > 1;
        }
        return true;
    }

    private static JPanel makeLabelledPanel(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText(string)), "North");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    private void selectField(int n) {
        if (n == -1 || n != this._selectedField) {
            this._selectedField = n;
            this._moveUpButton.setEnabled(n > 0);
            this._moveDownButton.setEnabled(n >= 0 && n < this._fieldTableModel.getRowCount() - 1);
        }
    }

    public char getLastUsedDelimiter() {
        return this._lastUsedDelimiter;
    }

    private class DelimListener
    implements ActionListener,
    DocumentListener {
        private DelimListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextFileLoader.this.informDelimiterSelected();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            TextFileLoader.this.informDelimiterSelected();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TextFileLoader.this.informDelimiterSelected();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextFileLoader.this.informDelimiterSelected();
        }
    }
}

