/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiParameterListImpl
extends JavaStubPsiElement<PsiParameterListStub>
implements PsiParameterList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiParameterListImpl");

    public PsiParameterListImpl(@NotNull PsiParameterListStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiParameterListImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.PARAMETER_LIST);
    }

    public PsiParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/PsiParameterListImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiParameter[] getParameters() {
        PsiParameter[] psiParameterArray = (PsiParameter[])this.getStubOrPsiChildren(JavaStubElementTypes.PARAMETER, PsiParameter.ARRAY_FACTORY);
        if (psiParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterListImpl", "getParameters"));
        }
        return psiParameterArray;
    }

    @Override
    public int getParameterIndex(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/psi/impl/source/PsiParameterListImpl", "getParameterIndex"));
        }
        LOG.assertTrue(parameter.getParent() == this);
        return PsiImplUtil.getParameterIndex(parameter, this);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterListImpl", "getNode"));
        }
        return compositeElement;
    }

    @Override
    public int getParametersCount() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            return (int)stub.getChildrenStubs().stream().filter(child -> child.getStubType() == JavaStubElementTypes.PARAMETER).count();
        }
        return this.getNode().countChildren(Constants.PARAMETER_BIT_SET);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiParameterListImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiParameterList:" + this.getText();
    }
}

