/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.KotlinToJvmSignatureMapper;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.KotlinToJvmSignatureMapperKt;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturePropagationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class SignaturesPropagationData {
    private static final KotlinToJvmSignatureMapper SIGNATURE_MAPPER = ServiceLoader.load(KotlinToJvmSignatureMapper.class, KotlinToJvmSignatureMapper.class.getClassLoader()).iterator().next();
    private final ValueParameters modifiedValueParameters;
    private final List<String> signatureErrors;
    private final List<FunctionDescriptor> superFunctions;

    public SignaturesPropagationData(@NotNull ClassDescriptor containingClass, @NotNull KotlinType autoReturnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters, @NotNull JavaMethod method) {
        if (containingClass == null) {
            SignaturesPropagationData.$$$reportNull$$$0(0);
        }
        if (autoReturnType == null) {
            SignaturesPropagationData.$$$reportNull$$$0(1);
        }
        if (autoValueParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(2);
        }
        if (autoTypeParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(3);
        }
        if (method == null) {
            SignaturesPropagationData.$$$reportNull$$$0(4);
        }
        this.signatureErrors = new ArrayList<String>(0);
        assert (receiverType == null) : "Parameters before propagation have receiver type, but propagation should be disabled for functions compiled from Kotlin in class: " + DescriptorUtils.getFqName(containingClass);
        JavaMethodDescriptor autoMethodDescriptor = SignaturesPropagationData.createAutoMethodDescriptor(containingClass, method, autoReturnType, autoValueParameters, autoTypeParameters);
        this.superFunctions = SignaturesPropagationData.getSuperFunctionsForMethod(method, autoMethodDescriptor, containingClass);
        this.modifiedValueParameters = this.superFunctions.isEmpty() ? new ValueParameters(null, autoValueParameters, false) : this.modifyValueParametersAccordingToSuperMethods(autoValueParameters);
    }

    @NotNull
    private static JavaMethodDescriptor createAutoMethodDescriptor(@NotNull ClassDescriptor containingClass, @NotNull JavaMethod method, KotlinType autoReturnType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters) {
        if (containingClass == null) {
            SignaturesPropagationData.$$$reportNull$$$0(5);
        }
        if (method == null) {
            SignaturesPropagationData.$$$reportNull$$$0(6);
        }
        if (autoValueParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(7);
        }
        if (autoTypeParameters == null) {
            SignaturesPropagationData.$$$reportNull$$$0(8);
        }
        JavaMethodDescriptor autoMethodDescriptor = JavaMethodDescriptor.createJavaMethod(containingClass, Annotations.Companion.getEMPTY(), method.getName(), SourceElement.NO_SOURCE);
        autoMethodDescriptor.initialize((KotlinType)null, containingClass.getThisAsReceiverParameter(), autoTypeParameters, (List)autoValueParameters, autoReturnType, Modality.OPEN, Visibilities.PUBLIC);
        JavaMethodDescriptor javaMethodDescriptor = autoMethodDescriptor;
        if (javaMethodDescriptor == null) {
            SignaturesPropagationData.$$$reportNull$$$0(9);
        }
        return javaMethodDescriptor;
    }

    public KotlinType getModifiedReceiverType() {
        return this.modifiedValueParameters.receiverType;
    }

    public List<ValueParameterDescriptor> getModifiedValueParameters() {
        return this.modifiedValueParameters.descriptors;
    }

    public boolean getModifiedHasStableParameterNames() {
        return this.modifiedValueParameters.hasStableParameterNames;
    }

    public List<String> getSignatureErrors() {
        return this.signatureErrors;
    }

    void reportError(String error) {
        this.signatureErrors.add(error);
    }

    private ValueParameters modifyValueParametersAccordingToSuperMethods(@NotNull List<ValueParameterDescriptor> parameters2) {
        if (parameters2 == null) {
            SignaturesPropagationData.$$$reportNull$$$0(10);
        }
        KotlinType resultReceiverType = null;
        ArrayList<ValueParameterDescriptor> resultParameters = new ArrayList<ValueParameterDescriptor>(parameters2.size());
        boolean shouldBeExtension = this.checkIfShouldBeExtension();
        for (ValueParameterDescriptor originalParam : parameters2) {
            int originalIndex = originalParam.getIndex();
            List<TypeAndName> typesFromSuperMethods = CollectionsKt.map(this.superFunctions, superFunction -> {
                int index2;
                ReceiverParameterDescriptor receiver = superFunction.getExtensionReceiverParameter();
                int n = index2 = receiver != null ? originalIndex - 1 : originalIndex;
                if (index2 == -1) {
                    assert (receiver != null) : "can't happen: index is -1, while function is not extension";
                    return new TypeAndName(receiver.getType(), originalParam.getName());
                }
                ValueParameterDescriptor parameter = superFunction.getValueParameters().get(index2);
                return new TypeAndName(parameter.getType(), parameter.getName());
            });
            VarargCheckResult varargCheckResult = this.checkVarargInSuperFunctions(originalParam);
            KotlinType altType = varargCheckResult.parameterType;
            if (shouldBeExtension && originalIndex == 0) {
                resultReceiverType = altType;
                continue;
            }
            Name stableName = null;
            for (int i = 0; i < this.superFunctions.size(); ++i) {
                if (!this.superFunctions.get(i).hasStableParameterNames()) continue;
                stableName = typesFromSuperMethods.get((int)i).name;
                break;
            }
            resultParameters.add(new ValueParameterDescriptorImpl(originalParam.getContainingDeclaration(), null, shouldBeExtension ? originalIndex - 1 : originalIndex, originalParam.getAnnotations(), stableName != null ? stableName : originalParam.getName(), altType, originalParam.declaresDefaultValue(), originalParam.isCrossinline(), originalParam.isNoinline(), varargCheckResult.isVararg ? DescriptorUtilsKt.getBuiltIns(originalParam).getArrayElementType(altType) : null, SourceElement.NO_SOURCE));
        }
        boolean hasStableParameterNames = CollectionsKt.any(this.superFunctions, CallableDescriptor::hasStableParameterNames);
        return new ValueParameters(resultReceiverType, resultParameters, hasStableParameterNames);
    }

    private static List<FunctionDescriptor> getSuperFunctionsForMethod(@NotNull JavaMethod method, @NotNull JavaMethodDescriptor autoMethodDescriptor, @NotNull ClassDescriptor containingClass) {
        if (method == null) {
            SignaturesPropagationData.$$$reportNull$$$0(11);
        }
        if (autoMethodDescriptor == null) {
            SignaturesPropagationData.$$$reportNull$$$0(12);
        }
        if (containingClass == null) {
            SignaturesPropagationData.$$$reportNull$$$0(13);
        }
        ArrayList<FunctionDescriptor> superFunctions = Lists.newArrayList();
        Name name = method.getName();
        Method autoSignature = null;
        boolean autoMethodContainsVararg = SignaturePropagationUtilKt.containsVarargs(autoMethodDescriptor);
        for (KotlinType supertype : containingClass.getTypeConstructor().getSupertypes()) {
            Collection<SimpleFunctionDescriptor> superFunctionCandidates = supertype.getMemberScope().getContributedFunctions(name, NoLookupLocation.WHEN_GET_SUPER_MEMBERS);
            if (!autoMethodContainsVararg && !SignaturePropagationUtilKt.containsAnyNotTrivialSignature(superFunctionCandidates)) continue;
            if (autoSignature == null) {
                autoSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(autoMethodDescriptor);
            }
            for (FunctionDescriptor functionDescriptor : superFunctionCandidates) {
                Method candidateSignature;
                if (functionDescriptor.isSuspend() || !KotlinToJvmSignatureMapperKt.erasedSignaturesEqualIgnoringReturnTypes(autoSignature, candidateSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(functionDescriptor))) continue;
                superFunctions.add(functionDescriptor);
            }
        }
        superFunctions.sort(Comparator.comparing(fun -> DescriptorUtils.getFqName(fun.getContainingDeclaration()).asString()));
        return superFunctions;
    }

    private boolean checkIfShouldBeExtension() {
        boolean someSupersExtension = false;
        boolean someSupersNotExtension = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            if (superFunction.getExtensionReceiverParameter() != null) {
                someSupersExtension = true;
                continue;
            }
            someSupersNotExtension = true;
        }
        if (someSupersExtension) {
            if (someSupersNotExtension) {
                this.reportError("Incompatible super methods: some are extension functions, some are not");
            } else {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private VarargCheckResult checkVarargInSuperFunctions(@NotNull ValueParameterDescriptor originalParam) {
        if (originalParam == null) {
            SignaturesPropagationData.$$$reportNull$$$0(14);
        }
        boolean someSupersVararg = false;
        boolean someSupersNotVararg = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            int index2;
            int originalIndex = originalParam.getIndex();
            int n = index2 = superFunction.getExtensionReceiverParameter() != null ? originalIndex - 1 : originalIndex;
            if (index2 != -1 && superFunction.getValueParameters().get(index2).getVarargElementType() != null) {
                someSupersVararg = true;
                continue;
            }
            someSupersNotVararg = true;
        }
        KotlinType originalVarargElementType = originalParam.getVarargElementType();
        KotlinType originalType = originalParam.getType();
        if (someSupersVararg && someSupersNotVararg) {
            this.reportError("Incompatible super methods: some have vararg parameter, some have not");
            VarargCheckResult varargCheckResult = new VarargCheckResult(originalType, originalVarargElementType != null);
            if (varargCheckResult == null) {
                SignaturesPropagationData.$$$reportNull$$$0(15);
            }
            return varargCheckResult;
        }
        if (someSupersVararg && originalVarargElementType == null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            VarargCheckResult varargCheckResult = new VarargCheckResult(TypeUtils.makeNotNullable(originalType), true);
            if (varargCheckResult == null) {
                SignaturesPropagationData.$$$reportNull$$$0(16);
            }
            return varargCheckResult;
        }
        if (someSupersNotVararg && originalVarargElementType != null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            VarargCheckResult varargCheckResult = new VarargCheckResult(TypeUtils.makeNullable(originalType), false);
            if (varargCheckResult == null) {
                SignaturesPropagationData.$$$reportNull$$$0(17);
            }
            return varargCheckResult;
        }
        VarargCheckResult varargCheckResult = new VarargCheckResult(originalType, originalVarargElementType != null);
        if (varargCheckResult == null) {
            SignaturesPropagationData.$$$reportNull$$$0(18);
        }
        return varargCheckResult;
    }

    private static boolean isArrayType(@NotNull KotlinType type2) {
        if (type2 == null) {
            SignaturesPropagationData.$$$reportNull$$$0(19);
        }
        return KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoReturnType";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoValueParameters";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoTypeParameters";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoMethodDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalParam";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAutoMethodDescriptor";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "checkVarargInSuperFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAutoMethodDescriptor";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modifyValueParametersAccordingToSuperMethods";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuperFunctionsForMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkVarargInSuperFunctions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isArrayType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ValueParameters {
        private final KotlinType receiverType;
        private final List<ValueParameterDescriptor> descriptors;
        private final boolean hasStableParameterNames;

        public ValueParameters(@Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> descriptors, boolean hasStableParameterNames) {
            if (descriptors == null) {
                ValueParameters.$$$reportNull$$$0(0);
            }
            this.receiverType = receiverType;
            this.descriptors = descriptors;
            this.hasStableParameterNames = hasStableParameterNames;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$ValueParameters", "<init>"));
        }
    }

    private static class TypeAndName {
        public final KotlinType type;
        public final Name name;

        public TypeAndName(KotlinType type2, Name name) {
            this.type = type2;
            this.name = name;
        }
    }

    private static class VarargCheckResult {
        public final KotlinType parameterType;
        public final boolean isVararg;

        public VarargCheckResult(KotlinType parameterType, boolean isVararg) {
            this.parameterType = parameterType;
            this.isVararg = isVararg;
        }
    }
}

