# From 4.0 to 4.1
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/4.0-to-4.1.md) for the most up to date instructions.*

## Important changes

- Resque replaced with Sidekiq
- New options for configuration file added
- Init.d script should be updated
- **requires ruby1.9.3-p327**

## 1. Stop GitLab & Resque

    sudo service gitlab stop

## 2. Update GitLab

```bash
# Set the working directory
cd /home/gitlab/gitlab/

# Get latest code
sudo -u gitlab -H git fetch
sudo -u gitlab -H git checkout 4-1-stable

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u gitlab -H vim Gemfile

# Install gems for MySQL
sudo -u gitlab -H bundle install --without development test postgres

# Migrate db
sudo -u gitlab -H bundle exec rake db:migrate RAILS_ENV=production

```

## 3. Replace init.d script with a new one

```
# backup old one
sudo mv /etc/init.d/gitlab /etc/init.d/gitlab.old

# get new one using sidekiq
sudo curl --location --output /etc/init.d/gitlab https://raw.github.com/gitlabhq/gitlab-recipes/4-1-stable/init.d/gitlab
sudo chmod +x /etc/init.d/gitlab

```

## 4. Check GitLab's status

    sudo -u gitlab -H bundle exec rake gitlab:check RAILS_ENV=production


## 5. Start GitLab & Sidekiq

    sudo service gitlab start

## 6. Remove old init.d script

    sudo rm /etc/init.d/gitlab.old
