/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.resource.TextResource;

public class CachingTextResource
implements TextResource {
    private final TextResource resource;
    private String content;

    public CachingTextResource(TextResource resource) {
        this.resource = resource;
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public ResourceLocation getLocation() {
        return this.resource.getLocation();
    }

    public File getFile() {
        return this.resource.getFile();
    }

    public Charset getCharset() {
        return this.resource.getCharset();
    }

    public boolean isContentCached() {
        return true;
    }

    public boolean getExists() {
        try {
            this.maybeFetch();
        }
        catch (MissingResourceException e) {
            return false;
        }
        return true;
    }

    public boolean getHasEmptyContent() {
        this.maybeFetch();
        return this.content.length() == 0;
    }

    public String getText() {
        this.maybeFetch();
        return this.content;
    }

    public Reader getAsReader() {
        this.maybeFetch();
        return new StringReader(this.content);
    }

    private void maybeFetch() {
        if (this.content == null) {
            this.content = this.resource.getText();
        }
    }
}

