/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import java.nio.charset.Charset;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.resources.FileCollectionBackedArchiveTextResource;
import org.gradle.api.internal.resources.FileCollectionBackedTextResource;
import org.gradle.api.internal.resources.StringBackedTextResource;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;

public class DefaultTextResourceFactory
implements TextResourceFactory {
    private final FileOperations fileOperations;
    private final TemporaryFileProvider tempFileProvider;

    public DefaultTextResourceFactory(FileOperations fileOperations, TemporaryFileProvider tempFileProvider) {
        this.fileOperations = fileOperations;
        this.tempFileProvider = tempFileProvider;
    }

    public TextResource fromString(String string) {
        return new StringBackedTextResource(this.tempFileProvider, string);
    }

    public TextResource fromFile(Object file, String charset) {
        return new FileCollectionBackedTextResource(this.tempFileProvider, (FileCollection)this.fileOperations.files(file), Charset.forName(charset));
    }

    public TextResource fromFile(Object file) {
        return this.fromFile(file, Charset.defaultCharset().name());
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath, String charset) {
        return new FileCollectionBackedArchiveTextResource(this.fileOperations, this.tempFileProvider, (FileCollection)this.fileOperations.files(archive), entryPath, Charset.forName(charset));
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath) {
        return this.fromArchiveEntry(archive, entryPath, Charset.defaultCharset().name());
    }
}

