/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Describable;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.CompositeTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.DefaultCacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskOutputCachingState;
import org.gradle.api.internal.tasks.NonCacheableTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputPropertySpecAndBuilder;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private static final TaskOutputCachingState ENABLED = DefaultTaskOutputCachingState.enabled();
    public static final TaskOutputCachingState DISABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.BUILD_CACHE_DISABLED, "Task output caching is disabled");
    private static final TaskOutputCachingState CACHING_NOT_ENABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NOT_ENABLED_FOR_TASK, "Caching has not been enabled for the task");
    private static final TaskOutputCachingState NO_OUTPUTS_DECLARED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NO_OUTPUTS_DECLARED, "No outputs declared");
    private final FileCollection allOutputFiles;
    private AndSpec<TaskInternal> upToDateSpec = AndSpec.empty();
    private List<SelfDescribingSpec<TaskInternal>> cacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private List<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private TaskExecutionHistory history;
    private final List<TaskOutputPropertySpecAndBuilder> filePropertiesInternal = Lists.newArrayList();
    private ImmutableSortedSet<TaskOutputFilePropertySpec> fileProperties;
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;

    public DefaultTaskOutputs(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
        this.allOutputFiles = new TaskOutputUnionFileCollection(task);
    }

    @Override
    public Spec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    public void upToDateWhen(final Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(upToDateClosure);
            }
        });
    }

    public void upToDateWhen(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(new Spec[]{spec});
            }
        });
    }

    @Override
    public TaskOutputCachingState getCachingState() {
        if (this.cacheIfSpecs.isEmpty()) {
            return CACHING_NOT_ENABLED;
        }
        if (!this.hasDeclaredOutputs()) {
            return NO_OUTPUTS_DECLARED;
        }
        OverlappingOutputs overlappingOutputs = this.getOverlappingOutputs();
        if (overlappingOutputs != null) {
            String relativePath = this.task.getProject().relativePath((Object)overlappingOutputs.getOverlappedFilePath());
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.OVERLAPPING_OUTPUTS, String.format("Gradle does not know how file '%s' was created (output property '%s'). Task output caching requires exclusive access to output paths to guarantee correctness.", relativePath, overlappingOutputs.getPropertyName()));
        }
        for (TaskPropertySpec spec : this.getFileProperties()) {
            if (!(spec instanceof NonCacheableTaskOutputPropertySpec)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.PLURAL_OUTPUTS, "Declares multiple output files for the single output property '" + spec.getPropertyName() + "' via `@OutputFiles`, `@OutputDirectories` or `TaskOutputs.files()`");
        }
        for (SelfDescribingSpec<TaskInternal> selfDescribingSpec : this.cacheIfSpecs) {
            if (selfDescribingSpec.isSatisfiedBy(this.task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.CACHE_IF_SPEC_NOT_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' not satisfied");
        }
        for (SelfDescribingSpec<TaskInternal> selfDescribingSpec : this.doNotCacheIfSpecs) {
            if (!selfDescribingSpec.isSatisfiedBy(this.task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.DO_NOT_CACHE_IF_SPEC_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' satisfied");
        }
        return ENABLED;
    }

    private OverlappingOutputs getOverlappingOutputs() {
        return this.history != null ? this.history.getOverlappingOutputs() : null;
    }

    public void cacheIf(Spec<? super Task> spec) {
        this.cacheIf("Task outputs cacheable", spec);
    }

    public void cacheIf(final String cachingEnabledReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.cacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.cacheIfSpecs.add(new SelfDescribingSpec(spec, cachingEnabledReason));
            }
        });
    }

    public void doNotCacheIf(final String cachingDisabledReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.doNotCacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.doNotCacheIfSpecs.add(new SelfDescribingSpec(spec, cachingDisabledReason));
            }
        });
    }

    public boolean getHasOutput() {
        return this.hasDeclaredOutputs() || !this.upToDateSpec.isEmpty();
    }

    @Override
    public boolean hasDeclaredOutputs() {
        return !this.filePropertiesInternal.isEmpty();
    }

    public FileCollection getFiles() {
        return this.allOutputFiles;
    }

    @Override
    public ImmutableSortedSet<TaskOutputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            TaskPropertyUtils.ensurePropertiesHaveNames(this.filePropertiesInternal);
            Iterator flattenedProperties = Iterators.concat(Iterables.transform(this.filePropertiesInternal, (Function)new Function<TaskPropertySpec, Iterator<? extends TaskOutputFilePropertySpec>>(){

                public Iterator<? extends TaskOutputFilePropertySpec> apply(TaskPropertySpec propertySpec) {
                    if (propertySpec instanceof CompositeTaskOutputPropertySpec) {
                        return ((CompositeTaskOutputPropertySpec)propertySpec).resolveToOutputProperties();
                    }
                    return Iterators.singletonIterator((Object)((TaskOutputFilePropertySpec)propertySpec));
                }
            }).iterator());
            this.fileProperties = TaskPropertyUtils.collectFileProperties("output", flattenedProperties);
        }
        return this.fileProperties;
    }

    public TaskOutputFilePropertyBuilder file(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.file(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new DefaultCacheableTaskOutputFilePropertySpec(DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.FILE, path));
            }
        });
    }

    public TaskOutputFilePropertyBuilder dir(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.dir(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new DefaultCacheableTaskOutputFilePropertySpec(DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY, path));
            }
        });
    }

    public TaskOutputFilePropertyBuilder files(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.files(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new CompositeTaskOutputPropertySpec(DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.FILE, paths));
            }
        });
    }

    public TaskOutputFilePropertyBuilder dirs(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.dirs(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new CompositeTaskOutputPropertySpec(DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY, paths));
            }
        });
    }

    private TaskOutputFilePropertyBuilder addSpec(TaskOutputPropertySpecAndBuilder spec) {
        this.filePropertiesInternal.add(spec);
        return spec;
    }

    @Override
    public Set<File> getPreviousOutputFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(TaskExecutionHistory history) {
        this.history = history;
    }

    private class TaskOutputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final TaskInternal buildDependencies;

        public TaskOutputUnionFileCollection(TaskInternal buildDependencies) {
            this.buildDependencies = buildDependencies;
        }

        public String getDisplayName() {
            return "task '" + DefaultTaskOutputs.this.task.getName() + "' output files";
        }

        public void visitContents(FileCollectionResolveContext context) {
            for (TaskFilePropertySpec propertySpec : DefaultTaskOutputs.this.getFileProperties()) {
                context.add(propertySpec.getPropertyFiles());
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.buildDependencies);
            super.visitDependencies(context);
        }
    }
}

