/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scan.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.BuildAdapter;
import org.gradle.StartParameter;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.scan.config.BuildScanConfig;
import org.gradle.internal.scan.config.BuildScanConfigInit;
import org.gradle.internal.scan.config.BuildScanConfigProvider;
import org.gradle.internal.scan.config.BuildScanPluginApplied;
import org.gradle.internal.scan.config.BuildScanPluginCompatibilityEnforcer;
import org.gradle.internal.scan.config.BuildScanPluginMetadata;

class BuildScanConfigManager
implements BuildScanConfigInit,
BuildScanConfigProvider,
BuildScanPluginApplied {
    private static final Logger LOGGER = Logging.getLogger(BuildScanConfigManager.class);
    private static final String HELP_LINK = "https://gradle.com/scans/help/gradle-cli";
    private static final String SYSPROP_KEY = "scan";
    private static final List<String> ENABLED_SYS_PROP_VALUES = Arrays.asList(null, "", "yes", "true");
    private final StartParameter startParameter;
    private final ListenerManager listenerManager;
    private final BuildScanPluginCompatibilityEnforcer compatibilityEnforcer;
    private State state = State.DEFAULTED;
    private boolean collected;

    BuildScanConfigManager(StartParameter startParameter, ListenerManager listenerManager, BuildScanPluginCompatibilityEnforcer compatibilityEnforcer) {
        this.startParameter = startParameter;
        this.listenerManager = listenerManager;
        this.compatibilityEnforcer = compatibilityEnforcer;
    }

    public void init() {
        boolean checkForPlugin = false;
        if (this.startParameter.isBuildScan()) {
            checkForPlugin = true;
            this.state = State.ENABLED;
        } else if (this.startParameter.isNoBuildScan()) {
            this.state = State.DISABLED;
        } else {
            Map sysProps = this.startParameter.getSystemPropertiesArgs();
            if (sysProps.containsKey(SYSPROP_KEY)) {
                String sysProp = (String)sysProps.get(SYSPROP_KEY);
                checkForPlugin = ENABLED_SYS_PROP_VALUES.contains(sysProp);
            }
        }
        if (checkForPlugin) {
            this.warnIfBuildScanPluginNotApplied();
        }
    }

    private void warnIfBuildScanPluginNotApplied() {
        this.listenerManager.addListener((Object)new BuildAdapter(){

            public void projectsEvaluated(Gradle gradle) {
                if (gradle.getParent() == null && !BuildScanConfigManager.this.collected) {
                    LOGGER.warn("Build scan cannot be created because the build scan plugin was not applied.\nFor more information on how to apply the build scan plugin, please visit https://gradle.com/scans/help/gradle-cli.");
                }
            }
        });
    }

    public BuildScanConfig collect(BuildScanPluginMetadata pluginMetadata) {
        if (this.collected) {
            throw new IllegalStateException("Configuration has already been collected.");
        }
        this.collected = true;
        this.compatibilityEnforcer.assertSupported(pluginMetadata.getVersion());
        return this.state.configuration;
    }

    public boolean isBuildScanPluginApplied() {
        return this.collected;
    }

    private static class Config
    implements BuildScanConfig {
        private final boolean enabled;
        private final boolean disabled;

        private Config(boolean enabled, boolean disabled) {
            this.enabled = enabled;
            this.disabled = disabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return this.disabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        DEFAULTED(new Config(false, false)),
        ENABLED(new Config(true, false)),
        DISABLED(new Config(false, true));

        private final BuildScanConfig configuration;

        private State(BuildScanConfig configuration) {
            this.configuration = configuration;
        }
    }
}

