/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.platform.base.Platform;

@Incubating
public class CppBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryVar buildDirectory = project.getLayout().getBuildDirectory();
        final ModelRegistry modelRegistry = project.getModelRegistry();
        final ProviderFactory providers = project.getProviders();
        project.getComponents().withType(CppBinary.class, (Action)new Action<CppBinary>(){

            public void execute(final CppBinary binary) {
                final Names names = Names.of(binary.getName());
                CppCompile compile = (CppCompile)tasks.create(names.getCompileTaskName("cpp"), CppCompile.class);
                compile.includes(binary.getCompileIncludePath());
                compile.source(binary.getCppSource());
                compile.setCompilerArgs(Collections.emptyList());
                compile.setMacros(Collections.emptyMap());
                compile.setObjectFileDir((Provider<? extends Directory>)buildDirectory.dir("obj/" + names.getDirName()));
                DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
                compile.setTargetPlatform((NativePlatform)currentPlatform);
                NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
                compile.setToolChain(toolChain);
                if (binary instanceof CppExecutable) {
                    LinkExecutable link = (LinkExecutable)tasks.create(names.getTaskName("link"), LinkExecutable.class);
                    link.source((Object)compile.getObjectFileDirectory().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
                    link.lib((Object)binary.getLinkLibraries());
                    link.setLinkerArgs(Collections.emptyList());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    link.setOutputFile(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getBaseName().get());
                        }
                    })));
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                } else if (binary instanceof CppSharedLibrary) {
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    compile.setPositionIndependentCode(true);
                    LinkSharedLibrary link = (LinkSharedLibrary)tasks.create(names.getTaskName("link"), LinkSharedLibrary.class);
                    link.source((Object)compile.getObjectFileDirectory().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
                    link.lib((Object)binary.getLinkLibraries());
                    link.setLinkerArgs(Collections.emptyList());
                    Provider runtimeFile = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + (String)binary.getBaseName().get());
                        }
                    }));
                    link.setOutputFile(runtimeFile);
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                }
            }
        });
    }
}

