/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FrameNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerForMethod", "kotlin-compiler"})
public final class LabelNormalizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        new TransformerForMethod(methodNode).transform();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00172\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020#H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010%\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020#H\u0002J\u0006\u0010+\u001a\u00020#J\f\u0010,\u001a\u00020\u0017*\u00020\u0019H\u0002J\f\u0010,\u001a\u00020\u0017*\u00020\u001cH\u0002J\f\u0010,\u001a\u00020\u0017*\u00020!H\u0002J\f\u0010,\u001a\u00020\u0017*\u00020&H\u0002J\f\u0010,\u001a\u00020\u0017*\u00020)H\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR-\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer$TransformerForMethod;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "getInstructions", "()Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "newLabelNodes", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/Label;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lkotlin/collections/HashMap;", "getNewLabelNodes", "()Ljava/util/HashMap;", "getNew", "oldLabelNode", "getNewOrOld", "rewriteFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "oldFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/FrameNode;", "rewriteJumpInsn", "oldJumpNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "rewriteLabelInstructions", "", "rewriteLineNumberNode", "oldLineNode", "Lorg/jetbrains/org/objectweb/asm/tree/LineNumberNode;", "rewriteLocalVars", "", "rewriteLookupSwitchInsn", "oldSwitchNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "rewriteNonLabelInstructions", "rewriteTableSwitchInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "rewriteTryCatchBlocks", "transform", "rewriteLabels", "kotlin-compiler"})
    private static final class TransformerForMethod {
        private final InsnList instructions;
        @NotNull
        private final HashMap<Label, LabelNode> newLabelNodes;
        @NotNull
        private final MethodNode methodNode;

        public final InsnList getInstructions() {
            return this.instructions;
        }

        @NotNull
        public final HashMap<Label, LabelNode> getNewLabelNodes() {
            return this.newLabelNodes;
        }

        public final void transform() {
            if (this.rewriteLabelInstructions()) {
                this.rewriteNonLabelInstructions();
                this.rewriteTryCatchBlocks();
                this.rewriteLocalVars();
                UtilKt.removeEmptyCatchBlocks(this.methodNode);
            }
        }

        private final boolean rewriteLabelInstructions() {
            boolean removedAnyLabels = false;
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                if (thisNode instanceof LabelNode) {
                    Label label;
                    AbstractInsnNode abstractInsnNode;
                    Map map2;
                    AbstractInsnNode prevNode = ((LabelNode)thisNode).getPrevious();
                    if (prevNode instanceof LabelNode) {
                        map2 = this.newLabelNodes;
                        Intrinsics.checkExpressionValueIsNotNull(((LabelNode)thisNode).getLabel(), "thisNode.label");
                        abstractInsnNode = prevNode;
                        map2.put(label, abstractInsnNode);
                        removedAnyLabels = true;
                        thisNode = LabelNormalizationMethodTransformerKt.removeNodeGetNext(this.instructions, thisNode);
                        continue;
                    }
                    map2 = this.newLabelNodes;
                    Intrinsics.checkExpressionValueIsNotNull(((LabelNode)thisNode).getLabel(), "thisNode.label");
                    abstractInsnNode = thisNode;
                    map2.put(label, abstractInsnNode);
                    thisNode = ((LabelNode)thisNode).getNext();
                    continue;
                }
                thisNode = thisNode.getNext();
            }
            return removedAnyLabels;
        }

        private final void rewriteNonLabelInstructions() {
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                AbstractInsnNode abstractInsnNode = thisNode;
                thisNode = abstractInsnNode instanceof JumpInsnNode ? this.rewriteJumpInsn((JumpInsnNode)thisNode) : (abstractInsnNode instanceof LineNumberNode ? this.rewriteLineNumberNode((LineNumberNode)thisNode) : (abstractInsnNode instanceof LookupSwitchInsnNode ? this.rewriteLookupSwitchInsn((LookupSwitchInsnNode)thisNode) : (abstractInsnNode instanceof TableSwitchInsnNode ? this.rewriteTableSwitchInsn((TableSwitchInsnNode)thisNode) : (abstractInsnNode instanceof FrameNode ? this.rewriteFrameNode((FrameNode)thisNode) : thisNode.getNext()))));
            }
        }

        private final AbstractInsnNode rewriteLineNumberNode(LineNumberNode oldLineNode) {
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(this.instructions, oldLineNode, this.rewriteLabels(oldLineNode));
        }

        private final AbstractInsnNode rewriteJumpInsn(JumpInsnNode oldJumpNode) {
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(this.instructions, oldJumpNode, this.rewriteLabels(oldJumpNode));
        }

        private final AbstractInsnNode rewriteLookupSwitchInsn(LookupSwitchInsnNode oldSwitchNode) {
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(this.instructions, oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteTableSwitchInsn(TableSwitchInsnNode oldSwitchNode) {
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(this.instructions, oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteFrameNode(FrameNode oldFrameNode) {
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(this.instructions, oldFrameNode, this.rewriteLabels(oldFrameNode));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteTryCatchBlocks() {
            Collection<TryCatchBlockNode> collection;
            void $receiver$iv$iv;
            Iterable $receiver$iv = this.methodNode.tryCatchBlocks;
            MethodNode methodNode = this.methodNode;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void oldTcb;
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
                collection = destination$iv$iv;
                LabelNode labelNode = oldTcb.start;
                Intrinsics.checkExpressionValueIsNotNull(labelNode, "oldTcb.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldTcb.end;
                Intrinsics.checkExpressionValueIsNotNull(labelNode3, "oldTcb.end");
                LabelNode labelNode4 = this.getNew(labelNode3);
                LabelNode labelNode5 = oldTcb.handler;
                Intrinsics.checkExpressionValueIsNotNull(labelNode5, "oldTcb.handler");
                TryCatchBlockNode newTcb = new TryCatchBlockNode(labelNode2, labelNode4, this.getNew(labelNode5), oldTcb.type);
                newTcb.visibleTypeAnnotations = oldTcb.visibleTypeAnnotations;
                newTcb.invisibleTypeAnnotations = oldTcb.invisibleTypeAnnotations;
                TryCatchBlockNode tryCatchBlockNode2 = newTcb;
                collection.add(tryCatchBlockNode2);
            }
            collection = (List)destination$iv$iv;
            methodNode.tryCatchBlocks = collection;
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteLocalVars() {
            Collection<LocalVariableNode> collection;
            void $receiver$iv$iv;
            Iterable $receiver$iv = this.methodNode.localVariables;
            MethodNode methodNode = this.methodNode;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void oldVar;
                LocalVariableNode localVariableNode = (LocalVariableNode)item$iv$iv;
                collection = destination$iv$iv;
                String string = oldVar.name;
                String string2 = oldVar.desc;
                String string3 = oldVar.signature;
                LabelNode labelNode = oldVar.start;
                Intrinsics.checkExpressionValueIsNotNull(labelNode, "oldVar.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldVar.end;
                Intrinsics.checkExpressionValueIsNotNull(labelNode3, "oldVar.end");
                LocalVariableNode localVariableNode2 = new LocalVariableNode(string, string2, string3, labelNode2, this.getNew(labelNode3), oldVar.index);
                collection.add(localVariableNode2);
            }
            collection = (List)destination$iv$iv;
            methodNode.localVariables = collection;
        }

        private final AbstractInsnNode rewriteLabels(@NotNull LineNumberNode $receiver) {
            int n = $receiver.line;
            LabelNode labelNode = $receiver.start;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "start");
            return new LineNumberNode(n, this.getNewOrOld(labelNode));
        }

        private final AbstractInsnNode rewriteLabels(@NotNull JumpInsnNode $receiver) {
            int n = $receiver.getOpcode();
            LabelNode labelNode = $receiver.label;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "label");
            return new JumpInsnNode(n, this.getNew(labelNode));
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(@NotNull LookupSwitchInsnNode $receiver) {
            void $receiver$iv$iv;
            void $receiver$iv;
            LookupSwitchInsnNode lookupSwitchInsnNode;
            LabelNode labelNode = $receiver.dflt;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "dflt");
            int[] nArray = CollectionsKt.toIntArray((Collection<Integer>)$receiver.keys);
            LabelNode labelNode2 = this.getNew(labelNode);
            Object object = lookupSwitchInsnNode;
            LookupSwitchInsnNode lookupSwitchInsnNode2 = lookupSwitchInsnNode;
            LabelNode[] labelNodeArray = new LabelNode[]{};
            ((LookupSwitchInsnNode)object)(labelNode2, nArray, labelNodeArray);
            LookupSwitchInsnNode switchNode = lookupSwitchInsnNode2;
            Iterable $i$f$emptyArray = $receiver.labels;
            lookupSwitchInsnNode2 = switchNode;
            void var9_9 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                LabelNode labelNode3 = (LabelNode)item$iv$iv;
                object = destination$iv$iv;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                labelNode2 = this.getNew((LabelNode)v2);
                object.add(labelNode2);
            }
            lookupSwitchInsnNode2.labels = object = (List)destination$iv$iv;
            return switchNode;
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(@NotNull TableSwitchInsnNode $receiver) {
            Collection<LabelNode> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            int n = $receiver.min;
            int n2 = $receiver.max;
            LabelNode labelNode = $receiver.dflt;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "dflt");
            TableSwitchInsnNode switchNode = new TableSwitchInsnNode(n, n2, this.getNew(labelNode), new LabelNode[0]);
            Iterable iterable = $receiver.labels;
            TableSwitchInsnNode tableSwitchInsnNode = switchNode;
            void var5_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                LabelNode labelNode2 = (LabelNode)item$iv$iv;
                collection = destination$iv$iv;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                LabelNode labelNode3 = this.getNew((LabelNode)v3);
                collection.add(labelNode3);
            }
            collection = (List)destination$iv$iv;
            tableSwitchInsnNode.labels = collection;
            return switchNode;
        }

        private final AbstractInsnNode rewriteLabels(@NotNull FrameNode $receiver) {
            Object it;
            Object item$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            FrameNode frameNode;
            int n = 0;
            int n2 = $receiver.type;
            Object object = frameNode;
            FrameNode frameNode2 = frameNode;
            Object[] objectArray = new Object[]{};
            int n3 = 0;
            Object[] objectArray2 = new Object[]{};
            ((FrameNode)object)(n2, n, objectArray, n3, objectArray2);
            FrameNode frameNode3 = frameNode2;
            Iterable $i$f$emptyArray = $receiver.local;
            frameNode2 = frameNode3;
            void var11_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = item$iv$iv = iterator2.next();
                object = destination$iv$iv;
                void var3_4 = it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it;
                object.add(var3_4);
            }
            frameNode2.local = object = (List)destination$iv$iv;
            $receiver$iv = $receiver.stack;
            frameNode2 = frameNode3;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                it = item$iv$iv = iterator2.next();
                object = destination$iv$iv;
                Object t = it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it;
                object.add(t);
            }
            frameNode2.stack = object = (List)destination$iv$iv;
            return frameNode3;
        }

        private final LabelNode getNew(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode.getLabel());
            if (labelNode == null) {
                Intrinsics.throwNpe();
            }
            return labelNode;
        }

        private final LabelNode getNewOrOld(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode.getLabel());
            if (labelNode == null) {
                labelNode = oldLabelNode;
            }
            return labelNode;
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public TransformerForMethod(@NotNull MethodNode methodNode) {
            Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
            this.methodNode = methodNode;
            this.instructions = this.methodNode.instructions;
            TransformerForMethod transformerForMethod = this;
            HashMap hashMap = new HashMap();
            transformerForMethod.newLabelNodes = hashMap;
        }
    }
}

