/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaParameterType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;
    private PsiType myT;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression2, @NotNull PsiType type2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        this.myExpression = expression2;
        this.myT = type2;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiExpression expression2;
        if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
            PsiType exprType = this.myExpression.getType();
            if (session.isProperType(this.myT)) {
                boolean assignmentCompatible;
                boolean bl = assignmentCompatible = exprType == null || TypeConversionUtil.isAssignable(this.myT, exprType);
                if (!assignmentCompatible) {
                    PsiType type2 = this.myExpression.getType();
                    session.registerIncompatibleErrorMessage((type2 != null ? type2.getPresentableText() : this.myExpression.getText()) + " is not compatible with " + session.getPresentableText(this.myT));
                } else if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, exprType) && !JavaGenericsUtil.isReifiableType(this.myT)) {
                    session.setErasedDuringApplicabilityCheck();
                }
                return assignmentCompatible;
            }
            if (exprType instanceof PsiLambdaParameterType) {
                return false;
            }
            if (exprType instanceof PsiClassType && ((PsiClassType)exprType).resolve() == null) {
                return true;
            }
            if (exprType != null && exprType != PsiType.NULL) {
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                constraints.add(new TypeCompatibilityConstraint(this.myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression2 = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null) {
            constraints.add(new ExpressionCompatibilityConstraint(expression2, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression != null) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression, this.myT));
            }
            if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression, this.myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiCall) {
            InferenceSession callSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, this.myExpression, this.myT, true);
            if (callSession == null) {
                return false;
            }
            if (callSession != session) {
                session.getInferenceSessionContainer().registerNestedSession(callSession);
                session.propagateVariables(callSession.getInferenceVariables(), callSession.getRestoreNameSubstitution());
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, this.myT));
            return true;
        }
        return true;
    }

    public static InferenceSession reduceExpressionCompatibilityConstraint(InferenceSession session, PsiExpression expression2, PsiType targetType, boolean registerErrorOnFailure) {
        PsiExpressionList argumentList2 = ((PsiCall)((Object)expression2)).getArgumentList();
        if (argumentList2 != null) {
            MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(argumentList2);
            PsiType returnType = null;
            PsiTypeParameter[] typeParams = null;
            JavaResolveResult resolveResult = candidateProperties != null ? null : InferenceSession.getResolveResult((PsiCall)((Object)expression2));
            PsiMethod method = InferenceSession.getCalledMethod((PsiCall)((Object)expression2));
            if (method != null && !method.isConstructor()) {
                returnType = method.getReturnType();
                typeParams = method.getTypeParameters();
            } else if (resolveResult != null) {
                PsiClass psiClass;
                PsiClass psiClass2 = psiClass = method != null ? method.getContainingClass() : (PsiClass)resolveResult.getElement();
                if (psiClass != null) {
                    returnType = JavaPsiFacade.getElementFactory(argumentList2.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
                    typeParams = psiClass.getTypeParameters();
                    if (method != null && method.hasTypeParameters()) {
                        typeParams = ArrayUtil.mergeArrays(typeParams, method.getTypeParameters());
                    }
                }
            } else {
                return session;
            }
            if (typeParams != null) {
                List<String> messages;
                PsiSubstitutor siteSubstitutor = InferenceSession.chooseSiteSubstitutor(candidateProperties, resolveResult, method);
                InferenceSession callSession = new InferenceSession(typeParams, siteSubstitutor, expression2.getManager(), expression2);
                callSession.propagateVariables(session.getInferenceVariables(), session.getRestoreNameSubstitution());
                if (method != null) {
                    PsiExpression[] args = argumentList2.getExpressions();
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    callSession.initExpressionConstraints(parameters2, args, expression2, method, InferenceSession.chooseVarargsMode(candidateProperties, resolveResult));
                }
                if (callSession.repeatInferencePhases()) {
                    if (PsiType.VOID.equals(targetType)) {
                        return callSession;
                    }
                    if (returnType != null) {
                        callSession.registerReturnTypeConstraints(siteSubstitutor.substitute(returnType), targetType);
                    }
                    if (callSession.repeatInferencePhases()) {
                        return callSession;
                    }
                }
                if ((messages = callSession.getIncompatibleErrorMessages()) != null) {
                    for (String message : messages) {
                        session.registerIncompatibleErrorMessage(message);
                    }
                }
                return null;
            }
            if (registerErrorOnFailure) {
                session.registerIncompatibleErrorMessage("Failed to resolve argument");
                return null;
            }
        }
        return session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        return this.myExpression.equals(that.myExpression);
    }

    public int hashCode() {
        return this.myExpression.hashCode();
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression2) {
        return new ExpressionCompatibilityConstraint(expression2, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<InferenceVariable> result2) {
        if (psiExpression instanceof PsiLambdaExpression && !PsiType.VOID.equals(returnType)) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)psiExpression);
            for (PsiExpression expression2 : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType, expression2).getInputVariables(session);
                if (resultInputVars == null) continue;
                result2.addAll(resultInputVars);
            }
        }
    }
}

