/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileWithId;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SubstrateRef;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class AstPath
extends SubstrateRef {
    private static final CompositeElement[] REMOVED_PATH_CHILDREN = new CompositeElement[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.AstPath");
    private static final Key<CompositeElement[]> PATH_CHILDREN = Key.create("PATH_CHILDREN");
    private static final Key<AstPath> NODE_PATH = Key.create("NODE_PATH");

    @Override
    @NotNull
    public abstract PsiFileImpl getContainingFile();

    @Override
    @NotNull
    public abstract CompositeElement getNode();

    @Override
    public boolean isValid() {
        return this.getContainingFile().isValid();
    }

    protected abstract int getDepth();

    @Override
    @Nullable
    public Stub getStub(int stubIndex) {
        if (stubIndex < 0) {
            return null;
        }
        StubTree stubTree = this.getFileStubTree();
        return stubTree == null ? null : (Stub)stubTree.getPlainList().get(stubIndex);
    }

    @Nullable
    protected abstract StubTree getFileStubTree();

    @Override
    @Nullable
    public Stub getGreenStub(int stubIndex) {
        if (stubIndex < 0) {
            return null;
        }
        StubTree stubTree = this.getContainingFile().getGreenStubTree();
        return stubTree == null ? null : (Stub)stubTree.getPlainList().get(stubIndex);
    }

    @Nullable
    public static AstPath getNodePath(@NotNull CompositeElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath", "getNodePath"));
        }
        if (node instanceof FileElement) {
            PsiElement psi = node.getCachedPsi();
            if (!(psi instanceof PsiFileImpl)) {
                return null;
            }
            PsiFileImpl file = (PsiFileImpl)psi;
            if (!(file.getVirtualFile() instanceof VirtualFileWithId) || file.getElementTypeForStubBuilder() == null) {
                return null;
            }
            return new RootPath(file);
        }
        return node.getUserData(NODE_PATH);
    }

    static void cacheNodePaths(final @NotNull LazyParseableElement parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath", "cacheNodePaths"));
        }
        final AstPath parentPath = AstPath.getNodePath(parent2);
        if (parentPath == null) {
            return;
        }
        final int depth = parentPath.getDepth() + 1;
        final ArrayList<CompositeElement> children = ContainerUtil.newArrayList();
        parent2.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite != parent2 && (composite instanceof LazyParseableElement || composite.getElementType() instanceof IStubElementType)) {
                    int index2 = children.size();
                    composite.putUserData(NODE_PATH, depth % 4 == 0 ? new MilestoneChildPath(parentPath, index2, depth) : new ChildPath(parentPath, index2));
                    children.add(composite);
                }
                super.visitComposite(composite);
            }
        });
        parent2.putUserData(PATH_CHILDREN, children.toArray(new CompositeElement[0]));
    }

    public static void invalidatePaths(@NotNull LazyParseableElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath", "invalidatePaths"));
        }
        CompositeElement[] children = scope.getUserData(PATH_CHILDREN);
        if (children == null) {
            return;
        }
        scope.putUserData(PATH_CHILDREN, REMOVED_PATH_CHILDREN);
        for (CompositeElement child : children) {
            child.putUserData(NODE_PATH, null);
            AstPath.assertConsistency(child.getCachedPsi());
            if (!(child instanceof LazyParseableElement)) continue;
            AstPath.invalidatePaths((LazyParseableElement)child);
        }
    }

    private static void assertConsistency(PsiElement cachedPsi) {
        if (cachedPsi instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)cachedPsi).getSubstrateRef() instanceof AstPath) {
            LOG.error("Expected strong reference at " + cachedPsi + " of " + cachedPsi.getClass() + " and " + ((StubBasedPsiElementBase)cachedPsi).getElementType());
        }
    }

    private static class RootPath
    extends AstPath {
        private final PsiFileImpl myFile;

        RootPath(@NotNull PsiFileImpl file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$RootPath", "<init>"));
            }
            this.myFile = file;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof RootPath && this.myFile.equals(((RootPath)o).myFile);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        @Override
        @NotNull
        public PsiFileImpl getContainingFile() {
            PsiFileImpl psiFileImpl = this.myFile;
            if (psiFileImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$RootPath", "getContainingFile"));
            }
            return psiFileImpl;
        }

        @Override
        @NotNull
        public CompositeElement getNode() {
            FileElement fileElement = this.myFile.calcTreeElement();
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$RootPath", "getNode"));
            }
            return fileElement;
        }

        @Override
        protected int getDepth() {
            return 0;
        }

        @Override
        protected StubTree getFileStubTree() {
            return this.myFile.getStubTree();
        }
    }

    private static class MilestoneChildPath
    extends ChildPath {
        private final int myDepth;
        private final PsiFileImpl myFile;
        private volatile WeakReference<CompositeElement> myNode;

        MilestoneChildPath(@NotNull AstPath parent2, int index2, int depth) {
            if (parent2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$MilestoneChildPath", "<init>"));
            }
            super(parent2, index2);
            this.myDepth = depth;
            this.myFile = parent2.getContainingFile();
        }

        @Override
        @NotNull
        public CompositeElement getNode() {
            CompositeElement node = SoftReference.dereference(this.myNode);
            if (node == null) {
                node = super.getNode();
                if (this.myFile.mayCacheAst()) {
                    this.myNode = new WeakReference<CompositeElement>(node);
                }
            }
            CompositeElement compositeElement = node;
            if (compositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$MilestoneChildPath", "getNode"));
            }
            return compositeElement;
        }

        @Override
        protected StubTree getFileStubTree() {
            return SoftReference.dereference(this.myNode) == null ? this.myFile.getStubTree() : null;
        }

        @Override
        @NotNull
        public PsiFileImpl getContainingFile() {
            PsiFileImpl psiFileImpl = this.myFile;
            if (psiFileImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$MilestoneChildPath", "getContainingFile"));
            }
            return psiFileImpl;
        }

        @Override
        protected int getDepth() {
            return this.myDepth;
        }
    }

    private static class ChildPath
    extends AstPath {
        private final AstPath myParent;
        private final int myIndex;

        ChildPath(@NotNull AstPath parent2, int index2) {
            if (parent2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$ChildPath", "<init>"));
            }
            this.myParent = parent2;
            this.myIndex = index2;
        }

        @Override
        @NotNull
        public PsiFileImpl getContainingFile() {
            PsiFileImpl psiFileImpl = this.myParent.getContainingFile();
            if (psiFileImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$ChildPath", "getContainingFile"));
            }
            return psiFileImpl;
        }

        @Override
        @NotNull
        public CompositeElement getNode() {
            boolean removed2;
            CompositeElement parentNode = this.myParent.getNode();
            parentNode.getFirstChildNode();
            CompositeElement[] children = (CompositeElement[])parentNode.getUserData(PATH_CHILDREN);
            boolean bl = removed2 = children == REMOVED_PATH_CHILDREN;
            if (children == null || removed2) {
                throw this.reportMissingChildren(parentNode, removed2);
            }
            if (this.myIndex >= children.length) {
                throw new AssertionError((Object)(this.myIndex + " >= " + children.length + "; " + parentNode + " of " + parentNode.getClass()));
            }
            CompositeElement compositeElement = children[this.myIndex];
            if (compositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/AstPath$ChildPath", "getNode"));
            }
            return compositeElement;
        }

        private AssertionError reportMissingChildren(CompositeElement parentNode, boolean removed2) {
            String message = "No path children in " + parentNode + " of " + parentNode.getClass() + "; removed=" + removed2;
            PsiFileImpl file = this.getContainingFile();
            message = message + "\n  file: " + file + " of " + file.getClass() + "; physical=" + file.isPhysical() + "; useStrongRefs=" + file.useStrongRefs();
            FileElement fileElement = file.getTreeElement();
            message = message + "\n  ast=" + fileElement;
            if (fileElement != null) {
                CompositeElement[] rootChildren = (CompositeElement[])fileElement.getUserData(PATH_CHILDREN);
                message = message + "; root.children=" + (rootChildren == REMOVED_PATH_CHILDREN ? "removed" : (rootChildren == null ? "null" : "nonNull"));
            }
            return new AssertionError((Object)message);
        }

        @Override
        protected int getDepth() {
            return 1 + this.myParent.getDepth();
        }

        @Override
        protected StubTree getFileStubTree() {
            return this.myParent.getFileStubTree();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ChildPath)) {
                return false;
            }
            ChildPath path = (ChildPath)o;
            return this.myIndex == path.myIndex && this.myParent.equals(path.myParent);
        }

        public int hashCode() {
            return 31 * this.myParent.hashCode() + this.myIndex;
        }
    }
}

