/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.SyntaxTraverser;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.gnu.trove.TObjectIntHashMap;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className2) {
        if (className2 != null) {
            int i = className2.lastIndexOf(46);
            return i == -1 ? "" : className2.substring(0, i);
        }
        return null;
    }

    @NotNull
    public static String extractClassName(@NotNull String fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "extractClassName"));
        }
        int i = fqName2.lastIndexOf(46);
        String string = i == -1 ? fqName2 : fqName2.substring(i + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "extractClassName"));
        }
        return string;
    }

    public static String createNewClassQualifiedName(String qualifiedName2, String className2) {
        if (className2 == null) {
            return null;
        }
        if (qualifiedName2 == null || qualifiedName2.isEmpty()) {
            return className2;
        }
        return qualifiedName2 + "." + ClassUtil.extractClassName(className2);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass2, @NotNull StringBuilder buf) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "formatClassName"));
        }
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "formatClassName"));
        }
        String qName = aClass2.getQualifiedName();
        if (qName != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = PsiTreeUtil.getContextOfType((PsiElement)aClass2, PsiClass.class, true);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass2, parentClass));
                String name = aClass2.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, @NotNull PsiClass containingClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "getNonQualifiedClassIdx"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "getNonQualifiedClassIdx"));
        }
        TObjectIntHashMap indices = (TObjectIntHashMap)CachedValuesManager.getCachedValue(containingClass, () -> {
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "lambda$getNonQualifiedClassIdx$0"));
            }
            TObjectIntHashMap<PsiClass> map2 = new TObjectIntHashMap<PsiClass>();
            int index2 = 0;
            for (PsiClass aClass2 : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                if (aClass2.getQualifiedName() != null) continue;
                map2.put(aClass2, ++index2);
            }
            return CachedValueProvider.Result.create(map2, containingClass);
        });
        return indices.get(psiClass);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, @NotNull PsiClass containingClass) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        String prefix = ClassUtil.getDigitPrefix(indexName);
        final int idx = !prefix.isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result2 = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx;

            @Override
            public void visitElement(PsiElement element) {
                if (result2[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass2) {
                if (!jvmCompatible) {
                    super.visitClass(aClass2);
                    if (aClass2.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual(name, aClass2.getName())) {
                            result2[0] = aClass2;
                        }
                    }
                    return;
                }
                if (aClass2 == containingClass) {
                    super.visitClass(aClass2);
                    return;
                }
                if (Comparing.strEqual(name, aClass2.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result2[0] = aClass2;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result2[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i;
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "getDigitPrefix"));
        }
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        String string = i == 0 ? "" : indexName.substring(0, i);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "getDigitPrefix"));
        }
        return string;
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        return ClassUtil.findPsiClass(manager, name, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent2, boolean jvmCompatible) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope(manager.getProject());
        return ClassUtil.findPsiClass(manager, name, parent2, jvmCompatible, scope);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent2, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (parent2 != null) {
            return ClassUtil.findSubClass(name, parent2, jvmCompatible);
        }
        PsiClass result2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(name, scope);
        if (result2 != null) {
            return result2;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            parent2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(prefix, scope);
            if (parent2 == null || (result2 = ClassUtil.findSubClass(suffix = name.substring(p + 1), parent2, jvmCompatible)) == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSubClass(@NotNull String name, @NotNull PsiClass parent2, boolean jvmCompatible) {
        PsiClass result2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findSubClass"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findSubClass"));
        }
        PsiClass psiClass = result2 = ClassUtil.isIndexed(name) ? ClassUtil.findNonQualifiedClassByIndex(name, parent2, jvmCompatible) : parent2.findInnerClassByName(name, false);
        if (result2 != null) {
            return result2;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            PsiClass subClass = ClassUtil.isIndexed(prefix) ? ClassUtil.findNonQualifiedClassByIndex(prefix, parent2, jvmCompatible) : parent2.findInnerClassByName(prefix, false);
            if (subClass == null || (result2 = ClassUtil.findSubClass(suffix = name.substring(p + 1), subClass, jvmCompatible)) == null) continue;
            return result2;
        }
        return null;
    }

    private static boolean isIndexed(String name) {
        return Character.isDigit(name.charAt(0));
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "getJVMClassName"));
        }
        PsiClass containingClass = aClass2.getContainingClass();
        if (containingClass != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass2.getName();
        }
        return aClass2.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClassByJVMName"));
        }
        if (jvmClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmClassName", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "findPsiClassByJVMName"));
        }
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }

    public static boolean isTopLevelClass(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/ClassUtil", "isTopLevelClass"));
        }
        if (aClass2.getContainingClass() != null) {
            return false;
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return false;
        }
        PsiElement parent2 = aClass2.getParent();
        if (parent2 instanceof PsiDeclarationStatement && parent2.getParent() instanceof PsiCodeBlock) {
            return false;
        }
        PsiFile parentFile = aClass2.getContainingFile();
        return parentFile != null && parentFile.getLanguage() == JavaLanguage.INSTANCE;
    }
}

