/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js.ast;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithEmbeddedSource;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;
import org.jetbrains.kotlin.serialization.js.ast.JsAstDeserializer$WhenMappings;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u001aH\u0002J\u0010\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u001cH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u001dH\u0002J\u0010\u0010\u0013\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u001cH\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010.\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010.\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010.\u001a\u0002082\u0006\u00100\u001a\u000209H\u0002J9\u0010:\u001a\u0002H;\"\b\b\u0000\u0010;*\u00020<2\b\u0010=\u001a\u0004\u0018\u00010%2\b\u0010>\u001a\u0004\u0018\u00010?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H;0AH\u0002\u00a2\u0006\u0002\u0010BR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/serialization/js/ast/JsAstDeserializer;", "", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "sourceRoots", "", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;Ljava/lang/Iterable;)V", "fileStack", "Ljava/util/Deque;", "", "nameCache", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "nameTable", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Name;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;", "stringTable", "deserialize", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "input", "Ljava/io/InputStream;", "proto", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Chunk;", "Lorg/jetbrains/kotlin/js/backend/ast/JsClassModel;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$ClassModel;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Expression;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Fragment;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Statement;", "deserializeGlobalBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$GlobalBlock;", "deserializeName", "id", "", "deserializeNoMetadata", "deserializeParameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Parameter;", "deserializeString", "deserializeVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Vars;", "map", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "op", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$BinaryOperation$Type;", "Lorg/jetbrains/kotlin/resolve/inline/InlineStrategy;", "inlineStrategy", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$InlineStrategy;", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SideEffectKind;", "sideEffects", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SideEffects;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation$Type;", "withLocation", "T", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "fileId", "location", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Location;", "action", "Lkotlin/Function0;", "(Ljava/lang/Integer;Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Location;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "kotlin-compiler"})
public final class JsAstDeserializer {
    private final JsRootScope scope;
    private final List<String> stringTable;
    private final List<JsAstProtoBuf.Name> nameTable;
    private final List<JsName> nameCache;
    private final Deque<String> fileStack;
    private final Iterable<File> sourceRoots;

    @NotNull
    public final JsProgramFragment deserialize(@NotNull InputStream input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        CodedInputStream codedInputStream = CodedInputStream.newInstance(input);
        JsAstDeserializer jsAstDeserializer = this;
        CodedInputStream $receiver = codedInputStream;
        $receiver.setRecursionLimit(4096);
        CodedInputStream codedInputStream2 = codedInputStream;
        JsAstProtoBuf.Chunk chunk = JsAstProtoBuf.Chunk.parseFrom(codedInputStream2);
        Intrinsics.checkExpressionValueIsNotNull(chunk, "Chunk.parseFrom(CodedInp\u2026etRecursionLimit(4096) })");
        return jsAstDeserializer.deserialize(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final JsProgramFragment deserialize(@NotNull JsAstProtoBuf.Chunk proto) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Object object = this.stringTable;
        ProtocolStringList protocolStringList = proto.getStringTable().getEntryList();
        Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.stringTable.entryList");
        Iterable iterable = protocolStringList;
        CollectionsKt.addAll(object, iterable);
        object = this.nameTable;
        List<JsAstProtoBuf.Name> list2 = proto.getNameTable().getEntryList();
        Intrinsics.checkExpressionValueIsNotNull(list2, "proto.nameTable.entryList");
        iterable = list2;
        CollectionsKt.addAll(object, iterable);
        object = this.nameCache;
        Iterable iterable2 = $receiver$iv = (Iterable)this.nameTable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsAstProtoBuf.Name name = (JsAstProtoBuf.Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object e = null;
            collection.add(e);
        }
        iterable = (List)destination$iv$iv;
        CollectionsKt.addAll(object, iterable);
        try {
            JsAstProtoBuf.Fragment fragment = proto.getFragment();
            Intrinsics.checkExpressionValueIsNotNull(fragment, "proto.fragment");
            object = this.deserialize(fragment);
            return object;
        }
        finally {
            this.stringTable.clear();
            this.nameTable.clear();
            this.nameCache.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JsProgramFragment deserialize(JsAstProtoBuf.Fragment proto) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv$iv3;
        Object element$iv$iv2;
        void $receiver$iv$iv4;
        Object object;
        Object object2;
        void $receiver$iv$iv5;
        JsProgramFragment fragment = new JsProgramFragment(this.scope);
        Map<JsName, JsClassModel> map2 = fragment.getImportedModules();
        Map<String, JsExpression> $receiver$iv = proto.getImportedModuleList();
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv5) {
            JsExpression jsExpression;
            void importedModuleProto;
            JsAstProtoBuf.ImportedModule importedModule = (JsAstProtoBuf.ImportedModule)item$iv$iv;
            object2 = destination$iv$iv;
            String string = this.deserializeString(importedModuleProto.getExternalNameId());
            JsName jsName = this.deserializeName(importedModuleProto.getInternalNameId());
            if (importedModuleProto.hasPlainReference()) {
                JsAstProtoBuf.Expression expression2 = importedModuleProto.getPlainReference();
                Intrinsics.checkExpressionValueIsNotNull(expression2, "importedModuleProto.plainReference");
                jsExpression = this.deserialize(expression2);
            } else {
                jsExpression = null;
            }
            object = new JsImportedModule(string, jsName, jsExpression);
            object2.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        CollectionsKt.addAll(map2, $receiver$iv);
        map2 = fragment.getImports();
        $receiver$iv = proto.getImportEntryList();
        int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        for (Object element$iv$iv2 : $receiver$iv$iv4) {
            Map $i$a$3$map = destination$iv$iv2;
            JsAstProtoBuf.Import importProto = (JsAstProtoBuf.Import)element$iv$iv2;
            String string = this.deserializeString(importProto.getSignatureId());
            JsAstProtoBuf.Expression expression3 = importProto.getExpression();
            Intrinsics.checkExpressionValueIsNotNull(expression3, "importProto.expression");
            Pair<String, JsExpression> pair = TuplesKt.to(string, this.deserialize(expression3));
            $i$a$3$map.put(pair.getFirst(), pair.getSecond());
        }
        $receiver$iv = destination$iv$iv2;
        map2.putAll($receiver$iv);
        if (proto.hasDeclarationBlock()) {
            map2 = fragment.getDeclarationBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.declarationBlock");
            List<JsStatement> list2 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "deserializeGlobalBlock(p\u2026larationBlock).statements");
            $receiver$iv = list2;
            CollectionsKt.addAll(map2, $receiver$iv);
        }
        if (proto.hasInitializerBlock()) {
            map2 = fragment.getInitializerBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getInitializerBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.initializerBlock");
            List<JsStatement> list3 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list3, "deserializeGlobalBlock(p\u2026tializerBlock).statements");
            $receiver$iv = list3;
            CollectionsKt.addAll(map2, $receiver$iv);
        }
        if (proto.hasExportBlock()) {
            map2 = fragment.getExportBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getExportBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.exportBlock");
            List<JsStatement> list4 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list4, "deserializeGlobalBlock(p\u2026o.exportBlock).statements");
            $receiver$iv = list4;
            CollectionsKt.addAll(map2, $receiver$iv);
        }
        map2 = fragment.getNameBindings();
        Map<String, JsExpression> capacity$iv22 = $receiver$iv = (Iterable)proto.getNameBindingList();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv3) {
            void nameBindingProto;
            element$iv$iv2 = (JsAstProtoBuf.NameBinding)item$iv$iv;
            object2 = destination$iv$iv;
            object = new JsNameBinding(this.deserializeString(nameBindingProto.getSignatureId()), this.deserializeName(nameBindingProto.getNameId()));
            object2.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        CollectionsKt.addAll(map2, $receiver$iv);
        map2 = fragment.getClasses();
        $receiver$iv = proto.getClassModelList();
        int capacity$iv32 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv32);
        for (Object element$iv$iv2 : $receiver$iv$iv4) {
            JsClassModel $i$f$map;
            JsAstProtoBuf.ClassModel clsProto;
            Iterator $i$a$5$map = destination$iv$iv2;
            JsAstProtoBuf.ClassModel classModel = clsProto = (JsAstProtoBuf.ClassModel)element$iv$iv2;
            Intrinsics.checkExpressionValueIsNotNull(classModel, "clsProto");
            JsClassModel it = $i$f$map = this.deserialize(classModel);
            Pair<JsName, JsClassModel> pair = TuplesKt.to(it.getName(), it);
            $i$a$5$map.put(pair.getFirst(), pair.getSecond());
        }
        $receiver$iv = destination$iv$iv2;
        map2.putAll((Map<JsName, JsClassModel>)$receiver$iv);
        Map<String, JsExpression> capacity$iv32 = $receiver$iv = (Iterable)proto.getModuleExpressionList();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            element$iv$iv2 = (JsAstProtoBuf.Expression)item$iv$iv;
            object2 = destination$iv$iv;
            void v13 = it;
            Intrinsics.checkExpressionValueIsNotNull(v13, "it");
            object = this.deserialize((JsAstProtoBuf.Expression)v13);
            object2.add(object);
        }
        List moduleExpressions = (List)destination$iv$iv;
        $receiver$iv = fragment.getInlineModuleMap();
        Iterable $receiver$iv2 = proto.getInlineModuleList();
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10)), 16);
        destination$iv$iv2 = $receiver$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv3 : $receiver$iv$iv) {
            Map map3 = destination$iv$iv3;
            JsAstProtoBuf.InlineModule inlineModuleProto = (JsAstProtoBuf.InlineModule)element$iv$iv3;
            Pair pair = TuplesKt.to(this.deserializeString(inlineModuleProto.getSignatureId()), moduleExpressions.get(inlineModuleProto.getExpressionId()));
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map map4 = destination$iv$iv3;
        $receiver$iv.putAll(map4);
        for (JsNameBinding nameBinding : fragment.getNameBindings()) {
            Map<String, JsExpression> map5;
            Map<String, JsExpression> map6 = fragment.getImports();
            String string = nameBinding.getKey();
            object2 = nameBinding.getName();
            Map<String, JsExpression> map7 = map5 = map6;
            if (map7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            boolean bl = map7.containsKey(string);
            MetadataProperties.setImported((JsName)object2, bl);
        }
        return fragment;
    }

    private final JsClassModel deserialize(JsAstProtoBuf.ClassModel proto) {
        JsClassModel jsClassModel;
        JsName superName = proto.hasSuperNameId() ? this.deserializeName(proto.getSuperNameId()) : null;
        JsClassModel $receiver = jsClassModel = new JsClassModel(this.deserializeName(proto.getNameId()), superName);
        if (proto.hasPostDeclarationBlock()) {
            Collection collection = $receiver.getPostDeclarationBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getPostDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.postDeclarationBlock");
            List<JsStatement> list2 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "deserializeGlobalBlock(p\u2026larationBlock).statements");
            Iterable iterable = list2;
            CollectionsKt.addAll(collection, iterable);
        }
        return jsClassModel;
    }

    private final JsStatement deserialize(JsAstProtoBuf.Statement proto) {
        JsStatement statement2 = (JsStatement)this.withLocation(proto.hasFileId() ? Integer.valueOf(proto.getFileId()) : null, proto.hasLocation() ? proto.getLocation() : null, (Function0)new Function0<JsStatement>(this, proto){
            final /* synthetic */ JsAstDeserializer this$0;
            final /* synthetic */ JsAstProtoBuf.Statement $proto;

            @NotNull
            public final JsStatement invoke() {
                return JsAstDeserializer.access$deserializeNoMetadata(this.this$0, this.$proto);
            }
            {
                this.this$0 = jsAstDeserializer;
                this.$proto = statement2;
                super(0);
            }
        });
        if (statement2 instanceof HasMetadata) {
            MetadataProperties.setSynthetic((HasMetadata)((Object)statement2), proto.getSynthetic());
        }
        return statement2;
    }

    /*
     * Unable to fully structure code
     */
    private final JsStatement deserializeNoMetadata(JsAstProtoBuf.Statement proto) {
        v0 = proto.getStatementCase();
        if (v0 == null) ** GOTO lbl-1000
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                returnProto = proto.getReturnStatement();
                if (returnProto.hasValue()) {
                    v1 = returnProto.getValue();
                    Intrinsics.checkExpressionValueIsNotNull(v1, "returnProto.value");
                    v2 = this.deserialize(v1);
                } else {
                    v2 = null;
                }
                v3 = new JsReturn(v2);
                break;
            }
            case 2: {
                throwProto = proto.getThrowStatement();
                v4 = throwProto.getException();
                Intrinsics.checkExpressionValueIsNotNull(v4, "throwProto.exception");
                v3 = new JsThrow(this.deserialize(v4));
                break;
            }
            case 3: {
                breakProto = proto.getBreakStatement();
                v3 = new JsBreak(breakProto.hasLabelId() != false ? new JsNameRef(this.deserializeName(breakProto.getLabelId())) : null);
                break;
            }
            case 4: {
                continueProto = proto.getContinueStatement();
                v3 = new JsContinue(continueProto.hasLabelId() != false ? new JsNameRef(this.deserializeName(continueProto.getLabelId())) : null);
                break;
            }
            case 5: {
                v3 = new JsDebugger();
                break;
            }
            case 6: {
                expressionProto = proto.getExpression();
                v5 = expressionProto.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(v5, "expressionProto.expression");
                it = var3_17 = new JsExpressionStatement(this.deserialize(v5));
                if (expressionProto.hasExportedTagId()) {
                    MetadataProperties.setExportedTag(it, this.deserializeString(expressionProto.getExportedTagId()));
                }
                v3 = var3_17;
                break;
            }
            case 7: {
                v6 = proto.getVars();
                Intrinsics.checkExpressionValueIsNotNull(v6, "proto.vars");
                v3 = this.deserializeVars(v6);
                break;
            }
            case 8: {
                blockProto = proto.getBlock();
                block = new JsBlock();
                it = block.getStatements();
                var6_34 = $receiver$iv = (Iterable)blockProto.getStatementList();
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var10_47 = (JsAstProtoBuf.Statement)item$iv$iv;
                    var11_49 = destination$iv$iv;
                    v7 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v7, "it");
                    var12_51 = this.deserialize((JsAstProtoBuf.Statement)v7);
                    var11_49.add(var12_51);
                }
                $receiver$iv = (List)destination$iv$iv;
                CollectionsKt.addAll(it, $receiver$iv);
                v3 = block;
                break;
            }
            case 9: {
                v8 = proto.getGlobalBlock();
                Intrinsics.checkExpressionValueIsNotNull(v8, "proto.globalBlock");
                v3 = this.deserializeGlobalBlock(v8);
                break;
            }
            case 10: {
                labelProto = proto.getLabel();
                v9 = this.deserializeName(labelProto.getNameId());
                v10 = labelProto.getInnerStatement();
                Intrinsics.checkExpressionValueIsNotNull(v10, "labelProto.innerStatement");
                v3 = new JsLabel(v9, this.deserialize(v10));
                break;
            }
            case 11: {
                ifProto = proto.getIfStatement();
                v11 = ifProto.getCondition();
                Intrinsics.checkExpressionValueIsNotNull(v11, "ifProto.condition");
                v12 = this.deserialize(v11);
                v13 = ifProto.getThenStatement();
                Intrinsics.checkExpressionValueIsNotNull(v13, "ifProto.thenStatement");
                v14 = this.deserialize(v13);
                if (ifProto.hasElseStatement()) {
                    v15 = ifProto.getElseStatement();
                    Intrinsics.checkExpressionValueIsNotNull(v15, "ifProto.elseStatement");
                    v16 = this.deserialize(v15);
                } else {
                    v16 = null;
                }
                v3 = new JsIf(v12, v14, v16);
                break;
            }
            case 12: {
                switchProto = proto.getSwitchStatement();
                v17 = switchProto.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(v17, "switchProto.expression");
                block = switchProto.getEntryList();
                var13_53 = this.deserialize(v17);
                var12_52 = v18;
                var11_50 = v18;
                it = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var8_44 = (JsAstProtoBuf.SwitchEntry)item$iv$iv;
                    var14_54 = destination$iv$iv;
                    if (entryProto.hasLabel()) {
                        var9_46 = new JsCase();
                        $receiver = var9_46;
                        v19 = entryProto.getLabel();
                        Intrinsics.checkExpressionValueIsNotNull(v19, "entryProto.label");
                        $receiver.setCaseExpression(this.deserialize(v19));
                        v20 = (JsSwitchMember)var9_46;
                    } else {
                        v20 = new JsDefault();
                    }
                    member = v20;
                    var9_46 = member.getStatements();
                    $i$a$1$apply = $receiver$iv = (Iterable)entryProto.getStatementList();
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        var20_60 = (JsAstProtoBuf.Statement)item$iv$iv;
                        var21_61 = destination$iv$iv;
                        v21 = it;
                        Intrinsics.checkExpressionValueIsNotNull(v21, "it");
                        var22_62 = this.deserialize((JsAstProtoBuf.Statement)v21);
                        var21_61.add(var22_62);
                    }
                    var10_48 = (List)destination$iv$iv;
                    CollectionsKt.addAll(var9_46, var10_48);
                    var23_63 = member;
                    var14_54.add(var23_63);
                }
                var14_54 = (List)destination$iv$iv;
                var12_52(var13_53, (List<JsSwitchMember>)var14_54);
                v3 = var11_50;
                break;
            }
            case 13: {
                whileProto = proto.getWhileStatement();
                v22 = whileProto.getCondition();
                Intrinsics.checkExpressionValueIsNotNull(v22, "whileProto.condition");
                v23 = this.deserialize(v22);
                v24 = whileProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v24, "whileProto.body");
                v3 = new JsWhile(v23, this.deserialize(v24));
                break;
            }
            case 14: {
                doWhileProto = proto.getDoWhileStatement();
                v25 = doWhileProto.getCondition();
                Intrinsics.checkExpressionValueIsNotNull(v25, "doWhileProto.condition");
                v26 = this.deserialize(v25);
                v27 = doWhileProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v27, "doWhileProto.body");
                v3 = new JsDoWhile(v26, this.deserialize(v27));
                break;
            }
            case 15: {
                forProto = proto.getForStatement();
                if (forProto.hasVariables()) {
                    v28 = forProto.getVariables();
                    Intrinsics.checkExpressionValueIsNotNull(v28, "forProto.variables");
                    v29 = this.deserialize(v28);
                    if (v29 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsVars");
                    }
                    v30 = (JsVars)v29;
                } else {
                    v30 = initVars = null;
                }
                if (forProto.hasExpression()) {
                    v31 = forProto.getExpression();
                    Intrinsics.checkExpressionValueIsNotNull(v31, "forProto.expression");
                    v32 = this.deserialize(v31);
                } else {
                    v32 = initExpr = null;
                }
                if (forProto.hasCondition()) {
                    v33 = forProto.getCondition();
                    Intrinsics.checkExpressionValueIsNotNull(v33, "forProto.condition");
                    v34 = this.deserialize(v33);
                } else {
                    v34 = condition = null;
                }
                if (forProto.hasIncrement()) {
                    v35 = forProto.getIncrement();
                    Intrinsics.checkExpressionValueIsNotNull(v35, "forProto.increment");
                    v36 = this.deserialize(v35);
                } else {
                    v36 = null;
                }
                increment = v36;
                v37 = forProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v37, "forProto.body");
                body = this.deserialize(v37);
                if (initVars != null) {
                    v38 = new JsFor(initVars, condition, increment, body);
                } else {
                    v39 = initExpr;
                    if (v39 == null) {
                        Intrinsics.throwNpe();
                    }
                    v38 = new JsFor(v39, condition, increment, body);
                }
                v3 = v38;
                break;
            }
            case 16: {
                forInProto = proto.getForInStatement();
                v40 = iterName = forInProto.hasNameId() != false ? this.deserializeName(forInProto.getNameId()) : null;
                if (forInProto.hasExpression()) {
                    v41 = forInProto.getExpression();
                    Intrinsics.checkExpressionValueIsNotNull(v41, "forInProto.expression");
                    v42 = this.deserialize(v41);
                } else {
                    v42 = null;
                }
                iterExpr = v42;
                v43 = forInProto.getIterable();
                Intrinsics.checkExpressionValueIsNotNull(v43, "forInProto.iterable");
                iterable = this.deserialize(v43);
                v44 = forInProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v44, "forInProto.body");
                body = this.deserialize(v44);
                v3 = new JsForIn(iterName, iterExpr, iterable, body);
                break;
            }
            case 17: {
                tryProto = proto.getTryStatement();
                v45 = tryProto.getTryBlock();
                Intrinsics.checkExpressionValueIsNotNull(v45, "tryProto.tryBlock");
                v46 = this.deserialize(v45);
                if (v46 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                }
                tryBlock = (JsBlock)v46;
                if (tryProto.hasCatchBlock()) {
                    catchProto = tryProto.getCatchBlock();
                    $receiver = var6_38 = new JsCatch(this.deserializeName(catchProto.getParameter().getNameId()));
                    v47 = catchProto.getBody();
                    Intrinsics.checkExpressionValueIsNotNull(v47, "catchProto.body");
                    v48 = this.deserialize(v47);
                    if (v48 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                    }
                    $receiver.setBody((JsBlock)v48);
                    v49 = var6_38;
                } else {
                    v49 = catchBlock = null;
                }
                if (tryProto.hasFinallyBlock()) {
                    v50 = tryProto.getFinallyBlock();
                    Intrinsics.checkExpressionValueIsNotNull(v50, "tryProto.finallyBlock");
                    v51 = this.deserialize(v50);
                    if (v51 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                    }
                    v52 = (JsBlock)v51;
                } else {
                    v52 = null;
                }
                finallyBlock = v52;
                v3 = new JsTry(tryBlock, catchBlock, finallyBlock);
                break;
            }
            case 18: {
                v3 = JsEmpty.INSTANCE;
                break;
            }
            case 19: lbl-1000:
            // 2 sources

            {
                var2_16 = "Statement not set";
                throw (Throwable)new IllegalStateException(var2_16.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v3;
    }

    private final JsExpression deserialize(JsAstProtoBuf.Expression proto) {
        JsExpression expression2 = (JsExpression)this.withLocation(proto.hasFileId() ? Integer.valueOf(proto.getFileId()) : null, proto.hasLocation() ? proto.getLocation() : null, (Function0)new Function0<JsExpression>(this, proto){
            final /* synthetic */ JsAstDeserializer this$0;
            final /* synthetic */ JsAstProtoBuf.Expression $proto;

            @NotNull
            public final JsExpression invoke() {
                return JsAstDeserializer.access$deserializeNoMetadata(this.this$0, this.$proto);
            }
            {
                this.this$0 = jsAstDeserializer;
                this.$proto = expression2;
                super(0);
            }
        });
        MetadataProperties.setSynthetic(expression2, proto.getSynthetic());
        HasMetadata hasMetadata = expression2;
        JsAstProtoBuf.SideEffects sideEffects = proto.getSideEffects();
        Intrinsics.checkExpressionValueIsNotNull(sideEffects, "proto.sideEffects");
        MetadataProperties.setSideEffects(hasMetadata, this.map(sideEffects));
        return expression2;
    }

    /*
     * Unable to fully structure code
     */
    private final JsExpression deserializeNoMetadata(JsAstProtoBuf.Expression proto) {
        v0 = proto.getExpressionCase();
        if (v0 == null) ** GOTO lbl-1000
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
            case 1: {
                v1 = new JsThisRef();
                break;
            }
            case 2: {
                v1 = new JsNullLiteral();
                break;
            }
            case 3: {
                v1 = new JsBooleanLiteral(true);
                break;
            }
            case 4: {
                v1 = new JsBooleanLiteral(false);
                break;
            }
            case 5: {
                v1 = new JsStringLiteral(this.deserializeString(proto.getStringLiteral()));
                break;
            }
            case 6: {
                v1 = new JsIntLiteral(proto.getIntLiteral());
                break;
            }
            case 7: {
                v1 = new JsDoubleLiteral(proto.getDoubleLiteral());
                break;
            }
            case 8: {
                v1 = new JsNameRef(this.deserializeName(proto.getSimpleNameReference()));
                break;
            }
            case 9: {
                regExpProto = proto.getRegExpLiteral();
                $receiver = var3_16 = new JsRegExp();
                $receiver.setPattern(this.deserializeString(regExpProto.getPatternStringId()));
                if (regExpProto.hasFlagsStringId()) {
                    $receiver.setFlags(this.deserializeString(regExpProto.getFlagsStringId()));
                }
                v1 = var3_16;
                break;
            }
            case 10: {
                arrayProto = proto.getArrayLiteral();
                var3_17 = arrayProto.getElementList();
                var5_36 = v2;
                var6_41 = v2;
                $receiver = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var10_66 = (JsAstProtoBuf.Expression)item$iv$iv;
                    var11_72 = destination$iv$iv;
                    v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                    var12_77 = this.deserialize((JsAstProtoBuf.Expression)v3);
                    var11_72.add(var12_77);
                }
                var11_72 = (List)destination$iv$iv;
                var5_36((List<JsExpression>)var11_72);
                v1 = var6_41;
                break;
            }
            case 11: {
                objectProto = proto.getObjectLiteral();
                $receiver$iv = objectProto.getEntryList();
                var5_37 = v4;
                var6_42 = v4;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (JsAstProtoBuf.ObjectLiteralEntry)item$iv$iv;
                    var11_73 = destination$iv$iv;
                    v5 = entryProto.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(v5, "entryProto.key");
                    v6 = this.deserialize(v5);
                    v7 = entryProto.getValue();
                    Intrinsics.checkExpressionValueIsNotNull(v7, "entryProto.value");
                    var12_78 = new JsPropertyInitializer(v6, this.deserialize(v7));
                    var11_73.add(var12_78);
                }
                var11_73 = (List)destination$iv$iv;
                var5_37((List<JsPropertyInitializer>)var11_73, objectProto.getMultiline());
                v1 = var6_42;
                break;
            }
            case 12: {
                functionProto = proto.getFunction();
                v8 = this.scope;
                v9 = functionProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v9, "functionProto.body");
                v10 = this.deserialize(v9);
                if (v10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                }
                $receiver = $receiver$iv = new JsFunction(v8, (JsBlock)v10, "");
                destination$iv$iv = $receiver.getParameters();
                item$iv$iv = $receiver$iv = (Iterable)functionProto.getParameterList();
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    $i$f$map = (JsAstProtoBuf.Parameter)item$iv$iv;
                    var16_87 = destination$iv$iv;
                    v11 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v11, "it");
                    var17_89 = this.deserializeParameter((JsAstProtoBuf.Parameter)v11);
                    var16_87.add(var17_89);
                }
                $receiver$iv = (List)destination$iv$iv;
                CollectionsKt.addAll(destination$iv$iv, $receiver$iv);
                if (functionProto.hasNameId()) {
                    $receiver.setName(this.deserializeName(functionProto.getNameId()));
                }
                MetadataProperties.setLocal($receiver, functionProto.getLocal());
                v1 = $receiver$iv;
                break;
            }
            case 13: {
                docCommentProto = proto.getDocComment();
                $receiver$iv = docCommentProto.getTagList();
                var5_38 = v12;
                var6_43 = v12;
                capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                destination$iv$iv = $receiver$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                for (T element$iv$iv : $receiver$iv$iv) {
                    $i$a$6$map = destination$iv$iv;
                    tagProto = (JsAstProtoBuf.DocCommentTag)element$iv$iv;
                    name = this.deserializeString(tagProto.getNameId());
                    if (tagProto.hasExpression()) {
                        v13 = tagProto.getExpression();
                        Intrinsics.checkExpressionValueIsNotNull(v13, "tagProto.expression");
                        v14 = this.deserialize(v13);
                    } else {
                        v14 = this.deserializeString(tagProto.getValueStringId());
                    }
                    value = v14;
                    var18_90 = TuplesKt.to(name, value);
                    $i$a$6$map.put(var18_90.getFirst(), var18_90.getSecond());
                }
                var11_74 = destination$iv$iv;
                var5_38(var11_74);
                v1 = var6_43;
                break;
            }
            case 14: {
                binaryProto = proto.getBinary();
                v15 = binaryProto.getType();
                Intrinsics.checkExpressionValueIsNotNull(v15, "binaryProto.type");
                v16 = this.map(v15);
                v17 = binaryProto.getLeft();
                Intrinsics.checkExpressionValueIsNotNull(v17, "binaryProto.left");
                v18 = this.deserialize(v17);
                v19 = binaryProto.getRight();
                Intrinsics.checkExpressionValueIsNotNull(v19, "binaryProto.right");
                v1 = new JsBinaryOperation(v16, v18, this.deserialize(v19));
                break;
            }
            case 15: {
                unaryProto = proto.getUnary();
                v20 = unaryProto.getType();
                Intrinsics.checkExpressionValueIsNotNull(v20, "unaryProto.type");
                type = this.map(v20);
                v21 = unaryProto.getOperand();
                Intrinsics.checkExpressionValueIsNotNull(v21, "unaryProto.operand");
                operand = this.deserialize(v21);
                v1 = unaryProto.getPostfix() != false ? (JsUnaryOperation)new JsPostfixOperation(type, operand) : (JsUnaryOperation)new JsPrefixOperation(type, operand);
                break;
            }
            case 16: {
                conditionalProto = proto.getConditional();
                v22 = conditionalProto.getTestExpression();
                Intrinsics.checkExpressionValueIsNotNull(v22, "conditionalProto.testExpression");
                v23 = this.deserialize(v22);
                v24 = conditionalProto.getThenExpression();
                Intrinsics.checkExpressionValueIsNotNull(v24, "conditionalProto.thenExpression");
                v25 = this.deserialize(v24);
                v26 = conditionalProto.getElseExpression();
                Intrinsics.checkExpressionValueIsNotNull(v26, "conditionalProto.elseExpression");
                v1 = new JsConditional(v23, v25, this.deserialize(v26));
                break;
            }
            case 17: {
                arrayAccessProto = proto.getArrayAccess();
                v27 = arrayAccessProto.getArray();
                Intrinsics.checkExpressionValueIsNotNull(v27, "arrayAccessProto.array");
                v28 = this.deserialize(v27);
                v29 = arrayAccessProto.getIndex();
                Intrinsics.checkExpressionValueIsNotNull(v29, "arrayAccessProto.index");
                v1 = new JsArrayAccess(v28, this.deserialize(v29));
                break;
            }
            case 18: {
                nameRefProto = proto.getNameReference();
                if (nameRefProto.hasQualifier()) {
                    v30 = nameRefProto.getQualifier();
                    Intrinsics.checkExpressionValueIsNotNull(v30, "nameRefProto.qualifier");
                    v31 = this.deserialize(v30);
                } else {
                    v31 = null;
                }
                qualifier = v31;
                $receiver = operand = new JsNameRef(this.deserializeName(nameRefProto.getNameId()), qualifier);
                if (nameRefProto.hasInlineStrategy()) {
                    v32 = nameRefProto.getInlineStrategy();
                    Intrinsics.checkExpressionValueIsNotNull(v32, "nameRefProto.inlineStrategy");
                    MetadataProperties.setInlineStrategy($receiver, this.map(v32));
                }
                v1 = operand;
                break;
            }
            case 19: {
                propertyRefProto = proto.getPropertyReference();
                if (propertyRefProto.hasQualifier()) {
                    v33 = propertyRefProto.getQualifier();
                    Intrinsics.checkExpressionValueIsNotNull(v33, "propertyRefProto.qualifier");
                    v34 = this.deserialize(v33);
                } else {
                    v34 = null;
                }
                qualifier = v34;
                $receiver = operand = new JsNameRef(this.deserializeString(propertyRefProto.getStringId()), qualifier);
                if (propertyRefProto.hasInlineStrategy()) {
                    v35 = propertyRefProto.getInlineStrategy();
                    Intrinsics.checkExpressionValueIsNotNull(v35, "propertyRefProto.inlineStrategy");
                    MetadataProperties.setInlineStrategy($receiver, this.map(v35));
                }
                v1 = operand;
                break;
            }
            case 20: {
                invocationProto = proto.getInvocation();
                v36 = invocationProto.getQualifier();
                Intrinsics.checkExpressionValueIsNotNull(v36, "invocationProto.qualifier");
                qualifier = invocationProto.getArgumentList();
                var11_75 = this.deserialize(v36);
                var5_39 = v37;
                var6_44 = v37;
                operand = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    element$iv$iv = (JsAstProtoBuf.Expression)item$iv$iv;
                    var12_79 = destination$iv$iv;
                    v38 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v38, "it");
                    var19_91 = this.deserialize((JsAstProtoBuf.Expression)v38);
                    var12_79.add(var19_91);
                }
                var12_79 = (List)destination$iv$iv;
                var5_39(var11_75, (List<? extends JsExpression>)var12_79);
                $receiver = $receiver$iv = var6_44;
                if (invocationProto.hasInlineStrategy()) {
                    v39 = invocationProto.getInlineStrategy();
                    Intrinsics.checkExpressionValueIsNotNull(v39, "invocationProto.inlineStrategy");
                    MetadataProperties.setInlineStrategy($receiver, this.map(v39));
                }
                v1 = $receiver$iv;
                break;
            }
            case 21: {
                instantiationProto = proto.getInstantiation();
                v40 = instantiationProto.getQualifier();
                Intrinsics.checkExpressionValueIsNotNull(v40, "instantiationProto.qualifier");
                $receiver$iv = instantiationProto.getArgumentList();
                var11_76 = this.deserialize(v40);
                var5_40 = v41;
                var6_45 = v41;
                $receiver = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (JsAstProtoBuf.Expression)item$iv$iv;
                    var12_80 = destination$iv$iv;
                    v42 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v42, "it");
                    var19_92 = this.deserialize(v42);
                    var12_80.add(var19_92);
                }
                var12_80 = (List)destination$iv$iv;
                var5_40(var11_76, (List<? extends JsExpression>)var12_80);
                v1 = var6_45;
                break;
            }
            case 22: lbl-1000:
            // 2 sources

            {
                var2_15 = "Unknown expression";
                throw (Throwable)new IllegalStateException(var2_15.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v1;
    }

    private final JsVars deserializeVars(JsAstProtoBuf.Vars proto) {
        JsVars vars = new JsVars(proto.getMultiline());
        for (JsAstProtoBuf.VarDeclaration declProto : proto.getDeclarationList()) {
            Collection collection = vars.getVars();
            Object t = this.withLocation(declProto.hasFileId() ? Integer.valueOf(declProto.getFileId()) : null, declProto.hasLocation() ? declProto.getLocation() : null, (Function0)new Function0<JsVars.JsVar>(this, declProto){
                final /* synthetic */ JsAstDeserializer this$0;
                final /* synthetic */ JsAstProtoBuf.VarDeclaration $declProto;

                @NotNull
                public final JsVars.JsVar invoke() {
                    JsExpression jsExpression;
                    if (this.$declProto.hasInitialValue()) {
                        JsAstProtoBuf.Expression expression2 = this.$declProto.getInitialValue();
                        Intrinsics.checkExpressionValueIsNotNull(expression2, "declProto.initialValue");
                        jsExpression = JsAstDeserializer.access$deserialize(this.this$0, expression2);
                    } else {
                        jsExpression = null;
                    }
                    JsExpression initialValue = jsExpression;
                    return new JsVars.JsVar(JsAstDeserializer.access$deserializeName(this.this$0, this.$declProto.getNameId()), initialValue);
                }
                {
                    this.this$0 = jsAstDeserializer;
                    this.$declProto = varDeclaration;
                    super(0);
                }
            });
            collection.add(t);
        }
        if (proto.hasExportedPackageId()) {
            MetadataProperties.setExportedPackage(vars, this.deserializeString(proto.getExportedPackageId()));
        }
        return vars;
    }

    /*
     * WARNING - void declaration
     */
    private final JsGlobalBlock deserializeGlobalBlock(JsAstProtoBuf.GlobalBlock proto) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        JsGlobalBlock jsGlobalBlock;
        JsGlobalBlock $receiver = jsGlobalBlock = new JsGlobalBlock();
        Collection collection = $receiver.getStatements();
        Iterable iterable = $receiver$iv = (Iterable)proto.getStatementList();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsAstProtoBuf.Statement statement2 = (JsAstProtoBuf.Statement)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            JsStatement jsStatement = this.deserialize((JsAstProtoBuf.Statement)v0);
            collection2.add(jsStatement);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll(collection, iterable2);
        return jsGlobalBlock;
    }

    private final JsParameter deserializeParameter(JsAstProtoBuf.Parameter proto) {
        JsParameter jsParameter;
        JsParameter $receiver = jsParameter = new JsParameter(this.deserializeName(proto.getNameId()));
        MetadataProperties.setHasDefaultValue($receiver, proto.getHasDefaultValue());
        return jsParameter;
    }

    private final JsName deserializeName(int id) {
        JsName jsName = this.nameCache.get(id);
        if (jsName == null) {
            JsAstDeserializer jsAstDeserializer;
            JsAstDeserializer it = jsAstDeserializer = this;
            JsAstProtoBuf.Name nameProto = this.nameTable.get(id);
            String identifier = this.deserializeString(nameProto.getIdentifier());
            JsName name = nameProto.getTemporary() ? JsScope.declareTemporaryName(identifier) : JsDynamicScope.INSTANCE.declareName(identifier);
            this.nameCache.set(id, name);
            JsName jsName2 = name;
            jsName = jsName2;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "let {\n            val na\u2026           name\n        }");
        }
        return jsName;
    }

    private final String deserializeString(int id) {
        return this.stringTable.get(id);
    }

    private final JsBinaryOperator map(JsAstProtoBuf.BinaryOperation.Type op) {
        JsBinaryOperator jsBinaryOperator;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$2[op.ordinal()]) {
            case 1: {
                jsBinaryOperator = JsBinaryOperator.MUL;
                break;
            }
            case 2: {
                jsBinaryOperator = JsBinaryOperator.DIV;
                break;
            }
            case 3: {
                jsBinaryOperator = JsBinaryOperator.MOD;
                break;
            }
            case 4: {
                jsBinaryOperator = JsBinaryOperator.ADD;
                break;
            }
            case 5: {
                jsBinaryOperator = JsBinaryOperator.SUB;
                break;
            }
            case 6: {
                jsBinaryOperator = JsBinaryOperator.SHL;
                break;
            }
            case 7: {
                jsBinaryOperator = JsBinaryOperator.SHR;
                break;
            }
            case 8: {
                jsBinaryOperator = JsBinaryOperator.SHRU;
                break;
            }
            case 9: {
                jsBinaryOperator = JsBinaryOperator.LT;
                break;
            }
            case 10: {
                jsBinaryOperator = JsBinaryOperator.LTE;
                break;
            }
            case 11: {
                jsBinaryOperator = JsBinaryOperator.GT;
                break;
            }
            case 12: {
                jsBinaryOperator = JsBinaryOperator.GTE;
                break;
            }
            case 13: {
                jsBinaryOperator = JsBinaryOperator.INSTANCEOF;
                break;
            }
            case 14: {
                jsBinaryOperator = JsBinaryOperator.INOP;
                break;
            }
            case 15: {
                jsBinaryOperator = JsBinaryOperator.EQ;
                break;
            }
            case 16: {
                jsBinaryOperator = JsBinaryOperator.NEQ;
                break;
            }
            case 17: {
                jsBinaryOperator = JsBinaryOperator.REF_EQ;
                break;
            }
            case 18: {
                jsBinaryOperator = JsBinaryOperator.REF_NEQ;
                break;
            }
            case 19: {
                jsBinaryOperator = JsBinaryOperator.BIT_AND;
                break;
            }
            case 20: {
                jsBinaryOperator = JsBinaryOperator.BIT_XOR;
                break;
            }
            case 21: {
                jsBinaryOperator = JsBinaryOperator.BIT_OR;
                break;
            }
            case 22: {
                jsBinaryOperator = JsBinaryOperator.AND;
                break;
            }
            case 23: {
                jsBinaryOperator = JsBinaryOperator.OR;
                break;
            }
            case 24: {
                jsBinaryOperator = JsBinaryOperator.ASG;
                break;
            }
            case 25: {
                jsBinaryOperator = JsBinaryOperator.ASG_ADD;
                break;
            }
            case 26: {
                jsBinaryOperator = JsBinaryOperator.ASG_SUB;
                break;
            }
            case 27: {
                jsBinaryOperator = JsBinaryOperator.ASG_MUL;
                break;
            }
            case 28: {
                jsBinaryOperator = JsBinaryOperator.ASG_DIV;
                break;
            }
            case 29: {
                jsBinaryOperator = JsBinaryOperator.ASG_MOD;
                break;
            }
            case 30: {
                jsBinaryOperator = JsBinaryOperator.ASG_SHL;
                break;
            }
            case 31: {
                jsBinaryOperator = JsBinaryOperator.ASG_SHR;
                break;
            }
            case 32: {
                jsBinaryOperator = JsBinaryOperator.ASG_SHRU;
                break;
            }
            case 33: {
                jsBinaryOperator = JsBinaryOperator.ASG_BIT_AND;
                break;
            }
            case 34: {
                jsBinaryOperator = JsBinaryOperator.ASG_BIT_OR;
                break;
            }
            case 35: {
                jsBinaryOperator = JsBinaryOperator.ASG_BIT_XOR;
                break;
            }
            case 36: {
                jsBinaryOperator = JsBinaryOperator.COMMA;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsBinaryOperator;
    }

    private final JsUnaryOperator map(JsAstProtoBuf.UnaryOperation.Type op) {
        JsUnaryOperator jsUnaryOperator;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$3[op.ordinal()]) {
            case 1: {
                jsUnaryOperator = JsUnaryOperator.BIT_NOT;
                break;
            }
            case 2: {
                jsUnaryOperator = JsUnaryOperator.DEC;
                break;
            }
            case 3: {
                jsUnaryOperator = JsUnaryOperator.DELETE;
                break;
            }
            case 4: {
                jsUnaryOperator = JsUnaryOperator.INC;
                break;
            }
            case 5: {
                jsUnaryOperator = JsUnaryOperator.NEG;
                break;
            }
            case 6: {
                jsUnaryOperator = JsUnaryOperator.POS;
                break;
            }
            case 7: {
                jsUnaryOperator = JsUnaryOperator.NOT;
                break;
            }
            case 8: {
                jsUnaryOperator = JsUnaryOperator.TYPEOF;
                break;
            }
            case 9: {
                jsUnaryOperator = JsUnaryOperator.VOID;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsUnaryOperator;
    }

    private final SideEffectKind map(JsAstProtoBuf.SideEffects sideEffects) {
        SideEffectKind sideEffectKind;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$4[sideEffects.ordinal()]) {
            case 1: {
                sideEffectKind = SideEffectKind.AFFECTS_STATE;
                break;
            }
            case 2: {
                sideEffectKind = SideEffectKind.DEPENDS_ON_STATE;
                break;
            }
            case 3: {
                sideEffectKind = SideEffectKind.PURE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sideEffectKind;
    }

    private final InlineStrategy map(JsAstProtoBuf.InlineStrategy inlineStrategy) {
        InlineStrategy inlineStrategy2;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$5[inlineStrategy.ordinal()]) {
            case 1: {
                inlineStrategy2 = InlineStrategy.AS_FUNCTION;
                break;
            }
            case 2: {
                inlineStrategy2 = InlineStrategy.IN_PLACE;
                break;
            }
            case 3: {
                inlineStrategy2 = InlineStrategy.NOT_INLINE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return inlineStrategy2;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends JsNode> T withLocation(Integer fileId, JsAstProtoBuf.Location location2, Function0<? extends T> action) {
        boolean shouldUpdateFile;
        String deserializedFile;
        String string;
        String string2;
        Integer n = fileId;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            string2 = this.deserializeString(it);
        } else {
            string2 = null;
        }
        if ((string = (deserializedFile = string2)) == null) {
            string = this.fileStack.peek();
        }
        String file = string;
        JsLocation deserializedLocation = file != null && location2 != null ? new JsLocation(file, location2.getStartLine(), location2.getStartChar()) : null;
        boolean bl = shouldUpdateFile = location2 != null && deserializedFile != null && Intrinsics.areEqual(deserializedFile, this.fileStack.peek()) ^ true;
        if (shouldUpdateFile) {
            this.fileStack.push(deserializedFile);
        }
        JsNode node = (JsNode)action.invoke();
        if (deserializedLocation != null) {
            Object v4;
            block8: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable<File> iterable = this.sourceRoots;
                Iterator iterator2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    File file3 = new File((File)it, file);
                    collection.add(file3);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    File it = (File)element$iv;
                    if (!it.exists()) continue;
                    v4 = element$iv;
                    break block8;
                }
                v4 = null;
            }
            File contentFile = v4;
            node.setSource(contentFile != null ? (JsLocationWithSource)new JsLocationWithEmbeddedSource(deserializedLocation, null, (Function0<? extends Reader>)new Function0<InputStreamReader>(contentFile){
                final /* synthetic */ File $contentFile;

                @NotNull
                public final InputStreamReader invoke() {
                    return new InputStreamReader((InputStream)new FileInputStream(this.$contentFile), "UTF-8");
                }
                {
                    this.$contentFile = file;
                    super(0);
                }
            }) : (JsLocationWithSource)deserializedLocation);
        }
        if (shouldUpdateFile) {
            this.fileStack.pop();
        }
        return (T)node;
    }

    public JsAstDeserializer(@NotNull JsProgram program, @NotNull Iterable<? extends File> sourceRoots) {
        List list2;
        Intrinsics.checkParameterIsNotNull(program, "program");
        Intrinsics.checkParameterIsNotNull(sourceRoots, "sourceRoots");
        this.sourceRoots = sourceRoots;
        this.scope = new JsRootScope(program);
        JsAstDeserializer jsAstDeserializer = this;
        jsAstDeserializer.stringTable = list2 = (List)new ArrayList();
        jsAstDeserializer = this;
        jsAstDeserializer.nameTable = list2 = (List)new ArrayList();
        jsAstDeserializer = this;
        jsAstDeserializer.nameCache = list2 = (List)new ArrayList();
        this.fileStack = new ArrayDeque();
    }

    @NotNull
    public static final /* synthetic */ JsStatement access$deserializeNoMetadata(JsAstDeserializer $this, @NotNull JsAstProtoBuf.Statement proto) {
        return $this.deserializeNoMetadata(proto);
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$deserializeNoMetadata(JsAstDeserializer $this, @NotNull JsAstProtoBuf.Expression proto) {
        return $this.deserializeNoMetadata(proto);
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$deserialize(JsAstDeserializer $this, @NotNull JsAstProtoBuf.Expression proto) {
        return $this.deserialize(proto);
    }

    @NotNull
    public static final /* synthetic */ JsName access$deserializeName(JsAstDeserializer $this, int id) {
        return $this.deserializeName(id);
    }
}

