/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import java.util.Map;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryMetaDataCache;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryModuleComponentRepositoryCaches;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

class InMemoryCachedModuleComponentRepository
extends BaseModuleComponentRepository {
    private final ModuleComponentRepositoryAccess localAccess;
    private final ModuleComponentRepositoryAccess remoteAccess;
    private final Map<ComponentArtifactIdentifier, ResolvableArtifact> resolvedArtifactsCache;

    public InMemoryCachedModuleComponentRepository(InMemoryModuleComponentRepositoryCaches cache, ModuleComponentRepository delegate) {
        super(delegate);
        this.localAccess = new CachedAccess(delegate.getLocalAccess(), cache.localArtifactsCache, cache.localMetaDataCache);
        this.remoteAccess = new CachedAccess(delegate.getRemoteAccess(), cache.remoteArtifactsCache, cache.remoteMetaDataCache);
        this.resolvedArtifactsCache = cache.resolvedArtifactsCache;
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.localAccess;
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remoteAccess;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        return this.resolvedArtifactsCache;
    }

    private class CachedAccess
    extends BaseModuleComponentRepositoryAccess {
        private final InMemoryMetaDataCache metaDataCache;
        private final InMemoryArtifactsCache artifactsCache;

        CachedAccess(ModuleComponentRepositoryAccess access, InMemoryArtifactsCache artifactsCache, InMemoryMetaDataCache metaDataCache) {
            super(access);
            this.artifactsCache = artifactsCache;
            this.metaDataCache = metaDataCache;
        }

        public String toString() {
            return "in-memory cache > " + this.getDelegate().toString();
        }

        @Override
        public void listModuleVersions(DependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            if (!this.metaDataCache.supplyModuleVersions(dependency.getRequested(), result)) {
                super.listModuleVersions(dependency, result);
                this.metaDataCache.newModuleVersions(dependency.getRequested(), result);
            }
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            if (!this.metaDataCache.supplyMetaData(moduleComponentIdentifier, result)) {
                super.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
                this.metaDataCache.newDependencyResult(moduleComponentIdentifier, result);
                if (result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
                    this.metaDataCache.cacheFetchingCost(moduleComponentIdentifier, MetadataFetchingCost.FAST);
                } else {
                    this.metaDataCache.cacheFetchingCost(moduleComponentIdentifier, MetadataFetchingCost.CHEAP);
                }
            }
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            if (!this.artifactsCache.supplyArtifacts(component.getComponentId(), result)) {
                super.resolveArtifacts(component, result);
                this.artifactsCache.newArtifacts(component.getComponentId(), result);
            }
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            if (!this.artifactsCache.supplyArtifacts(component.getComponentId(), artifactType, result)) {
                super.resolveArtifactsWithType(component, artifactType, result);
                this.artifactsCache.newArtifacts(component.getComponentId(), artifactType, result);
            }
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            if (!this.artifactsCache.supplyArtifact(artifact.getId(), result)) {
                super.resolveArtifact(artifact, moduleSource, result);
                this.artifactsCache.newArtifact(artifact.getId(), result);
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(final ModuleComponentIdentifier moduleComponentIdentifier) {
            return this.metaDataCache.getOrCacheFetchingCost(moduleComponentIdentifier, new Factory<MetadataFetchingCost>(){

                public MetadataFetchingCost create() {
                    return CachedAccess.super.estimateMetadataFetchingCost(moduleComponentIdentifier);
                }
            });
        }
    }
}

