/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.ResolveContextToComponentResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.ComponentResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final ConflictHandler conflictHandler;
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final ResolveContextToComponentResolver moduleResolver;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final AttributesSchemaInternal attributesSchema;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ModuleExclusions moduleExclusions;
    private final BuildOperationExecutor buildOperationExecutor;

    public DependencyGraphBuilder(DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ResolveContextToComponentResolver resolveContextToComponentResolver, ConflictHandler conflictHandler, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ModuleExclusions moduleExclusions, BuildOperationExecutor buildOperationExecutor) {
        this.idResolver = componentIdResolver;
        this.metaDataResolver = componentMetaDataResolver;
        this.moduleResolver = resolveContextToComponentResolver;
        this.conflictHandler = conflictHandler;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.moduleExclusions = moduleExclusions;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public void resolve(ResolveContext resolveContext, DependencyGraphVisitor modelVisitor) {
        LongIdGenerator idGenerator = new LongIdGenerator();
        DefaultBuildableComponentResolveResult rootModule = new DefaultBuildableComponentResolveResult();
        this.moduleResolver.resolve(resolveContext, rootModule);
        ResolveState resolveState = new ResolveState((IdGenerator<Long>)idGenerator, rootModule, resolveContext.getName(), this.idResolver, this.metaDataResolver, this.edgeFilter, this.attributesSchema, this.moduleIdentifierFactory, this.moduleExclusions);
        this.conflictHandler.registerResolver(new DirectDependencyForcingResolver(((ResolveState)resolveState).root.component));
        this.traverseGraph(resolveState);
        ((ResolveState)resolveState).root.component.setSelectionReason(VersionSelectionReasons.ROOT);
        this.assembleResult(resolveState, modelVisitor);
    }

    private void traverseGraph(final ResolveState resolveState) {
        resolveState.onMoreSelected(resolveState.root);
        ArrayList dependencies = Lists.newArrayList();
        ArrayList dependenciesMissingLocalMetadata = Lists.newArrayList();
        HashMap componentIdentifierCache = Maps.newHashMap();
        while (resolveState.peek() != null || this.conflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                NodeState node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                dependencies.clear();
                dependenciesMissingLocalMetadata.clear();
                node.visitOutgoingDependencies(dependencies);
                this.resolveEdges(node, dependencies, dependenciesMissingLocalMetadata, resolveState, componentIdentifierCache);
                continue;
            }
            this.conflictHandler.resolveNextConflict(new Action<ConflictResolutionResult>(){

                public void execute(final ConflictResolutionResult result) {
                    result.getConflict().withParticipatingModules(new Action<ModuleIdentifier>(){

                        public void execute(ModuleIdentifier moduleIdentifier) {
                            ComponentState selected = (ComponentState)result.getSelected();
                            resolveState.getModule(moduleIdentifier).restart(selected);
                        }
                    });
                }
            });
        }
    }

    private void performSelection(final ResolveState resolveState, ComponentState moduleRevision) {
        ModuleIdentifier moduleId = moduleRevision.id.getModule();
        if (moduleRevision.state == ModuleState.New) {
            ModuleResolveState module = resolveState.getModule(moduleId);
            PotentialConflict c = this.conflictHandler.registerModule(module);
            if (!c.conflictExists()) {
                LOGGER.debug("Selecting new module version {}", (Object)moduleRevision);
                module.select(moduleRevision);
            } else {
                LOGGER.debug("Found new conflicting module version {}", (Object)moduleRevision);
                c.withParticipatingModules(new Action<ModuleIdentifier>(){

                    public void execute(ModuleIdentifier module) {
                        ComponentState previouslySelected = resolveState.getModule(module).clearSelection();
                        if (previouslySelected != null) {
                            for (NodeState configuration : previouslySelected.nodes) {
                                configuration.deselect();
                            }
                        }
                    }
                });
            }
        }
    }

    private void resolveEdges(NodeState node, List<EdgeState> dependencies, List<EdgeState> dependenciesMissingMetadataLocally, ResolveState resolveState, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        if (dependencies.isEmpty()) {
            return;
        }
        this.performSelectionSerially(dependencies, resolveState);
        this.computePreemptiveDownloadList(dependencies, dependenciesMissingMetadataLocally, componentIdentifierCache);
        this.downloadMetadataConcurrently(node, dependenciesMissingMetadataLocally);
        this.attachToTargetRevisionsSerially(dependencies);
    }

    private void attachToTargetRevisionsSerially(List<EdgeState> dependencies) {
        for (EdgeState dependency : dependencies) {
            if (dependency.targetModuleRevision == null || dependency.targetModuleRevision.state != ModuleState.Selected) continue;
            dependency.attachToTargetConfigurations();
        }
    }

    private void downloadMetadataConcurrently(NodeState node, final List<EdgeState> dependencies) {
        if (dependencies.isEmpty()) {
            return;
        }
        LOGGER.debug("Submitting {} metadata files to resolve in parallel for {}", (Object)dependencies.size(), (Object)node);
        this.buildOperationExecutor.runAll((Action)new Action<BuildOperationQueue<RunnableBuildOperation>>(){

            public void execute(BuildOperationQueue<RunnableBuildOperation> buildOperationQueue) {
                for (EdgeState dependency : dependencies) {
                    buildOperationQueue.add((BuildOperation)new DownloadMetadataOperation(dependency.targetModuleRevision));
                }
            }
        });
    }

    private void performSelectionSerially(List<EdgeState> dependencies, ResolveState resolveState) {
        for (EdgeState dependency : dependencies) {
            ComponentState moduleRevision = dependency.resolveModuleRevisionId();
            if (moduleRevision == null) continue;
            this.performSelection(resolveState, moduleRevision);
        }
    }

    private void computePreemptiveDownloadList(List<EdgeState> dependencies, List<EdgeState> dependenciesToBeResolvedInParallel, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        for (EdgeState dependency : dependencies) {
            ComponentState state = dependency.targetModuleRevision;
            if (state == null || state.fastResolve() || !DependencyGraphBuilder.performPreemptiveDownload(state.state) || this.metaDataResolver.isFetchingMetadataCheap(DependencyGraphBuilder.toComponentId(state.getId(), componentIdentifierCache))) continue;
            dependenciesToBeResolvedInParallel.add(dependency);
        }
        if (dependenciesToBeResolvedInParallel.size() == 1) {
            dependenciesToBeResolvedInParallel.clear();
        }
    }

    private static ComponentIdentifier toComponentId(ModuleVersionIdentifier id, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        ComponentIdentifier identifier = componentIdentifierCache.get(id);
        if (identifier == null) {
            identifier = DefaultModuleComponentIdentifier.newId(id);
            componentIdentifierCache.put(id, identifier);
        }
        return identifier;
    }

    private static boolean performPreemptiveDownload(ModuleState state) {
        return state == ModuleState.Selected;
    }

    private void assembleResult(ResolveState resolveState, DependencyGraphVisitor visitor) {
        visitor.start(resolveState.root);
        for (DependencyGraphSelector dependencyGraphSelector : resolveState.getSelectors()) {
            visitor.visitSelector(dependencyGraphSelector);
        }
        for (NodeState nodeState : resolveState.getNodes()) {
            if (!nodeState.isSelected()) continue;
            visitor.visitNode(nodeState);
        }
        ArrayList<ComponentState> queue = new ArrayList<ComponentState>();
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null) continue;
            queue.add(module.getSelected());
        }
        while (!queue.isEmpty()) {
            ComponentState componentState = (ComponentState)queue.get(0);
            if (componentState.getVisitState() == VisitState.NotSeen) {
                componentState.setVisitState(VisitState.Visting);
                int pos = 0;
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    for (EdgeState edge : node.getIncomingEdges()) {
                        ComponentState owner = edge.getFrom().getOwner();
                        if (owner.getVisitState() != VisitState.NotSeen) continue;
                        queue.add(pos, owner);
                        ++pos;
                    }
                }
                if (pos != 0) continue;
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            if (componentState.getVisitState() == VisitState.Visting) {
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            queue.remove(0);
        }
        visitor.finish(resolveState.root);
    }

    private static class DownloadMetadataOperation
    implements RunnableBuildOperation {
        private final ComponentState state;

        DownloadMetadataOperation(ComponentState state) {
            this.state = state;
        }

        public void run(BuildOperationContext context) {
            this.state.getMetaData();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Resolve " + this.state));
        }
    }

    private static class DirectDependencyForcingResolver
    implements ModuleConflictResolver {
        private final ComponentState root;

        private DirectDependencyForcingResolver(ComponentState root) {
            this.root = root;
        }

        @Override
        public <T extends ComponentResolutionState> T select(Collection<? extends T> candidates) {
            for (NodeState configuration : this.root.nodes) {
                for (EdgeState outgoingEdge : configuration.outgoingEdges) {
                    if (!outgoingEdge.dependencyMetadata.isForce() || !candidates.contains(outgoingEdge.targetModuleRevision)) continue;
                    outgoingEdge.targetModuleRevision.selectionReason = VersionSelectionReasons.FORCED;
                    return (T)outgoingEdge.targetModuleRevision;
                }
            }
            return null;
        }
    }

    private static class SelectorState
    implements DependencyGraphSelector {
        final Long id;
        final DependencyMetadata dependencyMetadata;
        final DependencyToComponentIdResolver resolver;
        final ResolveState resolveState;
        ModuleVersionResolveException failure;
        ModuleResolveState targetModule;
        ComponentState selected;
        BuildableComponentIdResolveResult idResolveResult;

        private SelectorState(Long id, DependencyMetadata dependencyMetadata, DependencyToComponentIdResolver resolver, ResolveState resolveState) {
            this.id = id;
            this.dependencyMetadata = dependencyMetadata;
            this.resolver = resolver;
            this.resolveState = resolveState;
            this.targetModule = resolveState.getModule(resolveState.moduleIdentifierFactory.module(dependencyMetadata.getRequested().getGroup(), dependencyMetadata.getRequested().getName()));
        }

        @Override
        public Long getResultId() {
            return this.id;
        }

        public String toString() {
            return this.dependencyMetadata.toString();
        }

        @Override
        public ComponentSelector getRequested() {
            return this.dependencyMetadata.getSelector();
        }

        private ModuleVersionResolveException getFailure() {
            return this.failure != null ? this.failure : this.selected.getFailure();
        }

        public ComponentSelectionReason getSelectionReason() {
            return this.selected == null ? this.idResolveResult.getSelectionReason() : this.selected.getSelectionReason();
        }

        public ComponentState getSelected() {
            return this.targetModule.selected;
        }

        public ModuleResolveState getSelectedModule() {
            return this.targetModule;
        }

        public ComponentState resolveModuleRevisionId() {
            if (this.selected != null) {
                return this.selected;
            }
            if (this.failure != null) {
                return null;
            }
            this.idResolveResult = new DefaultBuildableComponentIdResolveResult();
            this.resolver.resolve(this.dependencyMetadata, this.idResolveResult);
            if (this.idResolveResult.getFailure() != null) {
                this.failure = this.idResolveResult.getFailure();
                return null;
            }
            this.selected = this.resolveState.getRevision(this.idResolveResult.getModuleVersionId());
            this.selected.addResolver(this);
            this.selected.selectionReason = this.idResolveResult.getSelectionReason();
            this.targetModule = this.selected.module;
            this.targetModule.addSelector(this);
            return this.selected;
        }

        public void restart(ComponentState moduleRevision) {
            this.selected = moduleRevision;
            this.targetModule = moduleRevision.module;
        }
    }

    private static class RootNode
    extends NodeState {
        private RootNode(Long resultId, ComponentState moduleRevision, ResolvedConfigurationIdentifier id, ResolveState resolveState) {
            super(resultId, id, moduleRevision, resolveState);
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
            return ((LocalConfigurationMetadata)this.getMetadata()).getFiles();
        }

        @Override
        public boolean isSelected() {
            return true;
        }

        @Override
        public void deselect() {
        }
    }

    static class NodeState
    implements DependencyGraphNode {
        private final Long resultId;
        public final ComponentState component;
        public final Set<EdgeState> incomingEdges = new LinkedHashSet<EdgeState>();
        public final Set<EdgeState> outgoingEdges = new LinkedHashSet<EdgeState>();
        public final ResolvedConfigurationIdentifier id;
        private final ConfigurationMetadata metaData;
        private final ResolveState resolveState;
        private ModuleExclusion previousTraversalExclusions;

        private NodeState(Long resultId, ResolvedConfigurationIdentifier id, ComponentState component, ResolveState resolveState) {
            this(resultId, id, component, resolveState, component.metaData.getConfiguration(id.getConfiguration()));
        }

        private NodeState(Long resultId, ResolvedConfigurationIdentifier id, ComponentState component, ResolveState resolveState, ConfigurationMetadata md) {
            this.resultId = resultId;
            this.id = id;
            this.component = component;
            this.resolveState = resolveState;
            this.metaData = md;
            component.addConfiguration(this);
        }

        @Override
        public Long getNodeId() {
            return this.resultId;
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public ResolvedConfigurationIdentifier getResolvedConfigurationId() {
            return this.id;
        }

        @Override
        public ComponentState getOwner() {
            return this.component;
        }

        public Set<EdgeState> getIncomingEdges() {
            return this.incomingEdges;
        }

        public Set<EdgeState> getOutgoingEdges() {
            return this.outgoingEdges;
        }

        @Override
        public ConfigurationMetadata getMetadata() {
            return this.metaData;
        }

        @Override
        public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
            if (this.metaData instanceof LocalConfigurationMetadata) {
                for (EdgeState incomingEdge : this.incomingEdges) {
                    if (!incomingEdge.isTransitive()) continue;
                    return ((LocalConfigurationMetadata)this.metaData).getFiles();
                }
            }
            return Collections.emptySet();
        }

        public String toString() {
            return String.format("%s(%s)", this.component, this.id.getConfiguration());
        }

        public boolean isTransitive() {
            return this.metaData.isTransitive();
        }

        public void visitOutgoingDependencies(Collection<EdgeState> target) {
            if (this.component.state != ModuleState.Selected) {
                LOGGER.debug("version for {} is not selected. ignoring.", (Object)this);
                return;
            }
            boolean hasIncomingEdges = !this.incomingEdges.isEmpty();
            ArrayList<EdgeState> transitiveIncoming = hasIncomingEdges ? new ArrayList<EdgeState>() : Collections.emptyList();
            for (EdgeState edge : this.incomingEdges) {
                if (!edge.isTransitive()) continue;
                transitiveIncoming.add(edge);
            }
            if (transitiveIncoming.isEmpty() && this != this.resolveState.root) {
                if (this.previousTraversalExclusions != null) {
                    this.removeOutgoingEdges();
                }
                if (hasIncomingEdges) {
                    LOGGER.debug("{} has no transitive incoming edges. ignoring outgoing edges.", (Object)this);
                } else {
                    LOGGER.debug("{} has no incoming edges. ignoring.", (Object)this);
                }
                return;
            }
            ModuleExclusion resolutionFilter = this.getModuleResolutionFilter(transitiveIncoming);
            if (this.previousTraversalExclusions != null) {
                if (this.previousTraversalExclusions.excludesSameModulesAs(resolutionFilter)) {
                    LOGGER.debug("Changed edges for {} selects same versions as previous traversal. ignoring", (Object)this);
                    this.previousTraversalExclusions = resolutionFilter;
                    return;
                }
                this.removeOutgoingEdges();
            }
            for (DependencyMetadata dependencyMetadata : this.metaData.getDependencies()) {
                if (this.isExcluded(resolutionFilter, dependencyMetadata)) continue;
                EdgeState dependencyEdge = new EdgeState(this, dependencyMetadata, resolutionFilter, this.resolveState);
                this.outgoingEdges.add(dependencyEdge);
                target.add(dependencyEdge);
            }
            this.previousTraversalExclusions = resolutionFilter;
        }

        private boolean isExcluded(ModuleExclusion selector, DependencyMetadata dependency) {
            if (!this.resolveState.edgeFilter.isSatisfiedBy((Object)dependency)) {
                LOGGER.debug("{} is filtered.", (Object)dependency);
                return true;
            }
            ModuleIdentifier targetModuleId = this.resolveState.moduleIdentifierFactory.module(dependency.getRequested().getGroup(), dependency.getRequested().getName());
            if (selector.excludeModule(targetModuleId)) {
                LOGGER.debug("{} is excluded from {}.", (Object)targetModuleId, (Object)this);
                return true;
            }
            return false;
        }

        public void addIncomingEdge(EdgeState dependencyEdge) {
            this.incomingEdges.add(dependencyEdge);
            this.resolveState.onMoreSelected(this);
        }

        public void removeIncomingEdge(EdgeState dependencyEdge) {
            this.incomingEdges.remove(dependencyEdge);
            this.resolveState.onFewerSelected(this);
        }

        public boolean isSelected() {
            return !this.incomingEdges.isEmpty();
        }

        private ModuleExclusion getModuleResolutionFilter(List<EdgeState> transitiveEdges) {
            ModuleExclusion resolutionFilter;
            ModuleExclusions moduleExclusions = this.resolveState.moduleExclusions;
            if (transitiveEdges.isEmpty()) {
                resolutionFilter = ModuleExclusions.excludeNone();
            } else {
                resolutionFilter = transitiveEdges.get(0).getExclusions(moduleExclusions);
                for (int i = 1; i < transitiveEdges.size(); ++i) {
                    EdgeState dependencyEdge = transitiveEdges.get(i);
                    resolutionFilter = moduleExclusions.union(resolutionFilter, dependencyEdge.getExclusions(moduleExclusions));
                }
            }
            resolutionFilter = moduleExclusions.intersect(resolutionFilter, this.metaData.getExclusions(moduleExclusions));
            return resolutionFilter;
        }

        public void removeOutgoingEdges() {
            for (EdgeState outgoingDependency : this.outgoingEdges) {
                outgoingDependency.removeFromTargetConfigurations();
            }
            this.outgoingEdges.clear();
            this.previousTraversalExclusions = null;
        }

        public void restart(ComponentState selected) {
            if (this.component == selected) {
                this.resolveState.onMoreSelected(this);
            } else {
                for (EdgeState dependency : new ArrayList<EdgeState>(this.incomingEdges)) {
                    dependency.restart(selected);
                }
                this.incomingEdges.clear();
            }
        }

        public void deselect() {
            this.removeOutgoingEdges();
        }
    }

    static enum VisitState {
        NotSeen,
        Visting,
        Visited;

    }

    public static class ComponentState
    implements ComponentResolutionState,
    ComponentResult,
    DependencyGraphComponent {
        public final ModuleVersionIdentifier id;
        private final ComponentMetaDataResolver resolver;
        private final Set<NodeState> nodes = new LinkedHashSet<NodeState>();
        private final Long resultId;
        private final ModuleResolveState module;
        private volatile ComponentResolveMetadata metaData;
        private ModuleState state = ModuleState.New;
        private ComponentSelectionReason selectionReason = VersionSelectionReasons.REQUESTED;
        private ModuleVersionResolveException failure;
        private SelectorState firstReference;
        private VisitState visitState = VisitState.NotSeen;

        private ComponentState(Long resultId, ModuleResolveState module, ModuleVersionIdentifier id, ComponentMetaDataResolver resolver) {
            this.resultId = resultId;
            this.module = module;
            this.id = id;
            this.resolver = resolver;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public String getVersion() {
            return this.id.getVersion();
        }

        @Override
        public Long getResultId() {
            return this.resultId;
        }

        @Override
        public ModuleVersionIdentifier getId() {
            return this.id;
        }

        @Override
        public ModuleVersionIdentifier getModuleVersion() {
            return this.id;
        }

        public ModuleVersionResolveException getFailure() {
            return this.failure;
        }

        public VisitState getVisitState() {
            return this.visitState;
        }

        public void setVisitState(VisitState visitState) {
            this.visitState = visitState;
        }

        public Set<NodeState> getNodes() {
            return this.nodes;
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metaData;
        }

        public void restart(ComponentState selected) {
            for (NodeState configuration : this.nodes) {
                configuration.restart(selected);
            }
        }

        public void addResolver(SelectorState resolver) {
            if (this.firstReference == null) {
                this.firstReference = resolver;
            }
        }

        public boolean fastResolve() {
            if (this.metaData != null || this.failure != null) {
                return true;
            }
            BuildableComponentIdResolveResult idResolveResult = this.firstReference.idResolveResult;
            if (idResolveResult.getFailure() != null) {
                this.failure = idResolveResult.getFailure();
                return true;
            }
            if (idResolveResult.getMetaData() != null) {
                this.metaData = idResolveResult.getMetaData();
                return true;
            }
            return false;
        }

        public void resolve() {
            if (this.fastResolve()) {
                return;
            }
            BuildableComponentIdResolveResult idResolveResult = this.firstReference.idResolveResult;
            DefaultBuildableComponentResolveResult result = new DefaultBuildableComponentResolveResult();
            this.resolver.resolve(idResolveResult.getId(), DefaultComponentOverrideMetadata.forDependency(this.firstReference.dependencyMetadata), result);
            if (result.getFailure() != null) {
                this.failure = result.getFailure();
                return;
            }
            this.metaData = result.getMetaData();
        }

        @Override
        public ComponentResolveMetadata getMetaData() {
            if (this.metaData == null) {
                this.resolve();
            }
            return this.metaData;
        }

        public void setMetaData(ComponentResolveMetadata metaData) {
            this.metaData = metaData;
            this.failure = null;
        }

        public void addConfiguration(NodeState node) {
            this.nodes.add(node);
        }

        @Override
        public ComponentSelectionReason getSelectionReason() {
            return this.selectionReason;
        }

        @Override
        public void setSelectionReason(ComponentSelectionReason reason) {
            this.selectionReason = reason;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return this.getMetaData().getComponentId();
        }

        public Set<ComponentState> getDependents() {
            LinkedHashSet<ComponentState> incoming = new LinkedHashSet<ComponentState>();
            for (NodeState configuration : this.nodes) {
                for (EdgeState dependencyEdge : configuration.incomingEdges) {
                    incoming.add(dependencyEdge.from.component);
                }
            }
            return incoming;
        }
    }

    private static class ModuleResolveState
    implements CandidateModule {
        final ComponentMetaDataResolver metaDataResolver;
        final IdGenerator<Long> idGenerator;
        final ModuleIdentifier id;
        final Set<EdgeState> unattachedDependencies = new LinkedHashSet<EdgeState>();
        final Map<ModuleVersionIdentifier, ComponentState> versions = new LinkedHashMap<ModuleVersionIdentifier, ComponentState>();
        final Set<SelectorState> selectors = new HashSet<SelectorState>();
        final ResolveState resolveState;
        ComponentState selected;

        private ModuleResolveState(IdGenerator<Long> idGenerator, ModuleIdentifier id, ResolveState resolveState, ComponentMetaDataResolver metaDataResolver) {
            this.idGenerator = idGenerator;
            this.id = id;
            this.resolveState = resolveState;
            this.metaDataResolver = metaDataResolver;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public ModuleIdentifier getId() {
            return this.id;
        }

        public Collection<ComponentState> getVersions() {
            return this.versions.values();
        }

        public ComponentState getSelected() {
            return this.selected;
        }

        public void select(ComponentState selected) {
            assert (this.selected == null);
            this.selected = selected;
            for (ComponentState version : this.versions.values()) {
                version.state = ModuleState.Evicted;
            }
            selected.state = ModuleState.Selected;
        }

        public ComponentState clearSelection() {
            ComponentState previousSelection = this.selected;
            this.selected = null;
            for (ComponentState version : this.versions.values()) {
                version.state = ModuleState.Conflict;
            }
            return previousSelection;
        }

        public void restart(ComponentState selected) {
            this.select(selected);
            for (ComponentState version : this.versions.values()) {
                version.restart(selected);
            }
            for (SelectorState selector : this.selectors) {
                selector.restart(selected);
            }
            for (EdgeState dependency : new ArrayList<EdgeState>(this.unattachedDependencies)) {
                dependency.restart(selected);
            }
            this.unattachedDependencies.clear();
        }

        public void addUnattachedDependency(EdgeState edge) {
            this.unattachedDependencies.add(edge);
        }

        public void removeUnattachedDependency(EdgeState edge) {
            this.unattachedDependencies.remove(edge);
        }

        public ComponentState getVersion(ModuleVersionIdentifier id) {
            ComponentState moduleRevision = this.versions.get(id);
            if (moduleRevision == null) {
                moduleRevision = new ComponentState((Long)this.idGenerator.generateId(), this, id, this.metaDataResolver);
                this.versions.put(id, moduleRevision);
            }
            return moduleRevision;
        }

        public void addSelector(SelectorState selector) {
            this.selectors.add(selector);
        }
    }

    static enum ModuleState {
        New,
        Selected,
        Conflict,
        Evicted;

    }

    private static class ResolveState {
        private final Spec<? super DependencyMetadata> edgeFilter;
        private final Map<ModuleIdentifier, ModuleResolveState> modules = new LinkedHashMap<ModuleIdentifier, ModuleResolveState>();
        private final Map<ResolvedConfigurationIdentifier, NodeState> nodes = new LinkedHashMap<ResolvedConfigurationIdentifier, NodeState>();
        private final Map<ModuleVersionSelector, SelectorState> selectors = new LinkedHashMap<ModuleVersionSelector, SelectorState>();
        private final RootNode root;
        private final IdGenerator<Long> idGenerator;
        private final DependencyToComponentIdResolver idResolver;
        private final ComponentMetaDataResolver metaDataResolver;
        private final Set<NodeState> queued = Sets.newHashSet();
        private final LinkedList<NodeState> queue = new LinkedList();
        private final AttributesSchemaInternal attributesSchema;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final ModuleExclusions moduleExclusions;

        public ResolveState(IdGenerator<Long> idGenerator, ComponentResolveResult rootResult, String rootConfigurationName, DependencyToComponentIdResolver idResolver, ComponentMetaDataResolver metaDataResolver, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ModuleExclusions moduleExclusions) {
            this.idGenerator = idGenerator;
            this.idResolver = idResolver;
            this.metaDataResolver = metaDataResolver;
            this.edgeFilter = edgeFilter;
            this.attributesSchema = attributesSchema;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.moduleExclusions = moduleExclusions;
            ComponentState rootVersion = this.getRevision(rootResult.getId());
            rootVersion.setMetaData(rootResult.getMetaData());
            this.root = new RootNode((Long)idGenerator.generateId(), rootVersion, new ResolvedConfigurationIdentifier(rootVersion.id, rootConfigurationName), this);
            this.nodes.put(this.root.id, this.root);
            this.root.component.module.select(this.root.component);
        }

        public Collection<ModuleResolveState> getModules() {
            return this.modules.values();
        }

        public ModuleResolveState getModule(ModuleIdentifier id) {
            ModuleResolveState module = this.modules.get(id);
            if (module == null) {
                module = new ModuleResolveState(this.idGenerator, id, this, this.metaDataResolver);
                this.modules.put(id, module);
            }
            return module;
        }

        public ComponentState getRevision(ModuleVersionIdentifier id) {
            return this.getModule(id.getModule()).getVersion(id);
        }

        public Collection<NodeState> getNodes() {
            return this.nodes.values();
        }

        public NodeState getNode(ComponentState module, ConfigurationMetadata configurationMetadata) {
            ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(module.id, configurationMetadata.getName());
            NodeState configuration = this.nodes.get(id);
            if (configuration == null) {
                configuration = new NodeState((Long)this.idGenerator.generateId(), id, module, this, configurationMetadata);
                this.nodes.put(id, configuration);
            }
            return configuration;
        }

        public Collection<SelectorState> getSelectors() {
            return this.selectors.values();
        }

        public SelectorState getSelector(DependencyMetadata dependencyMetadata) {
            ModuleVersionSelector requested = dependencyMetadata.getRequested();
            SelectorState resolveState = this.selectors.get(requested);
            if (resolveState == null) {
                resolveState = new SelectorState((Long)this.idGenerator.generateId(), dependencyMetadata, this.idResolver, this);
                this.selectors.put(requested, resolveState);
            }
            return resolveState;
        }

        public NodeState peek() {
            return this.queue.isEmpty() ? null : this.queue.getFirst();
        }

        public NodeState pop() {
            NodeState next = this.queue.removeFirst();
            this.queued.remove(next);
            return next;
        }

        public void onMoreSelected(NodeState node) {
            if (this.queued.add(node)) {
                this.queue.addLast(node);
            }
        }

        public void onFewerSelected(NodeState node) {
            if (this.queued.add(node)) {
                this.queue.addFirst(node);
            }
        }

        public AttributesSchemaInternal getAttributesSchema() {
            return this.attributesSchema;
        }
    }

    private static class EdgeState
    implements DependencyGraphEdge {
        public final NodeState from;
        public final SelectorState selector;
        private final DependencyMetadata dependencyMetadata;
        private final ResolveState resolveState;
        private final ModuleExclusion moduleExclusion;
        private final Set<NodeState> targetNodes = new LinkedHashSet<NodeState>();
        private ComponentState targetModuleRevision;
        private ModuleVersionResolveException targetNodeSelectionFailure;

        EdgeState(NodeState from, DependencyMetadata dependencyMetadata, ModuleExclusion moduleExclusion, ResolveState resolveState) {
            this.from = from;
            this.dependencyMetadata = dependencyMetadata;
            this.moduleExclusion = moduleExclusion;
            this.resolveState = resolveState;
            this.selector = resolveState.getSelector(dependencyMetadata);
        }

        public String toString() {
            return String.format("%s -> %s", this.from.toString(), this.dependencyMetadata);
        }

        @Override
        public NodeState getFrom() {
            return this.from;
        }

        @Override
        public DependencyGraphSelector getSelector() {
            return this.selector;
        }

        public ComponentState resolveModuleRevisionId() {
            if (this.targetModuleRevision == null) {
                this.targetModuleRevision = this.selector.resolveModuleRevisionId();
                this.selector.getSelectedModule().addUnattachedDependency(this);
            }
            return this.targetModuleRevision;
        }

        public boolean isTransitive() {
            return this.from.isTransitive() && this.dependencyMetadata.isTransitive();
        }

        public void attachToTargetConfigurations() {
            if (this.targetModuleRevision.state != ModuleState.Selected) {
                return;
            }
            this.calculateTargetConfigurations();
            for (NodeState targetConfiguration : this.targetNodes) {
                targetConfiguration.addIncomingEdge(this);
            }
            if (!this.targetNodes.isEmpty()) {
                this.selector.getSelectedModule().removeUnattachedDependency(this);
            }
        }

        public void removeFromTargetConfigurations() {
            for (NodeState targetConfiguration : this.targetNodes) {
                targetConfiguration.removeIncomingEdge(this);
            }
            this.targetNodes.clear();
            this.targetNodeSelectionFailure = null;
            if (this.targetModuleRevision != null) {
                this.selector.getSelectedModule().removeUnattachedDependency(this);
            }
        }

        public void restart(ComponentState selected) {
            this.removeFromTargetConfigurations();
            this.targetModuleRevision = selected;
            this.attachToTargetConfigurations();
        }

        private void calculateTargetConfigurations() {
            Set<ConfigurationMetadata> targetConfigurations;
            this.targetNodes.clear();
            this.targetNodeSelectionFailure = null;
            ComponentResolveMetadata targetModuleVersion = this.targetModuleRevision.getMetaData();
            if (targetModuleVersion == null) {
                return;
            }
            try {
                targetConfigurations = this.dependencyMetadata.selectConfigurations(this.from.component.metaData, this.from.metaData, targetModuleVersion, this.resolveState.getAttributesSchema());
            }
            catch (Throwable t) {
                this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyMetadata.getSelector(), t);
                return;
            }
            for (ConfigurationMetadata targetConfiguration : targetConfigurations) {
                NodeState targetNodeState = this.resolveState.getNode(this.targetModuleRevision, targetConfiguration);
                this.targetNodes.add(targetNodeState);
            }
        }

        public ModuleExclusion toExclusions(DependencyMetadata md, ConfigurationMetadata from) {
            List<Exclude> excludes = md.getExcludes(from.getHierarchy());
            if (excludes.isEmpty()) {
                return ModuleExclusions.excludeNone();
            }
            return this.resolveState.moduleExclusions.excludeAny(excludes);
        }

        @Override
        public ModuleExclusion getExclusions(ModuleExclusions moduleExclusions) {
            ModuleExclusion edgeExclusions = this.toExclusions(this.dependencyMetadata, this.from.metaData);
            return this.resolveState.moduleExclusions.intersect(edgeExclusions, this.moduleExclusion);
        }

        @Override
        public ComponentSelector getRequested() {
            return this.dependencyMetadata.getSelector();
        }

        @Override
        public ModuleVersionSelector getRequestedModuleVersion() {
            return this.dependencyMetadata.getRequested();
        }

        @Override
        public ModuleVersionResolveException getFailure() {
            if (this.targetNodeSelectionFailure != null) {
                return this.targetNodeSelectionFailure;
            }
            return this.selector.getFailure();
        }

        @Override
        public Long getSelected() {
            return this.selector.getSelected().getResultId();
        }

        @Override
        public ComponentSelectionReason getReason() {
            return this.selector.getSelectionReason();
        }

        @Override
        public ModuleDependency getModuleDependency() {
            if (this.dependencyMetadata instanceof DslOriginDependencyMetadata) {
                return ((DslOriginDependencyMetadata)this.dependencyMetadata).getSource();
            }
            return null;
        }

        @Override
        public Iterable<? extends DependencyGraphNode> getTargets() {
            return this.targetNodes;
        }

        @Override
        public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata metaData1) {
            return this.dependencyMetadata.getArtifacts(this.from.metaData, metaData1);
        }
    }
}

