/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionPatternVisitor;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;

public class ChainedVersionLister
implements VersionLister {
    private final List<VersionLister> versionListers;

    public ChainedVersionLister(VersionLister ... delegates) {
        this.versionListers = Arrays.asList(delegates);
    }

    @Override
    public VersionPatternVisitor newVisitor(final ModuleIdentifier module, Collection<String> dest, ResourceAwareResolveResult result) {
        final ArrayList<VersionPatternVisitor> visitors = new ArrayList<VersionPatternVisitor>();
        for (VersionLister lister : this.versionListers) {
            visitors.add(lister.newVisitor(module, dest, result));
        }
        return new VersionPatternVisitor(){

            @Override
            public void visit(ResourcePattern pattern, IvyArtifactName artifact) throws ResourceException {
                MissingResourceException failure = null;
                for (VersionPatternVisitor list : visitors) {
                    try {
                        list.visit(pattern, artifact);
                        return;
                    }
                    catch (MissingResourceException e) {
                        if (failure != null) continue;
                        failure = e;
                    }
                    catch (Exception e) {
                        throw new ResourceException(String.format("Failed to list versions for %s.", module), (Throwable)e);
                    }
                }
                throw failure;
            }
        };
    }
}

