/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.transactions;

import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.Transaction;
import org.springframework.transaction.support.ResourceHolderSupport;

public class SessionHolder
extends ResourceHolderSupport {
    private Deque<Session> sessions = new LinkedBlockingDeque<Session>();
    private Object creator = null;

    public SessionHolder(Session session) {
        this.sessions.add(session);
    }

    public SessionHolder(Session session, Object creator) {
        this(session);
        this.creator = creator;
    }

    public Object getCreator() {
        return this.creator;
    }

    public Transaction<?> getTransaction() {
        Session session = this.getSession();
        if (session != null && session.hasTransaction()) {
            return session.getTransaction();
        }
        return null;
    }

    public void setSynchronizedWithTransaction(boolean synchronizedWithTransaction) {
        for (Session session : this.sessions) {
            session.setSynchronizedWithTransaction(synchronizedWithTransaction);
        }
        super.setSynchronizedWithTransaction(synchronizedWithTransaction);
    }

    @Deprecated
    public void setTransaction(Transaction<?> transaction) {
    }

    public Session getSession() {
        return this.sessions.peekLast();
    }

    public boolean isEmpty() {
        return this.sessions.isEmpty();
    }

    public boolean doesNotHoldNonDefaultSession() {
        return this.isEmpty();
    }

    public void addSession(Session session) {
        this.sessions.add(session);
    }

    public void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public boolean containsSession(Session session) {
        return this.sessions.contains(session);
    }

    public int size() {
        return this.sessions.size();
    }

    public Session getValidatedSession() {
        Session session = this.getSession();
        if (session != null && !session.isConnected()) {
            this.removeSession(session);
            session = null;
        }
        return session;
    }
}

