/*
 * Decompiled with CFR 0.152.
 */
package org.grails.validation.routines;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.grails.validation.routines.DomainValidator;
import org.grails.validation.routines.InetAddressValidator;
import org.grails.validation.routines.RegexValidator;

@Deprecated
public class UrlValidator
implements Serializable {
    private static final long serialVersionUID = 7154620567871023850L;
    public static final long ALLOW_ALL_SCHEMES = 1L;
    public static final long ALLOW_2_SLASHES = 2L;
    public static final long NO_FRAGMENTS = 4L;
    private static final String AUTHORITY_CHARS_REGEX = "\\p{Alnum}\\-\\.";
    private static final String URL_REGEX = "^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?";
    private static final Pattern URL_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final int PARSE_URL_SCHEME = 2;
    private static final int PARSE_URL_AUTHORITY = 4;
    private static final int PARSE_URL_PATH = 5;
    private static final int PARSE_URL_QUERY = 7;
    private static final int PARSE_URL_FRAGMENT = 9;
    private static final String SCHEME_REGEX = "^\\p{Alpha}[\\p{Alnum}\\+\\-\\.]*";
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^\\p{Alpha}[\\p{Alnum}\\+\\-\\.]*");
    private static final String AUTHORITY_REGEX = "^([\\p{Alnum}\\-\\.]*)(:\\d*)?(.*)?";
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("^([\\p{Alnum}\\-\\.]*)(:\\d*)?(.*)?");
    private static final int PARSE_AUTHORITY_HOST_IP = 1;
    private static final int PARSE_AUTHORITY_PORT = 2;
    private static final int PARSE_AUTHORITY_EXTRA = 3;
    private static final String PATH_REGEX = "^(/[-\\w:@&?=+,.!/~*'%$_;\\(\\)]*)?$";
    private static final Pattern PATH_PATTERN = Pattern.compile("^(/[-\\w:@&?=+,.!/~*'%$_;\\(\\)]*)?$");
    private static final String QUERY_REGEX = "^(.*)$";
    private static final Pattern QUERY_PATTERN = Pattern.compile("^(.*)$");
    private static final String LEGAL_ASCII_REGEX = "^\\p{ASCII}+$";
    private static final Pattern ASCII_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static final String PORT_REGEX = "^:(\\d{1,5})$";
    private static final Pattern PORT_PATTERN = Pattern.compile("^:(\\d{1,5})$");
    private final long options;
    private final Set<String> allowedSchemes;
    private final RegexValidator authorityValidator;
    private static final String[] DEFAULT_SCHEMES = new String[]{"http", "https", "ftp"};
    private static final UrlValidator DEFAULT_URL_VALIDATOR = new UrlValidator();

    public static UrlValidator getInstance() {
        return DEFAULT_URL_VALIDATOR;
    }

    public UrlValidator() {
        this(null);
    }

    public UrlValidator(String[] schemes) {
        this(schemes, 0L);
    }

    public UrlValidator(long options) {
        this(null, null, options);
    }

    public UrlValidator(String[] schemes, long options) {
        this(schemes, null, options);
    }

    public UrlValidator(RegexValidator authorityValidator, long options) {
        this(null, authorityValidator, options);
    }

    public UrlValidator(String[] schemes, RegexValidator authorityValidator, long options) {
        this.options = options;
        if (this.isOn(1L)) {
            this.allowedSchemes = Collections.emptySet();
        } else {
            if (schemes == null) {
                schemes = DEFAULT_SCHEMES;
            }
            this.allowedSchemes = new HashSet<String>();
            this.allowedSchemes.addAll(Arrays.asList(schemes));
        }
        this.authorityValidator = authorityValidator;
    }

    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (!ASCII_PATTERN.matcher(value).matches()) {
            return false;
        }
        Matcher urlMatcher = URL_PATTERN.matcher(value);
        if (!urlMatcher.matches()) {
            return false;
        }
        if (!this.isValidScheme(urlMatcher.group(2))) {
            return false;
        }
        if (!this.isValidAuthority(urlMatcher.group(4))) {
            return false;
        }
        if (!this.isValidPath(urlMatcher.group(5))) {
            return false;
        }
        if (!this.isValidQuery(urlMatcher.group(7))) {
            return false;
        }
        return this.isValidFragment(urlMatcher.group(9));
    }

    protected boolean isValidScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        if (!SCHEME_PATTERN.matcher(scheme).matches()) {
            return false;
        }
        return !this.isOff(1L) || this.allowedSchemes.contains(scheme);
    }

    protected boolean isValidAuthority(String authority) {
        InetAddressValidator inetAddressValidator;
        if (authority == null) {
            return false;
        }
        if (this.authorityValidator != null && this.authorityValidator.isValid(authority)) {
            return true;
        }
        Matcher authorityMatcher = AUTHORITY_PATTERN.matcher(authority);
        if (!authorityMatcher.matches()) {
            return false;
        }
        String hostLocation = authorityMatcher.group(1);
        DomainValidator domainValidator = DomainValidator.getInstance();
        if (!domainValidator.isValid(hostLocation) && !(inetAddressValidator = InetAddressValidator.getInstance()).isValid(hostLocation)) {
            return false;
        }
        String port = authorityMatcher.group(2);
        if (port != null && !PORT_PATTERN.matcher(port).matches()) {
            return false;
        }
        String extra = authorityMatcher.group(3);
        return extra == null || extra.trim().length() <= 0;
    }

    protected boolean isValidPath(String path) {
        if (path == null) {
            return false;
        }
        if (!PATH_PATTERN.matcher(path).matches()) {
            return false;
        }
        int slash2Count = this.countToken("//", path);
        if (this.isOff(2L) && slash2Count > 0) {
            return false;
        }
        int slashCount = this.countToken("/", path);
        int dot2Count = this.countToken("..", path);
        return dot2Count <= 0 || slashCount - slash2Count - 1 > dot2Count;
    }

    protected boolean isValidQuery(String query) {
        if (query == null) {
            return true;
        }
        return QUERY_PATTERN.matcher(query).matches();
    }

    protected boolean isValidFragment(String fragment) {
        if (fragment == null) {
            return true;
        }
        return this.isOff(4L);
    }

    protected int countToken(String token, String target) {
        int tokenIndex = 0;
        int count = 0;
        while (tokenIndex != -1) {
            if ((tokenIndex = target.indexOf(token, tokenIndex)) <= -1) continue;
            ++tokenIndex;
            ++count;
        }
        return count;
    }

    private boolean isOn(long flag) {
        return (this.options & flag) > 0L;
    }

    private boolean isOff(long flag) {
        return (this.options & flag) == 0L;
    }
}

