/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GhemicalMMReader
extends AtomSetCollectionReader {
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("!Header")) {
            this.processHeader();
            return true;
        }
        if (this.line.startsWith("!Info")) {
            this.processInfo();
            return true;
        }
        if (this.line.startsWith("!Atoms")) {
            this.processAtoms();
            return true;
        }
        if (this.line.startsWith("!Bonds")) {
            this.processBonds();
            return true;
        }
        if (this.line.startsWith("!Coord")) {
            this.processCoord();
            return true;
        }
        if (this.line.startsWith("!Charges")) {
            this.processCharges();
            return true;
        }
        return true;
    }

    void processHeader() {
    }

    void processInfo() {
    }

    void processAtoms() throws Exception {
        int ac = this.parseIntAt(this.line, 6);
        for (int i = 0; i < ac; ++i) {
            if (this.asc.ac != i) {
                throw new Exception("GhemicalMMReader error #1");
            }
            this.rd();
            int atomIndex = this.parseIntStr(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Atomsexpected: " + i + " saw:" + atomIndex);
            }
            int elementNumber = this.parseInt();
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)elementNumber;
        }
    }

    void processBonds() throws Exception {
        int bondCount = this.parseIntAt(this.line, 6);
        for (int i = 0; i < bondCount; ++i) {
            this.rd();
            int atomIndex1 = this.parseIntStr(this.line);
            int atomIndex2 = this.parseInt();
            String orderCode = this.parseToken();
            int order = 0;
            switch (orderCode.charAt(0)) {
                case 'C': {
                    order = 515;
                    break;
                }
                case 'T': {
                    order = 3;
                    break;
                }
                case 'D': {
                    order = 2;
                    break;
                }
                default: {
                    order = 1;
                }
            }
            this.asc.addNewBondWithOrder(atomIndex1, atomIndex2, order);
        }
    }

    void processCoord() throws Exception {
        Atom[] atoms = this.asc.atoms;
        int ac = this.asc.ac;
        for (int i = 0; i < ac; ++i) {
            this.setAtomCoordScaled(atoms[i], PT.getTokens((String)this.rd()), 1, 10.0f);
        }
    }

    void processCharges() throws Exception {
        Atom[] atoms = this.asc.atoms;
        int ac = this.asc.ac;
        for (int i = 0; i < ac; ++i) {
            this.rd();
            int atomIndex = this.parseIntStr(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Chargesexpected: " + i + " saw:" + atomIndex);
            }
            atoms[i].partialCharge = this.parseFloat();
        }
    }
}

