/*
 * %kadu copyright begin%
 * Copyright 2015 Rafał Przemysław Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "jabber-resource.h"

#include <QtCore/QObject>
#include <QtCore/QPointer>
#include <QtCore/QVector>
#include <injeqt/injeqt.h>

class Jid;

class ChatTypeManager;
class Chat;
class Contact;

class JabberResourceService : public QObject
{
	Q_OBJECT

public:
	explicit JabberResourceService(QObject *parent = nullptr);
	virtual ~JabberResourceService();

	void updateResource(JabberResource resource);
	void removeResource(const Jid &jid);
	void removeResources(const QString &bareJid);
	void clear();

	JabberResource bestResource(const QString &bareJid) const;

	Jid bestChatJid(const Chat &chat) const;
	Jid bestContactJid(const Contact &chat) const;

private:
	QPointer<ChatTypeManager> m_chatTypeManager;

	QVector<JabberResource> m_resources;

private slots:
	INJEQT_SET void setChatTypeManager(ChatTypeManager *chatTypeManager);

};
