key1_public = <<-RUBY
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

mI0ETbL4sAEEANBs/WsOxRCLdsW1h8LKGT6eJpAs6omGV/G7TJnMsk92BUIub3oZ
9oRC1L0l4EKB6o8/vULziT815dbbVxwQIOyDXEqP4sokRxjSNNkpPb+RuIjdmP6e
SJ2NxCxV/GxLhjZZTHG5SPH4Gei3TtdiHMHoar0rwEcVdS693K/6Ww8ZABEBAAG0
IVRlc3QgbnVtYmVyIDEgPHRlc3QxQGV4YW1wbGUuY29tPoi4BBMBAgAiBQJNsviw
AhsDBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRD7yLd2W11cdyxOA/4gPEK1
qF8bp0YJfc91Ob/J70N5gNuO06AeBa8o6MHTUheCp5CMFD8RISDegsiYey3O+Wvk
rg+BmIQWqGTglDIDOM8B1Bmc+T+C0sRwIwmHqDo5a9mR2QnlcFqZ3SNV5MdxDUa4
GJk4LbUj/JwU2nR8Z4eA7OC1LjOexFKAfLX657iNBE2y+LABBAC9UqqJKhUDqhDy
dPfMsQYOA14QPcx8cx5hsUyLsZOm9RGxNdw8fRItfMZWfwB69pr4KicVYxC5YyxM
+KpVBHr+QoTxEn/KcMdude44Y104F33oZ2wiCpMzCu1ZW/OFIoWuEMHXLyIXJD1C
VVMkbiOjwRxo3otPSGijrhcmS0PkJQARAQABiJ8EGAECAAkFAk2y+LACGwwACgkQ
+8i3dltdXHdf/wQAiIKzJaUg5S+EU3lr9XZPIDZeNcQpKf2JaLu4uFVPtKGtZIYa
F00HCKom4OHkrFfdVdr1948xet9sAt2PV9GoIAV8pkBwqs02Wz6mxJpgsnAuEJTM
Pwe30z4usZ5kM/PDMCpN+A9vkzYieyxquvkul2W7VfzLftx81UexyoFnJ9I=
=u++L
-----END PGP PUBLIC KEY BLOCK-----
RUBY

key1_secret = <<-RUBY
-----BEGIN PGP PRIVATE KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

lQHYBE2y+LABBADQbP1rDsUQi3bFtYfCyhk+niaQLOqJhlfxu0yZzLJPdgVCLm96
GfaEQtS9JeBCgeqPP71C84k/NeXW21ccECDsg1xKj+LKJEcY0jTZKT2/kbiI3Zj+
nkidjcQsVfxsS4Y2WUxxuUjx+Bnot07XYhzB6Gq9K8BHFXUuvdyv+lsPGQARAQAB
AAP7B/aQucP7HP5LF9OEn+6t8hHDn5YLvEc3pHV3atfihyfXRxee7DoXjFGWWbIG
WbF8104Zing4tJjNUtJssgE0FMDq1EmcDjYjMPwNUrmaPhlbsnCpqtiIdjsJbdsh
39Kl8MG1EDSInwq2ToVyQGfFywClUYYQmqCbVEmaeoocZMUCAORfTj82VyelybRV
p6JYvg9oIBuUZh6RUFsWtXVxs5pqNKN70/5SnFzIaukY3NBVqDQ1iOcLQmbYBCPn
/gDTDa0CAOmj8HhXeNq7Aof9qqvzh2YZhuyoc4BtAYGs9KJj/oLEkTkIVlcIM5yp
tYRzdQZT8RQRRD8sUAC1W2BtX+033J0CAIKIvFJnRqwhwQn+eBG7f20lPqNA8ceU
yz1vMOPZ/puOulsxuH/g0vGJ6i364Aph7UdnTjl3lCXosqmxHHgJbp+eorQhVGVz
dCBudW1iZXIgMSA8dGVzdDFAZXhhbXBsZS5jb20+iLgEEwECACIFAk2y+LACGwMG
CwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEPvIt3ZbXVx3LE4D/iA8QrWoXxun
Rgl9z3U5v8nvQ3mA247ToB4FryjowdNSF4KnkIwUPxEhIN6CyJh7Lc75a+SuD4GY
hBaoZOCUMgM4zwHUGZz5P4LSxHAjCYeoOjlr2ZHZCeVwWpndI1Xkx3ENRrgYmTgt
tSP8nBTadHxnh4Ds4LUuM57EUoB8tfrnnQHYBE2y+LABBAC9UqqJKhUDqhDydPfM
sQYOA14QPcx8cx5hsUyLsZOm9RGxNdw8fRItfMZWfwB69pr4KicVYxC5YyxM+KpV
BHr+QoTxEn/KcMdude44Y104F33oZ2wiCpMzCu1ZW/OFIoWuEMHXLyIXJD1CVVMk
biOjwRxo3otPSGijrhcmS0PkJQARAQABAAP9FheQ5duewyQzwQ8sIVsg4T68WbnU
ZEtMpsq5K23n1Goxi9PEpNxVZDB0toAwbqjbMY09rU23lGKBt2OnAK+6qEBRkdoh
9HjgVckVy/efqp2FGSFs79yv4m3EvK/lRnMhFE9/LktayhZsiKZaRmR5evqyCoRh
vWAccOngO4ww+WECAMtq4M9tTeab6SI5nH0W/RfGicH701cacRkM4KDXxs8STmTy
qugEERpuK2fTA4DjBRjv1oF+Ld5mAhExtH7gktUCAO5DFNdfdW6TifdHPpLqyRgP
7DpZlcOqVIbVwtcPrk+3nVASQ4qvCggMJT36Fif9EZqqkIIZeWQxGADZAtkblBEC
AKb9RHZNxaCY+Ax2AkI5fhwMpA/PEcyBSVes+mmlA4Zneq8YJciUFPwKdOaHU6yc
8LiuaTDNjuHLJpUZrWa2N5mdK4ifBBgBAgAJBQJNsviwAhsMAAoJEPvIt3ZbXVx3
X/8EAIiCsyWlIOUvhFN5a/V2TyA2XjXEKSn9iWi7uLhVT7ShrWSGGhdNBwiqJuDh
5KxX3VXa9fePMXrfbALdj1fRqCAFfKZAcKrNNls+psSaYLJwLhCUzD8Ht9M+LrGe
ZDPzwzAqTfgPb5M2Inssarr5Lpdlu1X8y37cfNVHscqBZyfS
=1FOM
-----END PGP PRIVATE KEY BLOCK-----
RUBY

key2_public = <<-RUBY
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

mI0ETbLs3gEEAK+Y1z0MgmwP3M5d+tGTVHKBcoi5KRJKYSbWX2Kus+vVCLvohbuf
b41pNcQh3QWY9DtnvEyFHoVnrb6fktFjbiU0y89qv7vsbleR8O5Mt82urjlsVCqp
kI3a4l4+T6a1iLR2QSF04v2e0PKECIFpSLmnjAiZUyYPaseT/h+r84uZABEBAAG0
IVRlc3QgbnVtYmVyIDIgPHRlc3QyQGV4YW1wbGUuY29tPoi4BBMBAgAiBQJNsuze
AhsDBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRA5K+LKd9ZlZu/8A/9Ql6Qf
m2LS49QZUcV4sqvUrYRqhHrXxH4NpfvcErE2aOolEtLYpIf1wFun6Cmjc9TLacW6
vJGaKfafFqQ5I4bGDAwkVik6keU58HM7vxBmWafNh2KhwzNQXIJ9yORYSfUoWGWS
yT/JDJk7mSFcSCyRKXc10PcnLUkoWwSnUtdN0biNBE2y7N4BBAC8lQFu/ru0hNvn
NpeMkkxZhgNVSaIfR7My5zznCwaVQzud6ZH2zcQUmfina12vRNqA7TBaQyc/Ebsd
z/PkMCCXPDyaUgp1EJKdVd5nUnO/6yEinf1zkI5kpYd/dKSMcbMIOdEUeBsOUR7Y
g6uPoNK40Dwmg3vH5rsSEcrupzWeHwARAQABiJ8EGAECAAkFAk2y7N4CGwwACgkQ
OSviynfWZWZJ4gP+KI9e9fjpCVLXVA3mH459+kWwNOMWrTImk0CXFGIS/sm7cODu
zLJNS32muxaHisbIDVcK/vac3wksa0DjgiIQa08yI40F7V9y6FsS/PxvPO8Hi9AX
AjUk9I7RWu3E2loIHgYeTBwXyKLmWr5ZVfpX6KvIa4Y3MTRnE0x6+woeT90=
=DclA
-----END PGP PUBLIC KEY BLOCK-----
RUBY

key2_secret = <<-RUBY
-----BEGIN PGP PRIVATE KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

lQHYBE2y7N4BBACvmNc9DIJsD9zOXfrRk1RygXKIuSkSSmEm1l9irrPr1Qi76IW7
n2+NaTXEId0FmPQ7Z7xMhR6FZ62+n5LRY24lNMvPar+77G5XkfDuTLfNrq45bFQq
qZCN2uJePk+mtYi0dkEhdOL9ntDyhAiBaUi5p4wImVMmD2rHk/4fq/OLmQARAQAB
AAP8D1bzoZeGyrQhis0asMV1NHoStHcxa3HANi12wHcIzG6sMEcmLJ9nVjQFUISR
S3CC0HA12rzrz0VhABSuVZihKd2dEVFQiY2BfpZ0j6XVoUF/w+wB1KJ73et6AsyY
f3iLtu/OTQeOC68EKi08yogRu/EFo25vVOhyIhQF5rDMkxECANKDcGkmJsZZr7+V
GqJS5mHLHy7aI7aN8f4uEQx/QXK3MW5PA12KgNc91kT8MbTYueI8/yNZe/DtBpji
yUelpZECANWJ/9L2gEgXDggcYe5+f7kYzxhkEjypX3Ewkza7CRWUqS2Bz8GzmFls
8s+UhiyWJAMZ/uNUy6YPawUoTnZyYYkCANCoKZfKw0zHypZ7HhH1znmdQkte+sJc
G9604Os1RGVO6Tu30fCd7AaStPc4qfAPwJDDaSCLzMN9U6VGROaW9Iyff7QhVGVz
dCBudW1iZXIgMiA8dGVzdDJAZXhhbXBsZS5jb20+iLgEEwECACIFAk2y7N4CGwMG
CwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEDkr4sp31mVm7/wD/1CXpB+bYtLj
1BlRxXiyq9SthGqEetfEfg2l+9wSsTZo6iUS0tikh/XAW6foKaNz1Mtpxbq8kZop
9p8WpDkjhsYMDCRWKTqR5Tnwczu/EGZZp82HYqHDM1Bcgn3I5FhJ9ShYZZLJP8kM
mTuZIVxILJEpdzXQ9yctSShbBKdS103RnQHYBE2y7N4BBAC8lQFu/ru0hNvnNpeM
kkxZhgNVSaIfR7My5zznCwaVQzud6ZH2zcQUmfina12vRNqA7TBaQyc/Ebsdz/Pk
MCCXPDyaUgp1EJKdVd5nUnO/6yEinf1zkI5kpYd/dKSMcbMIOdEUeBsOUR7Yg6uP
oNK40Dwmg3vH5rsSEcrupzWeHwARAQABAAP6Aptku64V1jcH+zhL/AuBtrMdlK5B
6YDKP2fm9aK3YpTdXB+AfxL1JPvD7jyTvPqMsr+UrYrEHiEWnyDi1EK+EJMSnaUb
hHRFBtqapnzhJ2qXLcM8PHV5aby7dMhpMXSvF+gJEtsdSPuX2Gcuc/iNXwdymacJ
M1SY89MUbmNqvQECAMsmTUb9CvHed7xPoHAHZuAIhnvNaVosLsfnO+v78zh+8P8X
mjsT11u1ayW3wbfsY8EGOx82RnZ7hEWcCPvBk98CAO2kgj4mZ1rA08LzoAYgibdK
PaQqeZ+IS91J7+7zzB580xiKUg/HVBjHzbZvPYUPI6mX8JShhFI3heB0jq8XPcEC
AM3HHAlOqxtrjk3Cpvrcg/LPP2CSJ/rSY9Sj9izUfuZLGjJGRVogjpp5YFPJWieE
CA5Lkzv2+Hb2KQRjpmmLEqigdYifBBgBAgAJBQJNsuzeAhsMAAoJEDkr4sp31mVm
SeID/iiPXvX46QlS11QN5h+OffpFsDTjFq0yJpNAlxRiEv7Ju3Dg7syyTUt9prsW
h4rGyA1XCv72nN8JLGtA44IiEGtPMiONBe1fcuhbEvz8bzzvB4vQFwI1JPSO0Vrt
xNpaCB4GHkwcF8ii5lq+WVX6V+iryGuGNzE0ZxNMevsKHk/d
=KmYO
-----END PGP PRIVATE KEY BLOCK-----
RUBY

key3_public = <<-RUBY
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

mI0ETbLs+QEEALBpfCzDVNDWw2jWBpmNAScCmdX92voNSp+Jd0GFhabDbmfasAwO
rEKAn/PgQCOdHNT8m7EHUCTDOB2vBe360IE8+q9OylF10I6PSMvyoXHnwL/UQ4BO
dcgYYE54AmensPWlYxLlLu34gnKgSEnNULee9x4KnVfeidNj1gpQTenlABEBAAG0
IVRlc3QgbnVtYmVyIDMgPHRlc3QzQGV4YW1wbGUuY29tPoi4BBMBAgAiBQJNsuz5
AhsDBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRA0d6XcPemRge3TA/9jNcgZ
ad7j6R7yUL2lYw5jeSuyiIiRzwxb8PzEOzEAUBaLBWGsLunwDjU6ZTSckNUxjmf9
sHkeAb1WmYSidsHpLaljLp/dtsYgUQg6wUNjv3VEyeT9oViEVxr6RIYyd6kTQAUK
kHjiaRXftqcgDfhgI/+Nzd8gYZxGeMudnsavcLiNBE2y7PkBBACwoV1uFEtxoufH
KMqBWMdCY8B/0D4ytgjjXBqwRN1k6QFEqUe/A+Nf8ZVE8lNyb8BHwMVoS4auOKLs
g4JeIlwvEeFAlsdABlUtkEKJEcxns3nxmCw8koiWkk9KDY9rk3ZU0UweLDFshYq/
1z/+QueKdx6uJZAHKM3DoBqpEqomhwARAQABiJ8EGAECAAkFAk2y7PkCGwwACgkQ
NHel3D3pkYFGagP/YvAIsOb5ve9441FXwlkjiGCiUugfC/8Mw7U+ufGjbDkjSgOH
+WE+Rx+iUMT55JoQX8G/bephtYq0YSa1kyKOebOc08ZBPWH/4sK/UFjnVBdCuglj
tsU3JEa9ma0EN5Iwj8cHpvzATsxS5zCIEfDYHIHNhGhnpFp4GKgN6cXD2QY=
=T5Nu
-----END PGP PUBLIC KEY BLOCK-----
RUBY

key3_secret = <<-RUBY
-----BEGIN PGP PRIVATE KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

lQHXBE2y7PkBBACwaXwsw1TQ1sNo1gaZjQEnApnV/dr6DUqfiXdBhYWmw25n2rAM
DqxCgJ/z4EAjnRzU/JuxB1AkwzgdrwXt+tCBPPqvTspRddCOj0jL8qFx58C/1EOA
TnXIGGBOeAJnp7D1pWMS5S7t+IJyoEhJzVC3nvceCp1X3onTY9YKUE3p5QARAQAB
AAP4+Ayv6LVxlrhj8HtdyG+Ja2YX/GYaxR161dxPyZ0h4cVLDec1QhwCe/Q9Mrad
DG7I0+DhX4CCIpPZD+PwmzjIuIrw+CeCVFyYwnKzbjSQMCHbQaiZhCmiqItoe/P/
mf3rTX7hh6H02VtRhMcSPfFv7ckWiHz3Zc5PEUvS5E+B4QIA0b6ddoIyeEdvlrmj
IZs2gMvpj5p7ksuRX+Wo04Dw2v5qoYFamgq+junLwjo2hKP2WzE6ocAYiFycE8/i
NzG5xQIA11EKhP8nuAbLzkbz45m3o858MgugBB062rg1dcjXEd9b8CqhdLI8btPG
Nxav7bRD1HG5wEaZrHidyIohjwoRoQIAnuFG4PG878SbY+Gj3Qu9qme7k6D046Yc
quNSOeSfdqpYq5OEc3EtPkYonEgA9yBWzDHlLCz4+QOsGl0vBaltCawItCFUZXN0
IG51bWJlciAzIDx0ZXN0M0BleGFtcGxlLmNvbT6IuAQTAQIAIgUCTbLs+QIbAwYL
CQgHAwIGFQgCCQoLBBYCAwECHgECF4AACgkQNHel3D3pkYHt0wP/YzXIGWne4+ke
8lC9pWMOY3krsoiIkc8MW/D8xDsxAFAWiwVhrC7p8A41OmU0nJDVMY5n/bB5HgG9
VpmEonbB6S2pYy6f3bbGIFEIOsFDY791RMnk/aFYhFca+kSGMnepE0AFCpB44mkV
37anIA34YCP/jc3fIGGcRnjLnZ7Gr3CdAdgETbLs+QEEALChXW4US3Gi58coyoFY
x0JjwH/QPjK2CONcGrBE3WTpAUSpR78D41/xlUTyU3JvwEfAxWhLhq44ouyDgl4i
XC8R4UCWx0AGVS2QQokRzGezefGYLDySiJaST0oNj2uTdlTRTB4sMWyFir/XP/5C
54p3Hq4lkAcozcOgGqkSqiaHABEBAAEAA/wLlyMm4I0M0WhNMNeNAlLc/+e3W2Zh
dIGDzdzweSxf/Uw4gbU0CyDGAHfPlOk15rBi5PrvO5mEYDIMvBp3a+DJmAUSZJFl
aFIOIemhYYildvoIDisBtkdR35+/5WBCYRRgawo1jPo8v3icK++FWjJe6R5Y4GTD
1WEltWM8S0x/aQIA0VzMSeSt4gRpjafjnyUATMGa8eYAgydOHiwkqIsMnm0m1Zua
P/VBvkFxUKs/62GWr0USrn6TShdTChDu4Q1aXwIA1/n3utDkfGOrKL7w3CplMP8O
SAmzqh79VSzoT7oBW+oqapy/JFpN+hJ5FeIVPWCP8/HlHdtq32X7hbNuQ4r02QIA
ytqWvM//YeZcoUfckrxumMpEW613YYMCbIDW51EauKFrAxK1hqHl1I8VwXs8H+6v
JvDNxSddjC/bMZ/QivwJyaDfiJ8EGAECAAkFAk2y7PkCGwwACgkQNHel3D3pkYFG
agP/YvAIsOb5ve9441FXwlkjiGCiUugfC/8Mw7U+ufGjbDkjSgOH+WE+Rx+iUMT5
5JoQX8G/bephtYq0YSa1kyKOebOc08ZBPWH/4sK/UFjnVBdCugljtsU3JEa9ma0E
N5Iwj8cHpvzATsxS5zCIEfDYHIHNhGhnpFp4GKgN6cXD2QY=
=QWZy
-----END PGP PRIVATE KEY BLOCK-----
RUBY

key4_public = <<-RUBY
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

mI0ETbLtDQEEAKBGC+ZlPZitUGQ76XxF8xm3qCAwm30xitHq4jAItbQ6GfsVZb1r
jKjOcupf2LPDrnhCZ5eTXvFCc4mqvv3fJAeoAD6nEIQmG7DYeYoGwVztFTRajLFG
krgchcYpopi5Xq5IUe57UaFMt6SEqzajAJWSD6303rHIJJ/2SaQA0wEZABEBAAG0
IVRlc3QgbnVtYmVyIDQgPHRlc3Q0QGV4YW1wbGUuY29tPoi4BBMBAgAiBQJNsu0N
AhsDBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRAKfJF4Vk6CPfZcA/0b7FZE
zvsNdxESao+UO0ReXIVKT3vl+7NdauiSsQQsg0/zxxXxctmAq6oalHg1pbQLWxgI
uKPH1sxgSOZ1LGWEPENRwi9oVv6ENJVKcX87OUdCPu3gryr6os0oSSpXzYTEFBgJ
RNJdqL7+Y73P9glMhzDb1eZM0TFHI2nr2fzfe7iNBE2y7Q0BBADY38LZ3YAIgq3r
k54Y6x3mN5TyMTex994jC91UCYqHFwhIM2v0UlsA/QkqbS8nbqOH2zDzEFs29Wcv
cUeHWBQaAtiHr/izNy4Qo9pXW3eI5vDfeXEB0MGk21JqabPLWTd5zcNlXXfr6TxK
0+h9Ivbk0mPSP/E3XcUrJtJyml6ilQARAQABiJ8EGAECAAkFAk2y7Q0CGwwACgkQ
CnyReFZOgj1NWwP9FKrmuEN+RfsPsVHEv0liGFyKbcyteB+12Zp+aNzMddCOLYXA
jvoMv2F+WfrAvzdwUeYWq93An6w44TV7GfsVky8IDHXZ4wAnUrE2tuCvCPqUToVV
OBjCYD0To97vULkS/+bU1+jAE3IYtedYNFdGhd0cm4kLzFVlAzc9xDLTp08=
=Emj0
-----END PGP PUBLIC KEY BLOCK-----
RUBY

key4_secret = <<-RUBY
-----BEGIN PGP PRIVATE KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

lQHYBE2y7Q0BBACgRgvmZT2YrVBkO+l8RfMZt6ggMJt9MYrR6uIwCLW0Ohn7FWW9
a4yoznLqX9izw654QmeXk17xQnOJqr793yQHqAA+pxCEJhuw2HmKBsFc7RU0Woyx
RpK4HIXGKaKYuV6uSFHue1GhTLekhKs2owCVkg+t9N6xyCSf9kmkANMBGQARAQAB
AAP9EKVFvh98prs1UruwM7J2HZEn+nPh6j43ezbIWBHHgVjZcuzVfLdLTAro/3OF
56GmoKHQ7XqmTStIIZ+kp2xB6wmQnQ8bxjOwWZ40/hH/r57Ednz5nflJQeknXvlV
j6sxJKJppyfu5bk9ouwV/ImOOicOwjBWT6ZxiA8BNhWN0JMCAMdLskpD1OYaNHcg
Vlt1IXNEG4yUpdPjtlCoCNd4fy+BCvBkXQ44dtsV6XH0E3Z2DX/gantvioui315f
2Iez9CcCAM3gD0dGAZ6m9pOcjYqMNFAL6TqV+cY/LonBCZar+IZ4E2dWdn5Nqj3A
pBWYl7ENziYL7/4uvqYrHXQw/UKgaL8B/0weNCbxJEelVihv6ULpAfisLE7a/qlI
5hu3jnTwoVzZFPLUO7/UYuZFlF6R2mzrVzxzCvsax7phAoV18CEPiuKg27QhVGVz
dCBudW1iZXIgNCA8dGVzdDRAZXhhbXBsZS5jb20+iLgEEwECACIFAk2y7Q0CGwMG
CwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEAp8kXhWToI99lwD/RvsVkTO+w13
ERJqj5Q7RF5chUpPe+X7s11q6JKxBCyDT/PHFfFy2YCrqhqUeDWltAtbGAi4o8fW
zGBI5nUsZYQ8Q1HCL2hW/oQ0lUpxfzs5R0I+7eCvKvqizShJKlfNhMQUGAlE0l2o
vv5jvc/2CUyHMNvV5kzRMUcjaevZ/N97nQHYBE2y7Q0BBADY38LZ3YAIgq3rk54Y
6x3mN5TyMTex994jC91UCYqHFwhIM2v0UlsA/QkqbS8nbqOH2zDzEFs29WcvcUeH
WBQaAtiHr/izNy4Qo9pXW3eI5vDfeXEB0MGk21JqabPLWTd5zcNlXXfr6TxK0+h9
Ivbk0mPSP/E3XcUrJtJyml6ilQARAQABAAP6Amin1s4k7iiaFcKtD/H1QiRDZquW
cVxYrrMiyUcVhLnELohzA5gc6SZRAVQ29h0+j+jRbXMKJFKLoRqvv0iCk/XOtEFO
keuBQwE3depOiy7lHl6LYd4q3tbu23dKEGnpa8bvQujEJa/uzt9WX90IS80pUGkf
EUjquOZrCLTc0skCAN87u9Ezy9x9z55KtiCjoMCCod98elSX9mG+tbfOAmRsmBkV
RU0Bzvz/465EQPcv3EthgBaH1ri3dnP1KUorOl0CAPi1Efg1+tE7SOm7MVt9maC9
zh4LAnD4tNhYr93CmnQw85NQmggtRW0/qnk6MF0TM/nS9tVWIFINcqYrDb0JtZkC
AOWgGo5NFrrYnSpE2afTkuQZjKzxED98MmgjCKdEV4eRE8j8IWGsgD+l4kp/+fL+
wPMzfTjcV/XVdhEMPTPPFE6hmIifBBgBAgAJBQJNsu0NAhsMAAoJEAp8kXhWToI9
TVsD/RSq5rhDfkX7D7FRxL9JYhhcim3MrXgftdmafmjczHXQji2FwI76DL9hfln6
wL83cFHmFqvdwJ+sOOE1exn7FZMvCAx12eMAJ1KxNrbgrwj6lE6FVTgYwmA9E6Pe
71C5Ev/m1NfowBNyGLXnWDRXRoXdHJuJC8xVZQM3PcQy06dP
=SMnt
-----END PGP PRIVATE KEY BLOCK-----
RUBY

password_key_public = <<-RUBY
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

mQENBE20i3MBCACuRmguvjHCkZaJGu9mD/vMa4ytavXYLqQ0HBQe6RAqVarAidFf
bKfIAuaqg9xRpnNpDL+hPqbOiYcxy6USw0hvEhLUem83KHIwU8t6+Fu5vRYOxgch
R/t66N9+B5TfxXg5fAKl7dKesXXw1VwS6jnmjWB1NaWwfmhRkbSQbCRKW38JNQ6t
xysZnFDtqmp1Y/vb4LZ8Q87ITfHkxLAfPKEFh25qMfXB/iXgP4NnFOFH1bZ9sz4E
cX0sXEAXKtrpHFOg78qTQaucKu7fBJo+r/crAK7SWutGCv5R5kE+sLNWsOdgFz4k
CdwgxQeK0URwMF9kNHb/HHwfiWUZZrkAu0sxABEBAAG0M1Rlc3Qgd2l0aCBwYXNz
d29yZCA8dGVzdF93aXRoX3Bhc3N3b3JkQGV4YW1wbGUuY29tPokBOAQTAQIAIgUC
TbSLcwIbAwYLCQgHAwIGFQgCCQoLBBYCAwECHgECF4AACgkQ8QmEM7hLckmStQf+
JYFRx82ufCAZ4PjcXJJJsb1M4jhUo9/mOdWaQy19E5n6OM1heG5dWgoPTBL8t96G
XQmum9zD2bI6hOIT/0z85Sm/+tbQwZUUba9Rw8/NHnjOuvVxr6DHQOtC86LezIY0
zrVk6sfCDw0Ll/i3q8zjY5oZw7VOOhCwPd6vhWtdPfW5QQ8/gC/gAGZiHm6Cf1nf
JV+WRtyUKNnlDVa9iPe4CdTGQfqqgpMWEoHV6NKfQ69A2dNA1SRX2XEecoEXwcnq
HVO9NqZDdr3NFfMmDEo7vAD77d7hXEFE4MBR5E2C91P+sOuOTVDjVQ3tucJ7qesw
puyJCPsWWsd9omxTze+RYrkBDQRNtItzAQgAlHfZpWMwcmi1YpGDFdALSk4pozBV
jjc9QsrWGozmJUpI1SAXOto3k3apR4lPzBsUOuf3bAt2A2e0CWPpCUWPByzm/Hpg
nIOPAK6Ab9hGpSGSObegz6mNUbhDopmh0XojejWm3CExtBadIY8ukSKOZSqnWsO0
MQ08eW5xMApqeajtTY8U2U4tVT3BGw0XM5Tqrtg05e0GmYa3wGssjI6f7A1i0InB
oAxy3AYL2jVPkODsPiUwK6DIfpsc+FQk4ouWfZcp3sgOJXhcoOaL6/Xpb/Rzpy+G
HaO9+xU/btkcx6IQV0icygFNxcQUDbBBESjDVoRvDbAtWg0rXkeK9N5bAQARAQAB
iQEfBBgBAgAJBQJNtItzAhsMAAoJEPEJhDO4S3JJS7EH/Rl8NOMaLFs7wpghmoqo
PHQhzkcV8zXJ8gwT+2qAz1Et9oyU1pHBT/1E+8XqrMlXQhcCevhmwlQdIIQpfzXZ
eserXabPKrwPDkwPoajVFLVc1WPHzBbmuBP/7XSgEXxfKXE8qA3nAkiidnfdA7ww
WB+4iMYnsimKAQxTLQvwZE3twnt+5hPbtg89BSaYSv2WuBkh/qAb8DxoffjenTko
RPX4fQDveZa4UswstJNM1s1hq/idQtCzgrRw0/ZD2g/hupBbXlM7dm+Iiuy+hMFM
G4bNiySxInxh/nfvsvlz9xgePjqxptjVggEVVkKHvkb8Z+MX+/N632WOVkIw2HFB
tck=
=hRl0
-----END PGP PUBLIC KEY BLOCK-----
RUBY

password_key_secret = <<-RUBY
-----BEGIN PGP PRIVATE KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

lQO+BE20i3MBCACuRmguvjHCkZaJGu9mD/vMa4ytavXYLqQ0HBQe6RAqVarAidFf
bKfIAuaqg9xRpnNpDL+hPqbOiYcxy6USw0hvEhLUem83KHIwU8t6+Fu5vRYOxgch
R/t66N9+B5TfxXg5fAKl7dKesXXw1VwS6jnmjWB1NaWwfmhRkbSQbCRKW38JNQ6t
xysZnFDtqmp1Y/vb4LZ8Q87ITfHkxLAfPKEFh25qMfXB/iXgP4NnFOFH1bZ9sz4E
cX0sXEAXKtrpHFOg78qTQaucKu7fBJo+r/crAK7SWutGCv5R5kE+sLNWsOdgFz4k
CdwgxQeK0URwMF9kNHb/HHwfiWUZZrkAu0sxABEBAAH+AwMCZHky5xgtPjJg6t8w
d5qqyiWnpWKLnbBfovfx9OVk1WDkdK52TpaX1xZ/BKPgCDNMh/srsZ0NUaiOubnT
mojjrN25uoqKzEKry9pkQ4ZVz2ihoW0r3lwwNfvdCTsrov/JQkGk6GzZ5OECqvcU
RR4ar4PfbKcMBrovfGvG9mnaKfQWxwaCRLU4pJKCW5yFzvkW5NXDkHsRqvz0ItFS
iaqqycwYg6fnl8b1c0mga9QCqOElR6h6vfZTYaj5dnzt+brhBNLbBcovXa/GMSvo
VvsiaoLa/1/oEii7ak2ZwdegUnE2+qAfXXwOELqGu8+mp9jisB17uXtXj+dRRNNj
02ccPegdibwy74MtcOqQo9OHGUJA7EjZ8TYTB3ZOdRUYnmLKTHG5rCI8q4QJnPck
yyjtELpbd8TMXTNwkHqh4NoDLC1SahizvZvcgYNxmXlfB89vYPvfNjrIYybBWioJ
x8oCJG1RDNrn75XZlkzvIHV5CsNWHDlcjAJ5CAkj/Y79nFEUfmK6zvfe7cdSV9Fj
tUyLUkHAgZ4lYU9E3Gzbbw1iMNI0/OBtCE/eG4xPk9gJ2ITYcmRThPkpV/nsP2Bq
enWj1j3ZfFv+toXs7tV/oLY0qlo5my0IlEqBkslhJdNUwje+Dn3GVvlVb/ShZfz5
QNf7tY+8fmvFYbphLklGoLRBG3mV1hRYseEsXOsU1hM6G6hRWFnNCKk3tL1k0rwd
qonLkbnbIQQwmeIaG1FFxhIfEqByNM4LxH1LXWHX8ccYvvrrbN3qy0Z130AeaHXx
riS7dm4EjlHzMh3q2HZHq3/nzJHJ4ZOLucFnhUA9O1JQTHzYoSzCGMQWCnCm26WB
cNJuVj8P/UrNJnFp7syT3S1L8wqJ3bOa2glTgMoJLFHcLVJDuCbFrjz7p4IBNX53
T7QzVGVzdCB3aXRoIHBhc3N3b3JkIDx0ZXN0X3dpdGhfcGFzc3dvcmRAZXhhbXBs
ZS5jb20+iQE4BBMBAgAiBQJNtItzAhsDBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIX
gAAKCRDxCYQzuEtySZK1B/4lgVHHza58IBng+NxckkmxvUziOFSj3+Y51ZpDLX0T
mfo4zWF4bl1aCg9MEvy33oZdCa6b3MPZsjqE4hP/TPzlKb/61tDBlRRtr1HDz80e
eM669XGvoMdA60Lzot7MhjTOtWTqx8IPDQuX+LerzONjmhnDtU46ELA93q+Fa109
9blBDz+AL+AAZmIeboJ/Wd8lX5ZG3JQo2eUNVr2I97gJ1MZB+qqCkxYSgdXo0p9D
r0DZ00DVJFfZcR5ygRfByeodU702pkN2vc0V8yYMSju8APvt3uFcQUTgwFHkTYL3
U/6w645NUONVDe25wnup6zCm7IkI+xZax32ibFPN75FinQO+BE20i3MBCACUd9ml
YzByaLVikYMV0AtKTimjMFWONz1CytYajOYlSkjVIBc62jeTdqlHiU/MGxQ65/ds
C3YDZ7QJY+kJRY8HLOb8emCcg48AroBv2EalIZI5t6DPqY1RuEOimaHReiN6Nabc
ITG0Fp0hjy6RIo5lKqdaw7QxDTx5bnEwCmp5qO1NjxTZTi1VPcEbDRczlOqu2DTl
7QaZhrfAayyMjp/sDWLQicGgDHLcBgvaNU+Q4Ow+JTAroMh+mxz4VCTii5Z9lyne
yA4leFyg5ovr9elv9HOnL4Ydo737FT9u2RzHohBXSJzKAU3FxBQNsEERKMNWhG8N
sC1aDSteR4r03lsBABEBAAH+AwMCZHky5xgtPjJgy11nZPkhfOcDW0DDt+S2mYDV
o0T+zYLOJ/ja/dmoXzgrWIwpi40PO5IjrOHSaEfARAiO2HSOXxmymAznuMdCaJJc
ZmBmRD/e/I1ZxtMd2QHnhHyiyUbJSi7nAE0eSrUQgCPUM/ORNIbf10DXSvFG6gZm
3m3TAfbreeRP5nsFBtAgUj0lsdpsckoY7+V3g6v+ASru2TgU0yyejpQRK/WqbQvW
jM1smi6sQg9P+4JYuUWiBMuzu3EGK6okdup8Q7a14Q7oK4TnLcVqzEKFP1evia5Y
OpJd927/VAmrymIuoPQnMIXN4qP5e2b2Gxt+f9pfxt7Qd//bhtYGgFfUnQ1+j0w5
fVfTM9hpsiIoJjhFdq2mhWf2xlHjqb1EpcXQtfwDEvxYbuGqtawKxkP+3hW7IsWJ
yy/pEKP1GnWbHVI9PooWFLGfPovBtGmYIpraQ27w8XVTgc8iy6mrE7TRXq6OgdoX
KGyMhpsOYuE2REqeRLETz9CKH3z4NVR4oPmWfgsMP8+mG7srmi/PnhvqtdetSNg2
wdqdNBH1HQSYwuNKB7GiNu15ZkqaU7vzwRqVSJLjUbSrbeJNbk4Rr3MOVD8z03nW
ch5hU3LwXKriVb/SzAFhjet/OLuiWumejrAsag/XiLAPUdyj9pjj5W6jyi8GnTKl
0PtCr4vVogndvnoMw5UJ3t1XFc8+3TwhymxCOhv2BmAfVFKiINtzkJzMyKQ8AAHI
h9sFNuMjTZzIjd/LDBM+lWUhjpKanMIrHJxGbx33JqKourLQHU4Mv8uuz8UHtnyi
skUiV4HXHI5oaRMXOH8DKn3HtiN4cHZXqQWdtEFKKXuqxKxv9h2q5UxXBIuIztYX
imAqPPJd0ztT0lswJKrNvf5ELIci5AboK1cf5v5y1iZDkIkBHwQYAQIACQUCTbSL
cwIbDAAKCRDxCYQzuEtySUuxB/0ZfDTjGixbO8KYIZqKqDx0Ic5HFfM1yfIME/tq
gM9RLfaMlNaRwU/9RPvF6qzJV0IXAnr4ZsJUHSCEKX812XrHq12mzyq8Dw5MD6Go
1RS1XNVjx8wW5rgT/+10oBF8XylxPKgN5wJIonZ33QO8MFgfuIjGJ7IpigEMUy0L
8GRN7cJ7fuYT27YPPQUmmEr9lrgZIf6gG/A8aH343p05KET1+H0A73mWuFLMLLST
TNbNYav4nULQs4K0cNP2Q9oP4bqQW15TO3ZviIrsvoTBTBuGzYsksSJ8Yf5377L5
c/cYHj46sabY1YIBFVZCh75G/GfjF/vzet9ljlZCMNhxQbXJ
=9u2Q
-----END PGP PRIVATE KEY BLOCK-----
RUBY

expired_key_public = <<-RUBY
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

mI0ETb8S8gEEAK2m1FMu8mAWS+WwnQIXLikRegUC5faHFpNNwqp9SgH4GuWxq2iQ
PfnSHRhE6qtcK6DVqJv4R6h1AfCCd1Vdgp8FtWyCA6dgxflH206VY+GgfwbK6nDs
eiCX9wFNKZjXrmesOete1oxIrqDKpNQbJ1zwGSQ+GW3KQFq4gImTiA17ABEBAAG0
JkV4cGlyZWQgS2V5IDx0ZXN0X2V4cGlyZWRAZXhhbXBsZS5jb20+iL4EEwECACgF
Ak2/EvICGwMFCQABUYAGCwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEDY/0HHE
tnipp88D/RSAytabxU9uGCba4mEla/6PJavnqA1y+Pfuvqq6mlAOPTsL/Y5TXyp7
USEgqmigdga+FHVJfZu3C+uxkIkzGjhi4iuL7nI3gGwGNd82HJL0j1WnM47brPjo
F85SxAyn0LXk77piMVlK96TfQFX0Zk+Zz8QEaW3B59O705US6Q8puI0ETb8S8gEE
ANBET93bCi3SalKuNtT5D7L7+zNgiP9xEpCIhoUbW0OVJ3Nz1iSWRLYeQsPyKnhZ
Ws1Gv9Bp7MC5iOP1jtPd81elrwN71o+4xT7nv3Hvz1JzuhrYFC/wKcz1DG/Diset
jKPJu/W8ip0K5jYvDIUrDO8g9jCc8m80wMhxMzpsVNhnABEBAAGIpQQYAQIADwUC
Tb8S8gIbDAUJAAFRgAAKCRA2P9BxxLZ4qbMOA/9XY586CtP1QCVvIdlJVVuLc/mu
I7IVAp03q4hqA6ykooLFu3FzYFTCENcyvemEB4TJhfG6XYmrq5N0jOrl6BB/ONLc
37OBnsxWQBKVbn7yzDb6WzsMtAlQ8Q8S5oYbIWSt+nUoE5slZ+tx9ngzLG20IpUH
sunYPhvnuBAfIRuA0A==
=tKG5
-----END PGP PUBLIC KEY BLOCK-----
RUBY

expired_key_secret = <<-RUBY
-----BEGIN PGP PRIVATE KEY BLOCK-----
Version: GnuPG v1.4.11 (Darwin)

lQHYBE2/EvIBBACtptRTLvJgFkvlsJ0CFy4pEXoFAuX2hxaTTcKqfUoB+Brlsato
kD350h0YROqrXCug1aib+EeodQHwgndVXYKfBbVsggOnYMX5R9tOlWPhoH8Gyupw
7Hogl/cBTSmY165nrDnrXtaMSK6gyqTUGydc8BkkPhltykBauICJk4gNewARAQAB
AAP8DWaEl6kiZRqmkrwO8bYn05CyS0HoMx6rnFE+ed+fRW86/1ZQzvBKoaux0q/T
mC1NsWSriHwfzR0loCsnprvHmsaX7O7W4PHZRN+xB9clpRGfEnHiyljWuaP8bxWg
r57fmnJ+bFoWanyxZsHoYZrVOlMa6JpQiQ+y0QUsbykTCPECAMt6Z3qc54JtU3Rt
lNzHNE7zRYt1z2fRGnOmrh0ch5TF9x+uRqQ/Am4VYe6Xzjhj6HBO7tB/n4xK4ypz
JLviw8MCANp5hw99W1AOTXpIkIS7xC9Pbx2j8AwAW5nlzyFILX+mQR/SmUX1H722
A8gj98hb6UUuf+CRzx7/FB6gk6Yzi+kCAMhcDPRgDUPggcOSdCdZDbZ78xwHwwOS
+9MT+VkIYDmOJOSer9xUdtGPcr8t/kGeICFSqZC2My38Sj1TJTs4rn2gtrQmRXhw
aXJlZCBLZXkgPHRlc3RfZXhwaXJlZEBleGFtcGxlLmNvbT6IvgQTAQIAKAUCTb8S
8gIbAwUJAAFRgAYLCQgHAwIGFQgCCQoLBBYCAwECHgECF4AACgkQNj/QccS2eKmn
zwP9FIDK1pvFT24YJtriYSVr/o8lq+eoDXL49+6+qrqaUA49Owv9jlNfKntRISCq
aKB2Br4UdUl9m7cL67GQiTMaOGLiK4vucjeAbAY13zYckvSPVaczjtus+OgXzlLE
DKfQteTvumIxWUr3pN9AVfRmT5nPxARpbcHn07vTlRLpDymdAdgETb8S8gEEANBE
T93bCi3SalKuNtT5D7L7+zNgiP9xEpCIhoUbW0OVJ3Nz1iSWRLYeQsPyKnhZWs1G
v9Bp7MC5iOP1jtPd81elrwN71o+4xT7nv3Hvz1JzuhrYFC/wKcz1DG/DisetjKPJ
u/W8ip0K5jYvDIUrDO8g9jCc8m80wMhxMzpsVNhnABEBAAEAA/0VV0Kl1amb22lY
spBcz26r5QUvFQ/EuRXxaIP8RLrb2H9T5cVGN32v+bbWtExky6cxzLOgDBKeBwT/
cuyhSieCntuxgjHoRRO8CKDSAWsjRTC/R9UpnTk+UiCrxK/2Bk7BorFbBR+lcmi9
bddoOe6p/LAFvJhK7y6OCCUqrh08LQIA4pPdh/8HdDgaHLaBkFMq3L5HVD1WfyVf
emCNIfGmE5i9JU0VRU7xPJXlEWxKmFPKdlGOAT8V4QSgLVvp7H+3OwIA60+9rWrB
i3mQgjETNM2mT0wDrXNCyuR2MdeOfCyEYY+4xBLdPs7aSsVakQrx/1B8WZkWZUNU
d7iuHlKaickIxQIA50UW9VuaMxyImLIdt2RzcLacOC98oMvZ8R/5ShkWunGOkUka
0YHOGCUAqhjwh5SFKjp3VYfy22P3YR1Usj8ETpmRiKUEGAECAA8FAk2/EvICGwwF
CQABUYAACgkQNj/QccS2eKmzDgP/V2OfOgrT9UAlbyHZSVVbi3P5riOyFQKdN6uI
agOspKKCxbtxc2BUwhDXMr3phAeEyYXxul2Jq6uTdIzq5egQfzjS3N+zgZ7MVkAS
lW5+8sw2+ls7DLQJUPEPEuaGGyFkrfp1KBObJWfrcfZ4MyxttCKVB7Lp2D4b57gQ
HyEbgNA=
=NliS
-----END PGP PRIVATE KEY BLOCK-----
RUBY

encrypted_text = <<-RUBY
-----BEGIN PGP MESSAGE-----
Version: GnuPG v1.4.11 (Darwin)

hIwDbJ4P+uQnvtQBA/9OXytdl9XAnzDZau1nTDkqpYKUp4ZoBvwASwxexj4VWX8i
jo1AuJi7pzSrBssjDsMAXcnfzHsEKh6g3xu15Gttn1oR7oB8/Q8AlC8nX8Wwsg+n
EpS/TNE/oPae8EbPCNAYuWHaGOzkH1LNQ4fpYy1q2t6+Er3uyzq0LhXTJZTM3oSM
A2c0CKWdjRgiAQQAkRQ0VPk7emnx/1FeUIlOaGgQa4KnNUw/FIZYdQNh/FJm2oTp
wunScJXvxVTZjk4eE6QAcuBH/lV1mrRF37o+7XMDuzafhT+qxqoUF8SUkCw79jrm
NBaDYWiFPkECUMcAQOL9Uk3DvJ2vxpGMJ2g0wEcrcEEikY6juSAaZX+1TwCEjAOk
LkSJkASuIQED/jza/ZOZvk6GNpDeAJbsFWc0QGlkQ0wKiPer9PUQAuNMXFnaAbvx
t9dB9AtLnnFPM8Cpg8DqLdGuWkaa5gvdjW7weLSYRo7LCYQ3ZOHUUeavAN1RLKel
IiaofRm6Bm2JDgIv1Hz0Yfj5hGylGKDT7PqA7+jXYnymjugBLVoXfP4ahIwDwk/m
ZyOifKABBACEbNa0tv5XHyzyvm/kB6AU+Lz3Ixwcp7KC6k1KE5ZYwoVg51VIOu+S
EQxQzMJrL7QfL5H1Aq4aFWHgr6I+k9sqeFr4TIAx6/H53//VIAP4+zOeGMldRwNY
AG4qd+AxLNBEr/8HoGS8h+46Vudj4ykqmOQCX4sKRaiWcUkwzdUMtNJGAeAhDfVQ
n/W/yDGzkeGlzC7Wr5Fi83c5FD+J/eSsZo+dKTlKK/zEtvKhZKvoY5gHiS20KlI0
TWl5uBcWluXyqRqnCV5uLA==
=Tsce
-----END PGP MESSAGE-----
RUBY

signed_text = <<-RUBY
-----BEGIN PGP MESSAGE-----
Version: GnuPG v1.4.11 (Darwin)

hIwDbJ4P+uQnvtQBA/sEXKjykfQvuvJdvdtc105JrjyXYmbRRbvRxI+1axeqttSd
6osDKwjBYYtYR9S3gdR0VjugFzHKP3XnbkPkeASbY4J7C3Tr0UlyZd0+0ZdIRFLa
mO9HxOjDZz3h3Sn1cl/D8JtH7KVYhbKYAEXTybUInu6jcWiXDgIQVZYpLgS0wISM
A2c0CKWdjRgiAQP+IZ93Yj+6Jqggr7NYOV+hBWAWj6NAIxx0zh1QSyPWPqBAQbQj
KlRljCX85rXHWXU2JW/BdQxBoF1ANuE3+HwZoDbwtOKFhRTuBKUN/YpphluUMmJ/
W0Wq6QL8v4+awwQX7eLE0T3FxQko57kLw//XqYsuv2RVCOYVbfQUmKHo0z2EjAOk
LkSJkASuIQED/iz3m6dONzuxuMesy6AY7gxa+Okgb7H2Is2ARGy1riNaLNhf5WZN
tsDd6QBod1i/tSwsMrbBjePPSyCyjD17QjdpieXtAqWfqwhxq0/KJtLmCwctHPnJ
1fhPp8oy+n/et0UyQgiH/yI3bxVT/39ZURIf1QstD/HGPnI5upnIn4S2hIwDwk/m
ZyOifKABA/4qTB94c2bVir7Pg1uvO6cvQwb2Pj8UUAFysZt7WHVTcvpm33lj5wkP
QyY7o2rMKSS8qAmmBWOsfAPF5gCvgp4D2Kr5FB5kYWzmFOFxuIN8ayz25BJ+4YGQ
GdWwjSPU69/eet6q7p+XydGY8jv4e6u/2tAi3b2O5Kt0th1rftOJENLAMgFgGMNE
M2S5q+RE1apf28qfqbMzSQ2Nccx+kaIkGDjieYIBhG2f3Yuh8GBdQHpyaNH0x/eY
XnHuRow0gy1jagiIDGK96N4tBOOhacR+Nf15gYMyvfZUszgwudiZP8uwUluA1w/v
+yjqnb2CVGx0iW7Yv71dxdojx7vpJ+WePHe+zJMHb260tAOmBDhjDjJ4eDqcP6Yk
d8NEvpzk2zUiB6Hb6SXPBYp+0cUQG5sYCEZQLunQJ1CeXzAfRxoyv5k7gYG/wZ5L
jVRh9AFdOceUv5zZJpiSYXYXyntWqSy4Q5zguQmzhE5Wu3mY9HYPcpAUHxbn
=rt/Y
-----END PGP MESSAGE-----
RUBY

signed_with_expired_key_text = <<-RUBY
-----BEGIN PGP MESSAGE-----
Version: GnuPG v1.4.11 (Darwin)

owGbwMvMwMRoZn+h8Mi2ipWMpwWTmHXVzH33C7d6ZCqUZKQWpXbMYWFgZGJgY2UC
iTJwcQrAVDsoMv9mvx954X+W9uzfGSVVvlE5n3yFrdn2CB/q0jr4Um5C/Notby0t
YxibhPfqpC4Sy3UMfHd/76qvBp8cZv3749/xJ2LZGT9O39nsM7yvfXsjttm1Kyv1
unDJJQnpxHlOubtKPuTkLU+aZOQtf1/zsRKTz5zv37XLTY6qWdy18fr0t1fbf8o9
jxAA
=Vta9
-----END PGP MESSAGE-----
RUBY

unavailable = <<-RUBY
-----BEGIN PGP MESSAGE-----
Version: GnuPG v1.4.11 (Darwin)

hIwDlCBoTwSpYjABA/9pn3d5xYasfQYquQzLwI0ASVuvuofjJZrYyKEYLEPHPaFn
SJOMJRFJh4lC6UfGs7xktX0bONwsdGo0EaIP6H5W+WFW0W2VCxyqLLorCWa/XFi8
Nr/2iVyj5s3QSfXGXDmnlRCf9PiAiBPPy2DzYgD3KLXMZH2hAxUtJmouuIgVWdJG
AYKArJ8pJFbrtrIiPuNIjj0yhiNGx65GIfnF32fulpgzLbyWymlpkrzRRO6sz2wl
EEdpZ6VKsLuoOb9Ou+hD6CLC3Izzmw==
=bsMi
-----END PGP MESSAGE-----
RUBY

sign = <<-RUBY
-----BEGIN PGP MESSAGE-----
Version: GnuPG v1.4.11 (Darwin)

owGbwMvMwCQo65qZfvagZjzjacEkZl01c98VK/96ZCqUZKQWpXa4sTAIMjGwsTKB
RBm4OAVgqt3PMSxYZXVcSzq4uZvry7RCp9vN31o+LTnBML+wgKFg6aJPKysdX2fc
+rtEd/85jh4A
=aECe
-----END PGP MESSAGE-----
RUBY

passwored = <<-RUBY
-----BEGIN PGP MESSAGE-----
Version: GnuPG v1.4.11 (Darwin)

hQEMAykL9/bExDNQAQf/ZXL4iUQEzoE0XfBLakpLTV5euOvdGFVPxrFS481i/Ldi
Yfpoo/gbB0yEwKnm0faCRSz2AiOQ4f3iIWRwdwoEYTbCW/o1/iXKH8fp6GXd4hQG
JdRIwr7GoGQFuOb96kZL3TbO4VapC6ubx5evxyhCIRLZPL415YXdGAcqnVvYew92
pzZn0RWe2dXDlE1HTENVvHoABnBgOOLSE/37kJJYWgsk1QJCSbaxsS6sZdJXcINQ
uqeKQKagF15DVYRA27viX0IZ9J2x9ytPQWLdf0wc8dE0h4NJiEwL6myU2WPR27xx
Lrrp3kD2wewwUSljOW/SbXS6TNLSEiLILUZkTr5+F9JIAWF1YLZTxjN9HxABuboy
wYhnVMaM+gQKDMgbIXdxim0ssq2ICHROYkbC/JTEIVXqnJbKLivfNP6J0ROHcczO
w/3/C0MallvG
=hrCw
-----END PGP MESSAGE-----
RUBY

KEYS = []
KEYS << { :sha => 'test1@example.com', :public => key1_public, :secret => key1_secret}
KEYS << { :sha => 'test2@example.com', :public => key2_public, :secret => key2_secret}
KEYS << { :sha => 'test3@example.com', :public => key3_public, :secret => key3_secret}
KEYS << { :sha => 'test4@example.com', :public => key4_public, :secret => key4_secret}

PLAIN_KEY = { :sha => 'test1@example.com', :public => key1_public, :secret => key1_secret }

PASSWORD_KEY = {
  :sha    => 'test_with_password@example.com',
  :public => password_key_public,
  :secret => password_key_secret
}

EXPIRED_KEY = {
  :sha    => "test_expired@example.com",
  :public => expired_key_public,
  :secret => expired_key_secret
}

TEXT = {
  :plain            => "Hi there",
  :encrypted        => encrypted_text.chomp,
  # Created with a temporary key that's been removed.
  :unavailable      => unavailable.chomp,
  :signed           => signed_text.chomp,
  :sign             => sign.chomp,
  :passwored        => passwored.chomp,
  :expired_key_sign => signed_with_expired_key_text.chomp
}

KEY_1_ENCRYPTED = <<-RUBY
-----BEGIN PGP MESSAGE-----
Version: GnuPG v1

hIwDbJ4P+uQnvtQBBACOzUqiKHRS8cEDPpQl1dQznpxcWW3Md8X3eFRx3+qD0X7+
aEadz/cUXf7nO9KimeO7qhqNBJoPQEzZTqirebLgq2pq+Rtp2zGCvU1hUnAmVm27
CZE/quNaBV33V0haddWm4Y8AD7e7T2a2LBDrMNGsD9eKjREJ+g/Pmm5WLRDx69JP
AaXe0Msjfyapj07hCPZptE8iP2/tCSvRDmiSgidPAZM4NnL2ANwfT6kslVha0mos
MH+qcPlxAMrMnjuWs+wFiVnWLEYfIqNzH7Z2irC2NA==
=O59i
-----END PGP MESSAGE-----
RUBY

