/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.cli.CommandLine;
import org.apache.ivy.util.cli.Option;
import org.apache.ivy.util.cli.ParseException;

public class CommandLineParser {
    private static final int MIN_DESC_WIDTH = 40;
    private static final int MAX_SPEC_WIDTH = 30;
    private Map options = new LinkedHashMap();
    private Map categories = new LinkedHashMap();

    public CommandLineParser addCategory(String string) {
        this.categories.put(string, new ArrayList());
        return this;
    }

    public CommandLineParser addOption(Option option) {
        this.options.put(option.getName(), option);
        if (!this.categories.isEmpty()) {
            ((List)this.categories.values().toArray()[this.categories.values().size() - 1]).add(option);
        }
        return this;
    }

    public CommandLine parse(String[] stringArray) throws ParseException {
        String[] stringArray2;
        CommandLine commandLine = new CommandLine();
        int n = stringArray.length;
        ListIterator<String> listIterator = Arrays.asList(stringArray).listIterator();
        while (listIterator.hasNext()) {
            stringArray2 = listIterator.next();
            if ("--".equals(stringArray2)) {
                n = listIterator.nextIndex();
                break;
            }
            if (!stringArray2.startsWith("-")) {
                n = listIterator.previousIndex();
                break;
            }
            Option option = (Option)this.options.get(stringArray2.substring(1));
            if (option == null) {
                throw new ParseException("Unrecognized option: " + (String)stringArray2);
            }
            commandLine.addOptionValues(stringArray2.substring(1), option.parse(listIterator));
        }
        stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        commandLine.setLeftOverArgs(stringArray2);
        return commandLine;
    }

    public void printHelp(PrintWriter printWriter, int n, String string, boolean bl) {
        printWriter.println("usage: " + string);
        int n2 = 0;
        for (Option object : this.options.values()) {
            if (object.isDeprecated() && !bl) continue;
            n2 = Math.min(30, Math.max(n2, object.getSpec().length()));
        }
        for (Map.Entry entry : this.categories.entrySet()) {
            String string2 = (String)entry.getKey();
            printWriter.println("==== " + string2);
            List list = (List)entry.getValue();
            for (Option option : list) {
                if (option.isDeprecated() && !bl) continue;
                String string3 = option.getSpec();
                printWriter.print(" " + string3);
                int n3 = string3.length() + 1;
                printWriter.print(StringUtils.repeat(" ", n2 - n3));
                StringBuffer stringBuffer = new StringBuffer((option.isDeprecated() ? "DEPRECATED: " : "") + option.getDescription());
                int n4 = Math.min(stringBuffer.length(), n - Math.max(n3, n2));
                if (n4 > 40 || stringBuffer.length() + n3 < n) {
                    printWriter.print(stringBuffer.substring(0, n4));
                    stringBuffer.delete(0, n4);
                }
                printWriter.println();
                while (stringBuffer.length() > 0) {
                    printWriter.print(StringUtils.repeat(" ", n2));
                    n4 = Math.min(stringBuffer.length(), n - n2);
                    printWriter.println(stringBuffer.substring(0, n4));
                    stringBuffer.delete(0, n4);
                }
            }
            printWriter.println();
        }
    }
}

